/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.event.MouseInputAdapter;

public class ActionLabel
extends JLabel {
    private String oldText = this.getText();
    private Cursor oldCursor;

    public ActionLabel() {
        this((String)null);
    }

    public ActionLabel(String text) {
        this(text, null);
    }

    public ActionLabel(String text, ActionListener action) {
        super(text);
        this.setForeground(Color.RED.darker().darker());
        this.addMouseListener(new MouseHandler());
        if (action != null) {
            this.addActionListener(action);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed() {
        this.fireActionPerformed(new ActionEvent(this, 0, this.getName()));
    }

    protected void fireActionPerformed(ActionEvent event) {
        ActionListener[] listeners;
        for (ActionListener listener : listeners = this.getActionListeners()) {
            listener.actionPerformed(event);
        }
    }

    private void startHover() {
        this.oldText = this.getText();
        if (this.oldText != null) {
            this.setText("<html><u>" + this.oldText + "</u></html>");
        }
        this.oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void stopHover() {
        this.setText(this.oldText);
        this.setCursor(this.oldCursor);
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ActionLabel.this.startHover();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ActionLabel.this.stopHover();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ActionLabel.this.fireActionPerformed();
        }
    }
}

