/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class SwingHelper {
    public static void centerComponent(Component comp, Component alignComp) {
        int y1;
        int x1;
        if (comp == null) {
            throw new IllegalArgumentException("comp must not be null");
        }
        Dimension compSize = comp.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (alignComp != null && !new Rectangle(alignComp.getSize()).isEmpty()) {
            Point alignCompOffs = alignComp.getLocation();
            Dimension alignCompSize = alignComp.getSize();
            x1 = alignCompOffs.x + (alignCompSize.width - compSize.width) / 2;
            y1 = alignCompOffs.y + (alignCompSize.height - compSize.height) / 2;
        } else {
            x1 = (screenSize.width - compSize.width) / 2;
            y1 = (screenSize.height - compSize.height) / 2;
        }
        int x2 = x1 + compSize.width;
        int y2 = y1 + compSize.height;
        if (x2 >= screenSize.width) {
            x1 = screenSize.width - compSize.width - 1;
        }
        if (y2 >= screenSize.height) {
            y1 = screenSize.height - compSize.height - 1;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        comp.setLocation(x1, y1);
    }
}

