/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.actions;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class AbstractSystemAction
extends AbstractAction {
    protected AbstractSystemAction(String name, KeyStroke acceleratorKey, String iconResource) {
        this.putValue("ActionCommandKey", this.getClass().getName());
        this.putValue("Name", name);
        this.putValue("AcceleratorKey", acceleratorKey);
        if (iconResource != null) {
            this.putValue("SmallIcon", this.loadIcon("icons_16x16/" + iconResource));
            this.putValue("SwingLargeIconKey", this.loadIcon("icons_22x22/" + iconResource));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isExecutable()) {
            this.execute();
        }
        this.updateState();
    }

    public abstract boolean isExecutable();

    public abstract void execute();

    public void updateState() {
        boolean executable = this.isExecutable();
        this.setEnabled(executable);
    }

    protected ImageIcon loadIcon(String resource) {
        URL url = this.getClass().getResource(resource);
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }
}

