/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.internal.TextFieldEditor;
import java.util.ServiceLoader;

public class PropertyEditorRegistry {
    private static PropertyEditorRegistry instance;
    private final ServiceRegistry<PropertyEditor> registry = ServiceRegistryManager.getInstance().getServiceRegistry(PropertyEditor.class);
    private final PropertyEditor defaultEditor;

    private PropertyEditorRegistry() {
        ServiceLoader<PropertyEditor> serviceLoader = ServiceLoader.load(PropertyEditor.class);
        for (PropertyEditor propertyEditor : serviceLoader) {
            this.registry.addService((Object)propertyEditor);
        }
        this.defaultEditor = (PropertyEditor)this.registry.getService(TextFieldEditor.class.getName());
    }

    public static synchronized PropertyEditorRegistry getInstance() {
        if (instance == null) {
            instance = new PropertyEditorRegistry();
        }
        return instance;
    }

    public static synchronized void setInstance(PropertyEditorRegistry registry) {
        instance = registry;
    }

    public PropertyEditor getPropertyEditor(String className) {
        return (PropertyEditor)this.registry.getService(className);
    }

    public PropertyEditor findPropertyEditor(PropertyDescriptor propertyDescriptor) {
        Assert.notNull((Object)propertyDescriptor, (String)"propertyDescriptor");
        PropertyEditor propertyEditor = (PropertyEditor)propertyDescriptor.getAttribute("propertyEditor");
        if (propertyEditor != null) {
            return propertyEditor;
        }
        for (PropertyEditor editor : this.registry.getServices()) {
            if (!editor.isValidFor(propertyDescriptor)) continue;
            return editor;
        }
        return this.defaultEditor;
    }
}

