/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PropertyPane {
    private final BindingContext bindingContext;
    private static final String DASHES = "----------";
    public static final String PROPERTY_SECTIONBREAK_NAME_SUFFIX = ".section";

    public PropertyPane(PropertySet propertySet) {
        this(new BindingContext(propertySet));
    }

    public PropertyPane(BindingContext bindingContext) {
        this.bindingContext = bindingContext;
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public JPanel createPanel() {
        PropertySet propertyContainer = this.bindingContext.getPropertySet();
        Property[] properties = propertyContainer.getProperties();
        boolean displayUnitColumn = this.wantDisplayUnitColumn(properties);
        TableLayout layout = new TableLayout(displayUnitColumn ? 3 : 2);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTablePadding(3, 3);
        JPanel panel = new JPanel(layout);
        int rowIndex = 0;
        PropertyEditorRegistry registry = PropertyEditorRegistry.getInstance();
        for (Property property : properties) {
            PropertyDescriptor descriptor = property.getDescriptor();
            if (this.isInvisible(descriptor)) continue;
            PropertyPane.addComponent(rowIndex, layout, panel, this.bindingContext, registry, descriptor);
            if (displayUnitColumn) {
                JLabel label = new JLabel("");
                if (descriptor.getUnit() != null) {
                    label.setText(descriptor.getUnit());
                }
                layout.setCellWeightX(rowIndex, 2, 0.0);
                panel.add((Component)label, TableLayout.cell(rowIndex, 2));
            }
            ++rowIndex;
        }
        layout.setCellColspan(rowIndex, 0, 2);
        layout.setCellWeightX(rowIndex, 0, 1.0);
        layout.setCellWeightY(rowIndex, 0, 0.5);
        panel.add(new JPanel());
        return panel;
    }

    public JScrollPane createJScrollPanel() {
        JPanel panel = this.createPanel();
        panel.setMinimumSize(panel.getPreferredSize());
        return new JScrollPane(panel);
    }

    private boolean isInvisible(PropertyDescriptor descriptor) {
        return Boolean.FALSE.equals(descriptor.getAttribute("visible")) || descriptor.isDeprecated();
    }

    private boolean wantDisplayUnitColumn(Property[] models) {
        boolean showUnitColumn = false;
        for (Property model : models) {
            String unit;
            PropertyDescriptor descriptor = model.getDescriptor();
            if (this.isInvisible(descriptor) || (unit = descriptor.getUnit()) == null || unit.length() == 0) continue;
            showUnitColumn = true;
            break;
        }
        return showUnitColumn;
    }

    public static JComponent[] addComponent(int rowIndex, TableLayout layout, JPanel panel, BindingContext bindingContext, PropertyEditorRegistry registry, PropertyDescriptor descriptor) {
        PropertyEditor propertyEditor = registry.findPropertyEditor(descriptor);
        JComponent[] components = propertyEditor.createComponents(descriptor, bindingContext);
        if (components.length == 2) {
            components[0].setToolTipText(descriptor.getDescription());
            components[1].setToolTipText(descriptor.getDescription());
            layout.setCellWeightX(rowIndex, 0, 0.0);
            panel.add((Component)components[1], TableLayout.cell(rowIndex, 0));
            layout.setCellWeightX(rowIndex, 1, 1.0);
            if (components[0] instanceof JScrollPane) {
                layout.setRowWeightY(rowIndex, 1.0);
                layout.setRowFill(rowIndex, TableLayout.Fill.BOTH);
            }
            panel.add((Component)components[0], TableLayout.cell(rowIndex, 1));
        } else {
            layout.setCellColspan(rowIndex, 0, 2);
            layout.setCellWeightX(rowIndex, 0, 1.0);
            if (descriptor.getName().endsWith(PROPERTY_SECTIONBREAK_NAME_SUFFIX)) {
                if (descriptor.getDisplayName() != null && descriptor.getDisplayName().length() > 0) {
                    JLabel sectionLabel = new JLabel("---------- " + descriptor.getDisplayName() + " " + DASHES);
                    sectionLabel.setToolTipText(descriptor.getDescription());
                    sectionLabel.setForeground(Color.BLACK);
                    Font sectionFont = new Font(sectionLabel.getFont().getName(), 2, sectionLabel.getFont().getSize());
                    sectionLabel.setFont(sectionFont);
                    panel.add(sectionLabel);
                } else {
                    panel.add(new JLabel(" "));
                }
            } else {
                components[0].setToolTipText(descriptor.getDescription());
                panel.add((Component)components[0], TableLayout.cell(rowIndex, 0));
            }
        }
        return components;
    }
}

