/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.swing.binding.ComponentAdapter;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpinnerAdapter
extends ComponentAdapter
implements ChangeListener {
    final JSpinner spinner;

    public SpinnerAdapter(JSpinner spinner) {
        this.spinner = spinner;
    }

    @Override
    public JComponent[] getComponents() {
        return new JComponent[]{this.spinner};
    }

    @Override
    public void bindComponents() {
        this.updateSpinnerModel();
        this.spinner.addChangeListener(this);
    }

    @Override
    public void unbindComponents() {
        this.spinner.removeChangeListener(this);
    }

    @Override
    public void adjustComponents() {
        Object value = this.getBinding().getPropertyValue();
        this.spinner.setValue(value);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.getBinding().setPropertyValue(this.spinner.getValue());
    }

    private void updateSpinnerModel() {
        PropertyDescriptor propertyDescriptor = this.getBinding().getContext().getPropertySet().getDescriptor(this.getBinding().getPropertyName());
        ValueRange valueRange = propertyDescriptor.getValueRange();
        if (valueRange != null) {
            Object propertyValue = this.getBinding().getPropertyValue();
            if (propertyValue == null) {
                propertyValue = propertyDescriptor.getDefaultValue();
            }
            Object stepSizeValue = propertyDescriptor.getAttribute("stepSize");
            if (propertyValue instanceof Float || propertyValue instanceof Double) {
                double value = ((Number)propertyValue).doubleValue();
                double min = valueRange.getMin();
                double max = valueRange.getMax();
                double stepSize = (stepSizeValue instanceof Number ? (Number)((Number)stepSizeValue) : (Number)1.0).doubleValue();
                this.spinner.setModel(new SpinnerNumberModel(value, min, max, stepSize));
            } else {
                int value = ((Number)propertyValue).intValue();
                int min = (int)valueRange.getMin();
                int max = (int)valueRange.getMax();
                int stepSize = (stepSizeValue instanceof Number ? (Number)((Number)stepSizeValue) : (Number)1).intValue();
                this.spinner.setModel(new SpinnerNumberModel(value, min, max, stepSize));
            }
        } else if (propertyDescriptor.getValueSet() != null) {
            this.spinner.setModel(new SpinnerListModel(propertyDescriptor.getValueSet().getItems()));
        }
    }
}

