/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.BindingException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.binding.ComponentAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class TextComponentAdapter
extends ComponentAdapter
implements ActionListener,
FocusListener {
    private final JTextComponent textComponent;

    public TextComponentAdapter(JTextComponent textComponent) {
        this.textComponent = textComponent;
    }

    @Override
    public JComponent[] getComponents() {
        return new JComponent[]{this.textComponent};
    }

    @Override
    public void bindComponents() {
        if (this.textComponent instanceof JTextField) {
            ((JTextField)this.textComponent).addActionListener(this);
        }
        this.textComponent.addFocusListener(this);
        this.textComponent.setInputVerifier(this.createInputVerifier());
    }

    @Override
    public void unbindComponents() {
        if (this.textComponent instanceof JTextField) {
            ((JTextField)this.textComponent).removeActionListener(this);
        }
        this.textComponent.removeFocusListener(this);
        this.textComponent.setInputVerifier(null);
    }

    @Override
    public void adjustComponents() {
        PropertySet propertyContainer = this.getBinding().getContext().getPropertySet();
        Property property = propertyContainer.getProperty(this.getBinding().getPropertyName());
        final String textValue = property != null ? property.getValueAsText() : "";
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TextComponentAdapter.this.textComponent.setText(textValue);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    void adjustValue() {
        try {
            PropertySet propertyContainer = this.getBinding().getContext().getPropertySet();
            Property property = propertyContainer.getProperty(this.getBinding().getPropertyName());
            property.setValueFromText(this.textComponent.getText());
            this.getBinding().clearProblem();
        }
        catch (BindingException e) {
            this.getBinding().reportProblem(e);
        }
    }

    public InputVerifier createInputVerifier() {
        return new TextVerifier();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.adjustValue();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.getBinding().getProblem() != null) {
            this.textComponent.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
    }

    class TextVerifier
    extends InputVerifier {
        TextVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            return TextComponentAdapter.this.getBinding().getProblem() == null;
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            TextComponentAdapter.this.adjustValue();
            return TextComponentAdapter.this.getBinding().getProblem() == null;
        }
    }
}

