/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure;

import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureChangeEvent;
import com.bc.ceres.swing.figure.FigureChangeListener;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.Handle;
import com.bc.ceres.swing.figure.support.ScaleHandle;
import com.bc.ceres.swing.figure.support.StyleDefaults;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFigure
implements Figure {
    protected static final Figure[] NO_FIGURES = new Figure[0];
    protected static final Handle[] NO_HANDLES = new Handle[0];
    private List<FigureChangeListener> listenerList;
    private static final String OPERATION_NOT_SUPPORTED = "Operation not supported.";
    private boolean selectable;
    private boolean selected;
    private FigureStyle normalStyle;
    private FigureStyle selectedStyle;

    protected AbstractFigure() {
    }

    protected AbstractFigure(FigureStyle normalStyle, FigureStyle selectedStyle) {
        Assert.notNull((Object)normalStyle, (String)"normalStyle");
        Assert.notNull((Object)selectedStyle, (String)"selectedStyle");
        this.normalStyle = normalStyle;
        this.selectedStyle = selectedStyle;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        if (this.selectable != selectable) {
            this.selectable = selectable;
            this.fireFigureChanged();
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            this.selected = selected;
            this.fireFigureChanged();
        }
    }

    @Override
    public FigureStyle getNormalStyle() {
        return this.normalStyle;
    }

    @Override
    public void setNormalStyle(FigureStyle normalStyle) {
        Assert.notNull((Object)normalStyle, (String)"normalStyle");
        if (!normalStyle.equals(this.normalStyle)) {
            this.normalStyle = normalStyle;
            this.fireFigureChanged();
        }
    }

    @Override
    public FigureStyle getSelectedStyle() {
        return this.selectedStyle;
    }

    @Override
    public void setSelectedStyle(FigureStyle selectedStyle) {
        Assert.notNull((Object)selectedStyle, (String)"selectedStyle");
        if (!selectedStyle.equals(this.selectedStyle)) {
            this.selectedStyle = selectedStyle;
            this.fireFigureChanged();
        }
    }

    @Override
    public FigureStyle getEffectiveStyle() {
        return this.isSelected() ? this.getSelectedStyle() : this.getNormalStyle();
    }

    @Override
    public boolean contains(Figure figure) {
        return false;
    }

    @Override
    public int getFigureCount() {
        return 0;
    }

    @Override
    public int getFigureIndex(Figure figure) {
        return 0;
    }

    @Override
    public Figure getFigure(Point2D p, AffineTransform m2v) {
        return null;
    }

    @Override
    public Figure[] getFigures(Shape shape) {
        return NO_FIGURES;
    }

    @Override
    public Figure[] getFigures() {
        return NO_FIGURES;
    }

    @Override
    public synchronized boolean addFigure(Figure figure) {
        return this.addFigure(this.getFigureCount(), figure);
    }

    @Override
    public boolean addFigure(int index, Figure figure) {
        if (!this.contains(figure)) {
            boolean added = this.addFigureImpl(index, figure);
            if (added) {
                this.fireFiguresAdded(figure);
            }
            return added;
        }
        return false;
    }

    @Override
    public synchronized Figure[] addFigures(Figure ... figures) {
        Figure[] added = this.addFiguresImpl(figures);
        if (added.length > 0) {
            this.fireFiguresAdded(added);
        }
        return added;
    }

    @Override
    public synchronized boolean removeFigure(Figure figure) {
        boolean removed = this.removeFigureImpl(figure);
        if (removed) {
            this.fireFiguresRemoved(figure);
        }
        return removed;
    }

    @Override
    public Figure[] removeFigures(Figure ... figures) {
        if (this.getFigureCount() > 0 && figures.length > 0) {
            Figure[] removed = this.removeFiguresImpl(figures);
            this.fireFiguresRemoved(removed);
            return removed;
        }
        return NO_FIGURES;
    }

    @Override
    public Figure[] removeAllFigures() {
        if (this.getFigureCount() > 0) {
            Figure[] figures = this.removeFiguresImpl();
            this.fireFiguresRemoved(figures);
            return figures;
        }
        return NO_FIGURES;
    }

    @Override
    public Figure getFigure(int index) {
        throw new IllegalStateException(OPERATION_NOT_SUPPORTED);
    }

    protected boolean addFigureImpl(int index, Figure figure) {
        throw new IllegalStateException(OPERATION_NOT_SUPPORTED);
    }

    protected boolean addFigureImpl(Figure figure) {
        return this.addFigureImpl(this.getFigureCount(), figure);
    }

    protected Figure[] addFiguresImpl(Figure[] figures) {
        ArrayList<Figure> added = new ArrayList<Figure>(figures.length);
        for (Figure figure : figures) {
            if (!this.addFigureImpl(figure)) continue;
            added.add(figure);
        }
        return added.toArray(new Figure[added.size()]);
    }

    protected boolean removeFigureImpl(Figure figure) {
        throw new IllegalStateException(OPERATION_NOT_SUPPORTED);
    }

    protected Figure[] removeFiguresImpl(Figure[] figures) {
        ArrayList<Figure> removed = new ArrayList<Figure>(figures.length);
        for (Figure figure : figures) {
            if (!this.removeFigureImpl(figure)) continue;
            removed.add(figure);
        }
        return removed.toArray(new Figure[removed.size()]);
    }

    protected Figure[] removeFiguresImpl() {
        return this.removeFiguresImpl(this.getFigures());
    }

    @Override
    public void move(double dx, double dy) {
        throw new IllegalStateException(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void scale(Point2D point, double sx, double sy) {
        throw new IllegalStateException(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void rotate(Point2D point, double theta) {
        throw new IllegalStateException(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public double[] getSegment(int index) {
        throw new IllegalStateException(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setSegment(int index, double[] segment) {
        throw new IllegalStateException(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void addSegment(int index, double[] segment) {
        throw new IllegalStateException(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void removeSegment(int index) {
        throw new IllegalStateException(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public int getMaxSelectionStage() {
        return 0;
    }

    @Override
    public Handle[] createHandles(int selectionStage) {
        return NO_HANDLES;
    }

    @Override
    public Object createMemento() {
        return null;
    }

    @Override
    public void setMemento(Object memento) {
    }

    @Override
    public synchronized void addChangeListener(FigureChangeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<FigureChangeListener>(3);
        }
        this.listenerList.add(listener);
    }

    @Override
    public synchronized void removeChangeListener(FigureChangeListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(listener);
        }
    }

    @Override
    public synchronized FigureChangeListener[] getChangeListeners() {
        if (this.listenerList != null) {
            return this.listenerList.toArray(new FigureChangeListener[this.listenerList.size()]);
        }
        return new FigureChangeListener[0];
    }

    @Override
    public synchronized void dispose() {
        if (this.listenerList != null) {
            this.listenerList.clear();
            this.listenerList = null;
        }
    }

    @Override
    public Object clone() {
        try {
            AbstractFigure figure = (AbstractFigure)super.clone();
            figure.listenerList = null;
            return figure;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void fireFiguresAdded(Figure ... figures) {
        this.fireFigureChanged(new FigureChangeEvent(this, FigureChangeEvent.FIGURES_ADDED, figures));
    }

    protected void fireFiguresRemoved(Figure ... figures) {
        this.fireFigureChanged(new FigureChangeEvent(this, FigureChangeEvent.FIGURES_REMOVED, figures));
    }

    protected void fireFigureChanged() {
        this.fireFigureChanged(new FigureChangeEvent(this, FigureChangeEvent.FIGURE_CHANGED, null));
    }

    protected void fireFigureChanged(FigureChangeEvent event) {
        for (FigureChangeListener listener : this.getChangeListeners()) {
            listener.figureChanged(event);
        }
    }

    protected Handle[] createScaleHandles(double distance) {
        ArrayList<ScaleHandle> handleList = new ArrayList<ScaleHandle>(8);
        FigureStyle handleStyle = this.getHandleStyle();
        handleList.add(new ScaleHandle(this, 3, -distance, -distance, handleStyle));
        handleList.add(new ScaleHandle(this, 1, distance, -distance, handleStyle));
        handleList.add(new ScaleHandle(this, 7, distance, distance, handleStyle));
        handleList.add(new ScaleHandle(this, 5, -distance, distance, handleStyle));
        handleList.add(new ScaleHandle(this, 2, 0.0, -distance, handleStyle));
        handleList.add(new ScaleHandle(this, 0, distance, 0.0, handleStyle));
        handleList.add(new ScaleHandle(this, 6, 0.0, distance, handleStyle));
        handleList.add(new ScaleHandle(this, 4, -distance, 0.0, handleStyle));
        return handleList.toArray(new Handle[handleList.size()]);
    }

    protected FigureStyle getHandleStyle() {
        return StyleDefaults.HANDLE_STYLE;
    }

    protected FigureStyle getSelectedHandleStyle() {
        return StyleDefaults.SELECTED_HANDLE_STYLE;
    }
}

