/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure;

import com.bc.ceres.swing.figure.Interactor;
import com.bc.ceres.swing.figure.InteractorAware;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class InteractionDispatcher
implements MouseListener,
MouseMotionListener,
KeyListener {
    private final InteractorAware interactorAware;
    private final boolean debug = Boolean.getBoolean(InteractionDispatcher.class.getName() + ".debug");

    public InteractionDispatcher(InteractorAware interactorAware) {
        this.interactorAware = interactorAware;
    }

    public void registerListeners(JComponent component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addKeyListener(this);
    }

    public void unregisterListeners(JComponent component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        component.removeKeyListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.debug) {
            System.out.println("InteractionDispatcher.mouseClicked: event = " + event);
        }
        if (this.getInteractor().isActive()) {
            this.getInteractor().mouseClicked(event);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.debug) {
            System.out.println("InteractionDispatcher.mousePressed: event = " + event);
        }
        this.ensureKeyEventsReceived(event);
        if (this.getInteractor().isActive()) {
            this.getInteractor().mousePressed(event);
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.debug) {
            // empty if block
        }
        if (this.getInteractor().isActive()) {
            this.getInteractor().mouseMoved(event);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.debug) {
            // empty if block
        }
        if (this.getInteractor().isActive()) {
            this.getInteractor().mouseDragged(event);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.debug) {
            System.out.println("InteractionDispatcher.mouseReleased: event = " + event);
        }
        if (this.getInteractor().isActive()) {
            this.getInteractor().mouseReleased(event);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (this.debug) {
            System.out.println("InteractionDispatcher.mouseEntered: event = " + event);
        }
        this.ensureKeyEventsReceived(event);
        if (this.getInteractor().isActive()) {
            this.getInteractor().mouseEntered(event);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (this.debug) {
            System.out.println("InteractionDispatcher.mouseExited: event = " + event);
        }
        if (this.getInteractor().isActive()) {
            this.getInteractor().mouseExited(event);
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
        if (this.debug) {
            System.out.println("InteractionDispatcher.keyTyped: event = " + event);
        }
        if (this.getInteractor().isActive()) {
            this.getInteractor().keyTyped(event);
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (this.debug) {
            System.out.println("InteractionDispatcher.keyPressed: event = " + event);
        }
        if (this.getInteractor().isActive()) {
            this.getInteractor().keyPressed(event);
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
        if (this.debug) {
            System.out.println("InteractionDispatcher.keyReleased: event = " + event);
        }
        if (this.getInteractor().isActive()) {
            this.getInteractor().keyReleased(event);
        }
    }

    private Interactor getInteractor() {
        return this.interactorAware.getInteractor();
    }

    private void ensureKeyEventsReceived(MouseEvent e) {
        e.getComponent().requestFocusInWindow();
    }
}

