/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureEditor;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class FigureDeleteEdit
extends AbstractUndoableEdit {
    private FigureEditor figureEditor;
    private Figure[] deletedFigures;
    private int[] deletedPositions;

    public FigureDeleteEdit(FigureEditor figureEditor, boolean performDelete, Figure ... figuresToDelete) {
        Figure[] figures = figureEditor.getFigureCollection().getFigures();
        this.figureEditor = figureEditor;
        this.deletedFigures = performDelete ? figureEditor.getFigureCollection().removeFigures(figuresToDelete) : (Figure[])figuresToDelete.clone();
        this.deletedPositions = new int[this.deletedFigures.length];
        figureEditor.getFigureSelection().removeFigures(this.deletedFigures);
        figureEditor.getFigureSelection().setSelectionStage(0);
        HashSet<Figure> deletedFigureSet = new HashSet<Figure>(Arrays.asList(this.deletedFigures));
        int index = 0;
        for (int i = 0; i < figures.length; ++i) {
            Figure figure = figures[i];
            if (!deletedFigureSet.contains(figure)) continue;
            this.deletedPositions[index++] = i;
        }
        if (index < this.deletedPositions.length) {
            throw new IllegalStateException("i < deletedPositions.length");
        }
    }

    @Override
    public String getPresentationName() {
        return this.deletedFigures.length == 1 ? "Delete Figure" : "Delete Figures";
    }

    @Override
    public void die() {
        super.die();
        Arrays.fill(this.deletedFigures, null);
        this.figureEditor = null;
        this.deletedFigures = null;
        this.deletedPositions = null;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (int i = 0; i < this.deletedFigures.length; ++i) {
            int index = this.deletedPositions[i];
            if (index >= 0 && index < this.figureEditor.getFigureCollection().getFigureCount()) {
                this.figureEditor.getFigureCollection().addFigure(index, this.deletedFigures[i]);
                continue;
            }
            this.figureEditor.getFigureCollection().addFigure(this.deletedFigures[i]);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.figureEditor.getFigureCollection().removeFigures(this.deletedFigures);
        this.figureEditor.getFigureSelection().removeAllFigures();
    }
}

