/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.grender.AdjustableView;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.grender.ViewportListener;
import com.bc.ceres.grender.support.DefaultRendering;
import com.bc.ceres.grender.support.DefaultViewport;
import com.bc.ceres.swing.figure.FigureCollection;
import com.bc.ceres.swing.figure.FigureEditor;
import com.bc.ceres.swing.figure.FigureEditorAware;
import com.bc.ceres.swing.figure.FigureFactory;
import com.bc.ceres.swing.figure.support.DefaultFigureEditor;
import com.bc.ceres.swing.undo.UndoContext;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class FigureEditorPanel
extends JPanel
implements FigureEditorAware,
AdjustableView {
    private DefaultFigureEditor figureEditor;
    private FigureCollection figureCollection;
    private DefaultRendering rendering;
    private Viewport viewport;

    public FigureEditorPanel(UndoContext undoContext, FigureCollection figureCollection, FigureFactory figureFactory) {
        super(null);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setBackground(Color.WHITE);
        this.figureCollection = figureCollection;
        this.viewport = new DefaultViewport(true);
        this.figureEditor = new DefaultFigureEditor(this, this.viewport, undoContext, figureCollection, figureFactory);
        this.rendering = new DefaultRendering(this.viewport);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FigureEditorPanel.this.viewport.setViewBounds(FigureEditorPanel.this.getBounds());
            }
        });
        this.viewport.addListener(new ViewportListener(){

            public void handleViewportChanged(Viewport viewport, boolean orientationChanged) {
                FigureEditorPanel.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.rendering.setGraphics(g2d);
        try {
            this.figureEditor.draw((Rendering)this.rendering);
        }
        finally {
            g2d.dispose();
        }
    }

    @Override
    public FigureEditor getFigureEditor() {
        return this.figureEditor;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public Rectangle2D getMaxVisibleModelBounds() {
        return this.figureCollection.getBounds();
    }

    public double getDefaultZoomFactor() {
        return 1.0;
    }

    public double getMinZoomFactor() {
        return 0.1;
    }

    public double getMaxZoomFactor() {
        return 10.0;
    }
}

