/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.progress;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public abstract class ProgressBarProgressMonitor
implements ProgressMonitor {
    private JProgressBar progressBar;
    private JLabel messageLabel;
    private double currentWork;
    private double totalWork;
    private int totalWorkUI;
    private int currentWorkUI;
    private int lastWorkUI;
    private boolean cancelRequested;

    public ProgressBarProgressMonitor(JProgressBar progressBar, JLabel messageLabel) {
        this.progressBar = progressBar;
        this.messageLabel = messageLabel;
    }

    protected abstract void setDescription(String var1);

    protected abstract void setVisibility(boolean var1);

    protected abstract void setRunning();

    protected abstract void finish();

    public void beginTask(String name, int totalWork) {
        Assert.notNull((Object)name, (String)"name");
        this.currentWork = 0.0;
        this.totalWork = totalWork;
        this.currentWorkUI = 0;
        this.lastWorkUI = 0;
        this.totalWorkUI = totalWork;
        if (this.messageLabel != null) {
            this.messageLabel.setText(name);
        }
        this.cancelRequested = false;
        this.setDescription(name);
        this.setVisibility(true);
        this.progressBar.setMaximum(totalWork);
        this.setRunning();
    }

    public void done() {
        this.runInUI(new Runnable(){

            @Override
            public void run() {
                if (ProgressBarProgressMonitor.this.progressBar != null) {
                    ProgressBarProgressMonitor.this.progressBar.setValue(ProgressBarProgressMonitor.this.progressBar.getMaximum());
                    ProgressBarProgressMonitor.this.setVisibility(false);
                    ProgressBarProgressMonitor.this.finish();
                }
            }
        });
    }

    public void internalWorked(double work) {
        this.currentWork += work;
        this.currentWorkUI = (int)((double)this.totalWorkUI * this.currentWork / this.totalWork);
        if (this.currentWorkUI > this.lastWorkUI) {
            this.runInUI(new Runnable(){

                @Override
                public void run() {
                    if (ProgressBarProgressMonitor.this.progressBar != null) {
                        int progress = ProgressBarProgressMonitor.this.progressBar.getMinimum() + ProgressBarProgressMonitor.this.currentWorkUI;
                        ProgressBarProgressMonitor.this.progressBar.setValue(progress);
                        ProgressBarProgressMonitor.this.setVisibility(true);
                        ProgressBarProgressMonitor.this.setRunning();
                    }
                    ProgressBarProgressMonitor.this.lastWorkUI = ProgressBarProgressMonitor.this.currentWorkUI;
                }
            });
        }
    }

    public boolean isCanceled() {
        return this.cancelRequested;
    }

    public void setCanceled(boolean canceled) {
        this.cancelRequested = canceled;
        if (canceled) {
            this.done();
        }
    }

    public void setTaskName(final String name) {
        this.runInUI(new Runnable(){

            @Override
            public void run() {
                if (ProgressBarProgressMonitor.this.messageLabel != null) {
                    ProgressBarProgressMonitor.this.messageLabel.setText(name);
                }
            }
        });
    }

    public void setSubTaskName(String name) {
        this.setVisibility(true);
        this.messageLabel.setText(name);
        this.setRunning();
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    private void runInUI(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }
}

