/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.selection.support;

import com.bc.ceres.swing.selection.AbstractSelection;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;

public class DefaultSelection<T>
extends AbstractSelection {
    private T[] selectedValues;

    public DefaultSelection(T ... selectedValues) {
        this.selectedValues = selectedValues;
    }

    public T getSelectedValue() {
        return this.selectedValues.length > 0 ? (T)this.selectedValues[0] : null;
    }

    public T[] getSelectedValues() {
        return (Object[])this.selectedValues.clone();
    }

    @Override
    public boolean isEmpty() {
        return this.selectedValues.length == 0;
    }

    @Override
    public String getPresentationName() {
        T value = this.getSelectedValue();
        return value != null ? value.toString() : "";
    }

    @Override
    public Transferable createTransferable(boolean snapshot) {
        T value = this.getSelectedValue();
        return value != null ? new StringSelection(value.toString()) : null;
    }

    @Override
    public DefaultSelection<T> clone() {
        DefaultSelection selection = (DefaultSelection)super.clone();
        selection.selectedValues = (Object[])this.selectedValues.clone();
        return selection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultSelection)) {
            return false;
        }
        DefaultSelection that = (DefaultSelection)o;
        return Arrays.equals(this.selectedValues, that.selectedValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this.selectedValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[selectedValues={");
        for (int i = 0; i < this.selectedValues.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.selectedValues[i]);
        }
        sb.append("}]");
        return sb.toString();
    }
}

