/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.io.IOException;
import org.esa.snap.core.dataio.AbstractProductBuilder;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ProductUtils;

public class ProductFlipper
extends AbstractProductBuilder {
    public static final int FLIP_HORIZONTAL = 1;
    public static final int FLIP_VERTICAL = 2;
    public static final int FLIP_BOTH = 3;
    private int flipType;

    public ProductFlipper(int flipType) {
        this(flipType, false);
    }

    public ProductFlipper(int flipType, boolean sourceProductOwner) {
        super(sourceProductOwner);
        if (flipType != 1 && flipType != 2 && flipType != 3) {
            throw new IllegalArgumentException("invalid flip type");
        }
        this.flipType = flipType;
    }

    public static Product createFlippedProduct(Product sourceProduct, int flipType, String name, String desc) throws IOException {
        return ProductFlipper.createFlippedProduct(sourceProduct, false, flipType, name, desc);
    }

    public static Product createFlippedProduct(Product sourceProduct, boolean sourceProductOwner, int flipType, String name, String desc) throws IOException {
        ProductFlipper productFlipper = new ProductFlipper(flipType, sourceProductOwner);
        return productFlipper.readProductNodes(sourceProduct, null, name, desc);
    }

    public int getFlipType() {
        return this.flipType;
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        if (!(this.getInput() instanceof Product)) {
            throw new IllegalArgumentException("unsupported input source: " + this.getInput());
        }
        this.sourceProduct = (Product)((Object)this.getInput());
        if (this.flipType == 0) {
            throw new IllegalStateException("no flip type set");
        }
        this.sceneRasterWidth = this.sourceProduct.getSceneRasterWidth();
        this.sceneRasterHeight = this.sourceProduct.getSceneRasterHeight();
        return this.createProduct();
    }

    @Override
    public void close() throws IOException {
        this.disposeBandMap();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readBandRasterData(Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        block16: {
            Band sourceBand = (Band)this.bandMap.get(destBand);
            Debug.assertNotNull(sourceBand);
            Guardian.assertNotNull("destBand", destBand);
            Guardian.assertNotNull("destBuffer", destBuffer);
            if (destBuffer.getNumElems() < destWidth * destHeight) {
                throw new IllegalArgumentException("destination buffer too small");
            }
            if (destBuffer.getNumElems() > destWidth * destHeight) {
                throw new IllegalArgumentException("destination buffer too big");
            }
            int sourceW = this.sourceProduct.getSceneRasterWidth();
            int sourceH = this.sourceProduct.getSceneRasterHeight();
            float[] line = new float[sourceW];
            pm.beginTask("Flipping raster data...", destHeight);
            try {
                if (this.flipType == 1) {
                    for (int j = 0; j < destHeight; ++j) {
                        if (pm.isCanceled()) {
                            break block16;
                        }
                        int sourceY = destOffsetY + j;
                        sourceBand.readPixels(0, sourceY, sourceW, 1, line, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                        for (int i = 0; i < destWidth; ++i) {
                            int sourceX = sourceW - (destOffsetX + i + 1);
                            destBuffer.setElemFloatAt(j * destWidth + i, line[sourceX]);
                        }
                    }
                    break block16;
                }
                if (this.flipType == 2) {
                    for (int j = 0; j < destHeight; ++j) {
                        if (pm.isCanceled()) {
                            break block16;
                        }
                        int sourceY = sourceH - (destOffsetY + j + 1);
                        sourceBand.readPixels(0, sourceY, sourceW, 1, line, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                        for (int i = 0; i < destWidth; ++i) {
                            int sourceX = destOffsetX + i;
                            destBuffer.setElemFloatAt(j * destWidth + i, line[sourceX]);
                        }
                    }
                    break block16;
                }
                for (int j = 0; j < destHeight; ++j) {
                    if (pm.isCanceled()) {
                        break;
                    }
                    int sourceY = sourceH - (destOffsetY + j + 1);
                    sourceBand.readPixels(0, sourceY, sourceW, 1, line, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                    for (int i = 0; i < destWidth; ++i) {
                        int sourceX = sourceW - (destOffsetX + i + 1);
                        destBuffer.setElemFloatAt(j * destWidth + i, line[sourceX]);
                    }
                }
            }
            finally {
                pm.done();
            }
        }
    }

    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException("invalid call");
    }

    private Product createProduct() {
        Debug.assertNotNull((Object)this.getSourceProduct());
        Debug.assertTrue(this.getSceneRasterWidth() > 0);
        Debug.assertTrue(this.getSceneRasterHeight() > 0);
        String newProductName = this.newProductName == null || this.newProductName.length() == 0 ? this.getSourceProduct().getName() : this.newProductName;
        Product product = new Product(newProductName, this.getSourceProduct().getProductType(), this.getSceneRasterWidth(), this.getSceneRasterHeight(), this);
        product.setPointingFactory(this.getSourceProduct().getPointingFactory());
        if (this.newProductDesc == null || this.newProductDesc.length() == 0) {
            product.setDescription(this.getSourceProduct().getDescription());
        } else {
            product.setDescription(this.newProductDesc);
        }
        if (!this.isMetadataIgnored()) {
            this.addMetadataToProduct(product);
        }
        this.addTiePointGridsToProduct(product);
        this.addFlagCodingsToProduct(product);
        this.addIndexCodingsToProduct(product);
        this.addBandsToProduct(product);
        this.addGeoCodingToProduct(product);
        ProductUtils.copyMasks(this.getSourceProduct(), product);
        ProductUtils.copyVectorData(this.sourceProduct, product);
        ProductUtils.copyOverlayMasks(this.sourceProduct, product);
        ProductUtils.copyPreferredTileSize(this.sourceProduct, product);
        product.setStartTime(this.sourceProduct.getStartTime());
        product.setEndTime(this.sourceProduct.getEndTime());
        if (this.sourceProduct.getQuicklookBandName() != null && product.getQuicklookBandName() == null && product.containsBand(this.sourceProduct.getQuicklookBandName())) {
            product.setQuicklookBandName(this.sourceProduct.getQuicklookBandName());
        }
        product.setAutoGrouping(this.sourceProduct.getAutoGrouping());
        return product;
    }

    private void addBandsToProduct(Product product) {
        Debug.assertNotNull((Object)this.getSourceProduct());
        Debug.assertNotNull((Object)product);
        for (int i = 0; i < this.getSourceProduct().getNumBands(); ++i) {
            Band sourceBand = this.getSourceProduct().getBandAt(i);
            String bandName = sourceBand.getName();
            if (!this.isNodeAccepted(bandName)) continue;
            Band destBand = sourceBand.isScalingApplied() ? new Band(bandName, 30, this.getSceneRasterWidth(), this.getSceneRasterHeight()) : new Band(bandName, sourceBand.getDataType(), this.getSceneRasterWidth(), this.getSceneRasterHeight());
            if (sourceBand.getUnit() != null) {
                destBand.setUnit(sourceBand.getUnit());
            }
            if (sourceBand.getDescription() != null) {
                destBand.setDescription(sourceBand.getDescription());
            }
            destBand.setSpectralBandIndex(sourceBand.getSpectralBandIndex());
            destBand.setSpectralWavelength(sourceBand.getSpectralWavelength());
            destBand.setSpectralBandwidth(sourceBand.getSpectralBandwidth());
            destBand.setSolarFlux(sourceBand.getSolarFlux());
            FlagCoding sourceFlagCoding = sourceBand.getFlagCoding();
            IndexCoding sourceIndexCoding = sourceBand.getIndexCoding();
            if (sourceFlagCoding != null) {
                String flagCodingName = sourceFlagCoding.getName();
                FlagCoding destFlagCoding = product.getFlagCodingGroup().get(flagCodingName);
                Debug.assertNotNull((Object)destFlagCoding);
                destBand.setSampleCoding(destFlagCoding);
            } else if (sourceIndexCoding != null) {
                String indexCodingName = sourceIndexCoding.getName();
                IndexCoding destIndexCoding = product.getIndexCodingGroup().get(indexCodingName);
                Debug.assertNotNull((Object)destIndexCoding);
                destBand.setSampleCoding(destIndexCoding);
            } else {
                destBand.setSampleCoding(null);
            }
            ImageInfo sourceImageInfo = sourceBand.getImageInfo();
            if (sourceImageInfo != null) {
                destBand.setImageInfo(sourceImageInfo.createDeepCopy());
            }
            product.addBand(destBand);
            this.bandMap.put(destBand, sourceBand);
        }
    }

    private void addTiePointGridsToProduct(Product product) {
        for (int i = 0; i < this.getSourceProduct().getNumTiePointGrids(); ++i) {
            int y;
            TiePointGrid sourceTiePointGrid = this.getSourceProduct().getTiePointGridAt(i);
            if (!this.isNodeAccepted(sourceTiePointGrid.getName())) continue;
            double sourceOffsetX = sourceTiePointGrid.getOffsetX();
            double sourceOffsetY = sourceTiePointGrid.getOffsetY();
            double sourceStepX = sourceTiePointGrid.getSubSamplingX();
            double sourceStepY = sourceTiePointGrid.getSubSamplingY();
            if (this.getSubsetDef() != null) {
                sourceStepX /= (double)this.getSubsetDef().getSubSamplingX();
                sourceStepY /= (double)this.getSubsetDef().getSubSamplingY();
                if (this.getSubsetDef().getRegion() != null) {
                    sourceOffsetX -= (double)this.getSubsetDef().getRegion().x;
                    sourceOffsetY -= (double)this.getSubsetDef().getRegion().y;
                }
            }
            float[] sourcePoints = sourceTiePointGrid.getTiePoints();
            float[] targetPoints = new float[sourcePoints.length];
            int width = sourceTiePointGrid.getGridWidth();
            int height = sourceTiePointGrid.getGridHeight();
            if (this.flipType == 1) {
                sourceOffsetX = (double)sourceTiePointGrid.getRasterWidth() - (double)(width - 1) * sourceStepX - sourceOffsetX;
                for (y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        targetPoints[x + y * width] = sourcePoints[width - x - 1 + y * width];
                    }
                }
            } else if (this.flipType == 2) {
                sourceOffsetY = (double)sourceTiePointGrid.getRasterHeight() - (double)(height - 1) * sourceStepY - sourceOffsetY;
                for (y = 0; y < height; ++y) {
                    System.arraycopy(sourcePoints, (height - y - 1) * width, targetPoints, y * width, width);
                }
            } else {
                sourceOffsetX = (double)sourceTiePointGrid.getRasterWidth() - (double)(width - 1) * sourceStepX - sourceOffsetX;
                sourceOffsetY = (double)sourceTiePointGrid.getRasterHeight() - (double)(height - 1) * sourceStepY - sourceOffsetY;
                for (y = 0; y < height; ++y) {
                    int lineIndex = height - y - 1;
                    for (int x = 0; x < width; ++x) {
                        targetPoints[x + y * width] = sourcePoints[width - x - 1 + lineIndex * width];
                    }
                }
            }
            TiePointGrid tiePointGrid = new TiePointGrid(sourceTiePointGrid.getName(), sourceTiePointGrid.getGridWidth(), sourceTiePointGrid.getGridHeight(), sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, targetPoints, sourceTiePointGrid.getDiscontinuity());
            tiePointGrid.setUnit(sourceTiePointGrid.getUnit());
            tiePointGrid.setDescription(sourceTiePointGrid.getDescription());
            product.addTiePointGrid(tiePointGrid);
        }
    }

    private void addGeoCodingToProduct(Product product) {
        this.getSourceProduct().transferGeoCodingTo(product, null);
    }
}

