/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.esa.snap.core.subset.AbstractSubsetRegion;
import org.esa.snap.core.subset.PixelSubsetRegion;
import org.esa.snap.core.util.Guardian;

public class ProductSubsetDef {
    private AbstractSubsetRegion subsetRegion;
    private String subsetName = null;
    private HashMap<String, Rectangle> regionMap = null;
    private int subSamplingX = 1;
    private int subSamplingY = 1;
    private List nodeNameList = null;
    private boolean ignoreMetadata = false;
    private boolean treatVirtualBandsAsRealBands = false;

    public ProductSubsetDef() {
        this(null);
    }

    public ProductSubsetDef(String subsetName) {
        this.subsetName = subsetName;
    }

    public String getSubsetName() {
        return this.subsetName;
    }

    public void setSubsetName(String subsetName) {
        this.subsetName = subsetName;
    }

    public void setTreatVirtualBandsAsRealBands(boolean flag) {
        this.treatVirtualBandsAsRealBands = flag;
    }

    public boolean getTreatVirtualBandsAsRealBands() {
        return this.treatVirtualBandsAsRealBands;
    }

    public String[] getNodeNames() {
        if (this.nodeNameList == null) {
            return null;
        }
        String[] result = new String[this.nodeNameList.size()];
        for (int i = 0; i < this.nodeNameList.size(); ++i) {
            result[i] = (String)this.nodeNameList.get(i);
        }
        return result;
    }

    public void setNodeNames(String[] names) {
        if (names != null) {
            if (this.nodeNameList != null) {
                this.nodeNameList.clear();
            }
            this.addNodeNames(names);
        } else {
            this.nodeNameList = null;
        }
    }

    public void addNodeName(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        if (this.containsNodeName(name)) {
            return;
        }
        if (this.nodeNameList == null) {
            this.nodeNameList = new ArrayList();
        }
        this.nodeNameList.add(name);
    }

    public void addNodeNames(String[] names) {
        if (names == null) {
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            this.addNodeName(names[i]);
        }
    }

    public void addNodeNames(Set<String> names) {
        if (names == null) {
            return;
        }
        for (String name : names) {
            this.addNodeName(name);
        }
    }

    public boolean removeNodeName(String name) {
        int index = this.getNodeNameIndex(name);
        if (index < 0) {
            return false;
        }
        this.nodeNameList.remove(index);
        if (this.nodeNameList.size() == 0) {
            this.nodeNameList = null;
        }
        return true;
    }

    public boolean containsNodeName(String name) {
        return this.getNodeNameIndex(name) >= 0;
    }

    public boolean isNodeAccepted(String name) {
        return this.nodeNameList == null || this.containsNodeName(name);
    }

    @Deprecated
    public Rectangle getRegion() {
        if (this.subsetRegion != null && this.subsetRegion instanceof PixelSubsetRegion) {
            PixelSubsetRegion pixelSubsetRegion = (PixelSubsetRegion)this.subsetRegion;
            return new Rectangle(pixelSubsetRegion.getPixelRegion());
        }
        return null;
    }

    public HashMap<String, Rectangle> getRegionMap() {
        return this.regionMap;
    }

    @Deprecated
    public void setRegion(Rectangle region) {
        if (region == null) {
            this.subsetRegion = null;
        } else {
            this.setRegion(region.x, region.y, region.width, region.height);
        }
    }

    public void setRegionMap(HashMap<String, Rectangle> regionMap) {
        this.regionMap = regionMap;
    }

    @Deprecated
    public void setRegion(int x, int y, int w, int h) {
        this.subsetRegion = new PixelSubsetRegion(x, y, w, h, 0);
    }

    public void setSubSampling(int subSamplingX, int subSamplingY) {
        if (subSamplingX < 1 || subSamplingY < 1) {
            throw new IllegalArgumentException("invalid sub-sampling");
        }
        this.subSamplingX = subSamplingX;
        this.subSamplingY = subSamplingY;
    }

    public int getSubSamplingX() {
        return this.subSamplingX;
    }

    public int getSubSamplingY() {
        return this.subSamplingY;
    }

    public Dimension getSceneRasterSize(int maxWidth, int maxHeight) {
        return this.getSceneRasterSize(maxWidth, maxHeight, null);
    }

    public Dimension getSceneRasterSize(int maxWidth, int maxHeight, String bandName) {
        int width = maxWidth;
        int height = maxHeight;
        if (this.subsetRegion != null && this.subsetRegion instanceof PixelSubsetRegion) {
            PixelSubsetRegion pixelSubsetRegion = (PixelSubsetRegion)this.subsetRegion;
            width = pixelSubsetRegion.getPixelRegion().width;
            height = pixelSubsetRegion.getPixelRegion().height;
        }
        if (bandName != null && this.regionMap != null && this.regionMap.containsKey(bandName)) {
            width = this.regionMap.get((Object)bandName).width;
            height = this.regionMap.get((Object)bandName).height;
        } else if (this.regionMap != null) {
            int auxWidth = -1;
            int auxHeight = -1;
            for (Object nodeName : this.nodeNameList) {
                String nodeNameString = nodeName.toString();
                Rectangle rec = this.regionMap.get(nodeNameString);
                if (rec == null || auxHeight >= rec.height) continue;
                auxHeight = rec.height;
                auxWidth = rec.width;
            }
            if (auxHeight != -1 && auxWidth != -1) {
                width = auxWidth;
                height = auxHeight;
            }
        }
        return new Dimension((width - 1) / this.subSamplingX + 1, (height - 1) / this.subSamplingY + 1);
    }

    public void setIgnoreMetadata(boolean ignoreMetadata) {
        this.ignoreMetadata = ignoreMetadata;
    }

    public boolean isIgnoreMetadata() {
        return this.ignoreMetadata;
    }

    public boolean isEntireProductSelected() {
        return this.subsetRegion == null && this.subSamplingX == 1 && this.subSamplingY == 1 && this.nodeNameList == null && !this.ignoreMetadata;
    }

    private int getNodeNameIndex(String name) {
        if (this.nodeNameList != null) {
            for (int i = 0; i < this.nodeNameList.size(); ++i) {
                String nodeName = (String)this.nodeNameList.get(i);
                if (!nodeName.equalsIgnoreCase(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public AbstractSubsetRegion getSubsetRegion() {
        return this.subsetRegion;
    }

    public void setSubsetRegion(AbstractSubsetRegion subsetRegion) {
        this.subsetRegion = subsetRegion;
    }
}

