/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.cache;

import java.awt.Rectangle;
import java.awt.geom.Area;
import org.esa.snap.core.datamodel.ProductData;

class CacheBlock {
    private final int yStart;
    private final int width;
    private final int height;
    private final Area unwrittenSpace;
    private ProductData bufferData;

    CacheBlock(int yStart, int width, int height, int dataType, double noDataValue) {
        this.yStart = yStart;
        this.width = width;
        this.height = height;
        this.bufferData = ProductData.createInstance(dataType, width * height);
        for (int i = 0; i < this.bufferData.getNumElems(); ++i) {
            this.bufferData.setElemDoubleAt(i, noDataValue);
        }
        this.unwrittenSpace = new Area(this.getRegion());
    }

    int getYOffset() {
        return this.yStart;
    }

    Rectangle getRegion() {
        return new Rectangle(0, this.yStart, this.width, this.height);
    }

    ProductData getBufferData() {
        return this.bufferData;
    }

    public void dispose() {
        this.bufferData = null;
    }

    public boolean isComplete() {
        return this.unwrittenSpace.isEmpty();
    }

    public void update(int xOffset, int yReadOff, int yWriteOff, int width, int height, ProductData data) {
        Object srcData = data.getElems();
        Object destData = this.bufferData.getElems();
        int writeLineOffset = yWriteOff - this.yStart;
        for (int line = 0; line < height; ++line) {
            int srcPos = (yReadOff + line) * width;
            int destPos = xOffset + (writeLineOffset + line) * this.width;
            System.arraycopy(srcData, srcPos, destData, destPos, width);
        }
        this.unwrittenSpace.subtract(new Area(new Rectangle(xOffset, yWriteOff, width, height)));
    }
}

