/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.cache;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.ImageOutputStream;
import org.esa.snap.core.dataio.cache.CacheBlock;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;

public class VariableCache {
    private static final int LINES_PER_BUFFER = 128;
    final CacheBlock[] cacheBlocks;
    private final List<Integer> completedIndices;
    private final int width;
    private final int rasterHeight;
    private final int dataType;
    private final double noDataValue;

    VariableCache(Band variable) {
        Dimension rasterSize = variable.getRasterSize();
        this.width = rasterSize.width;
        this.rasterHeight = rasterSize.height;
        this.dataType = variable.getDataType();
        this.noDataValue = variable.getNoDataValue();
        int numCacheBlocks = (rasterSize.height - 1) / 128 + 1;
        this.cacheBlocks = new CacheBlock[numCacheBlocks];
        this.completedIndices = new ArrayList<Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean update(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer) {
        int firstIdx = sourceOffsetY / 128;
        int lastIdx = (sourceOffsetY + sourceHeight - 1) / 128;
        boolean canWrite = false;
        int yReadOff = 0;
        int cacheBlockIndex = firstIdx;
        while (cacheBlockIndex <= lastIdx) {
            int cacheBufferStartY = cacheBlockIndex * 128;
            int writeOffset = Math.max(0, sourceOffsetY - cacheBufferStartY);
            int remainingHeight = sourceHeight - yReadOff;
            int heightToNextCacheBlock = 128 - writeOffset;
            int blockHeight = Math.min(remainingHeight, heightToNextCacheBlock);
            CacheBlock[] cacheBlockArray = this.cacheBlocks;
            // MONITORENTER : this.cacheBlocks
            if (this.cacheBlocks[cacheBlockIndex] == null) {
                int cacheBufferHeight = (cacheBlockIndex + 1) * 128 < this.rasterHeight ? 128 : this.rasterHeight - cacheBufferStartY;
                this.cacheBlocks[cacheBlockIndex] = new CacheBlock(cacheBufferStartY, this.width, cacheBufferHeight, this.dataType, this.noDataValue);
            }
            this.cacheBlocks[cacheBlockIndex].update(sourceOffsetX, yReadOff, cacheBufferStartY + writeOffset, sourceWidth, blockHeight, sourceBuffer);
            boolean complete = this.cacheBlocks[cacheBlockIndex].isComplete();
            if (complete) {
                this.completedIndices.add(cacheBlockIndex);
            }
            canWrite |= complete;
            yReadOff += blockHeight;
            // MONITOREXIT : cacheBlockArray
            ++cacheBlockIndex;
        }
        return canWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCompletedBlocks(ImageOutputStream outputStream) throws IOException {
        CacheBlock[] cacheBlockArray = this.cacheBlocks;
        synchronized (this.cacheBlocks) {
            for (int index : this.completedIndices) {
                this.writeCacheBlock(outputStream, index);
            }
            this.completedIndices.clear();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(ImageOutputStream outputStream) throws IOException {
        CacheBlock[] cacheBlockArray = this.cacheBlocks;
        synchronized (this.cacheBlocks) {
            for (int i = 0; i < this.cacheBlocks.length; ++i) {
                this.writeCacheBlock(outputStream, i);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void writeCacheBlock(ImageOutputStream outputStream, int index) throws IOException {
        CacheBlock cacheBlock = this.cacheBlocks[index];
        if (cacheBlock != null) {
            ProductData bufferData = cacheBlock.getBufferData();
            long outputPos = VariableCache.getStreamOutputPos(cacheBlock);
            bufferData.writeTo(0, bufferData.getNumElems(), outputStream, outputPos);
            cacheBlock.dispose();
            this.cacheBlocks[index] = null;
        }
    }

    static long getStreamOutputPos(CacheBlock cacheBlock) {
        return (long)cacheBlock.getYOffset() * (long)cacheBlock.getRegion().width;
    }
}

