/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.cache;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.imageio.stream.ImageOutputStream;
import org.esa.snap.core.dataio.cache.VariableCache;
import org.esa.snap.core.datamodel.Band;

public class WriteCache {
    private final HashMap<String, VariableCache> variableMap = new HashMap();

    public synchronized VariableCache get(Band band) {
        VariableCache variableCache = this.variableMap.get(band.getName());
        if (variableCache == null) {
            variableCache = new VariableCache(band);
            this.variableMap.put(band.getName(), variableCache);
        }
        return variableCache;
    }

    public void flush(Map<Band, ImageOutputStream> bandOutputStreams) throws IOException {
        Set<Map.Entry<Band, ImageOutputStream>> entries = bandOutputStreams.entrySet();
        for (Map.Entry<Band, ImageOutputStream> next : entries) {
            String bandName = next.getKey().getName();
            VariableCache variableCache = this.variableMap.get(bandName);
            if (variableCache == null) continue;
            variableCache.flush(next.getValue());
        }
    }
}

