/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.dimap;

import java.io.File;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;

public class DimapFileFilter
extends SnapFileFilter {
    public DimapFileFilter() {
        super("BEAM-DIMAP", ".dim", "BEAM-DIMAP product files");
    }

    @Override
    public boolean accept(File file) {
        if (file.isFile() && this.hasHeaderExt(file)) {
            return FileUtils.exchangeExtension(file, ".data").isDirectory();
        }
        return file.isDirectory() && !this.isDataDir(file);
    }

    @Override
    public boolean isCompoundDocument(File dir) {
        return this.isDataDir(dir);
    }

    private boolean isDataDir(File dir) {
        return this.hasDataExt(dir) && FileUtils.exchangeExtension(dir, ".dim").isFile();
    }

    private boolean hasHeaderExt(File file) {
        return file.getName().endsWith(".dim");
    }

    private boolean hasDataExt(File file) {
        return file.getName().endsWith(".data");
    }
}

