/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.dimap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.esa.snap.core.dataio.dimap.DimapFileFilter;
import org.esa.snap.core.dataio.dimap.spi.DimapPersistable;
import org.esa.snap.core.dataio.dimap.spi.DimapPersistence;
import org.esa.snap.core.dataio.placemark.PlacemarkIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.FXYGeoCoding;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GcpDescriptor;
import org.esa.snap.core.datamodel.GcpGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PinDescriptor;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.PointingFactory;
import org.esa.snap.core.datamodel.PointingFactoryRegistry;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.StxFactory;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.dataop.maptransf.Ellipsoid;
import org.esa.snap.core.dataop.maptransf.MapInfo;
import org.esa.snap.core.dataop.maptransf.MapProjection;
import org.esa.snap.core.dataop.maptransf.MapProjectionRegistry;
import org.esa.snap.core.dataop.maptransf.MapTransform;
import org.esa.snap.core.dataop.maptransf.MapTransformDescriptor;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ImageUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.XmlWriter;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.math.FXYSum;
import org.geotools.referencing.CRS;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.xml.sax.SAXException;

public class DimapProductHelpers {
    public static Product createProduct(Document dom, String defaultProductType, Dimension regionRasterSize) {
        return new ProductBuilder(dom).createProduct(defaultProductType, regionRasterSize);
    }

    public static Map<Band, File> getBandDataFiles(Document dom, Product product, File inputDir) throws IllegalArgumentException {
        Guardian.assertNotNull("dom", dom);
        Guardian.assertNotNull("product", (Object)product);
        Guardian.assertNotNull("inputDir", inputDir);
        HashMap<Band, File> dataFilesMap = new HashMap<Band, File>();
        if (!dom.hasRootElement()) {
            return dataFilesMap;
        }
        Element rootElement = dom.getRootElement();
        if (rootElement == null) {
            return dataFilesMap;
        }
        Element dataAccess = rootElement.getChild("Data_Access");
        if (dataAccess == null) {
            return dataFilesMap;
        }
        List bandDataFiles = dataAccess.getChildren("Data_File");
        for (Object bandDataFile1 : bandDataFiles) {
            Element filePathElement;
            String bandHeaderFilePath;
            String bandName;
            Band band;
            Element bandDataFile = (Element)bandDataFile1;
            String actualIndex = bandDataFile.getChildTextTrim("BAND_INDEX");
            if (actualIndex == null || (band = product.getBand(bandName = DimapProductHelpers.getBandName(rootElement, actualIndex))) == null || (bandHeaderFilePath = (filePathElement = bandDataFile.getChild("DATA_FILE_PATH")).getAttributeValue("href")) == null || bandHeaderFilePath.length() <= 0) continue;
            String localHeaderFilePath = SystemUtils.convertToLocalPath(bandHeaderFilePath);
            String bandDataFilePath = FileUtils.exchangeExtension(localHeaderFilePath, ".img");
            dataFilesMap.put(band, new File(inputDir, bandDataFilePath));
        }
        return dataFilesMap;
    }

    public static String getTiePointDataFile(Document dom, String tiePointGridName) throws IllegalArgumentException {
        Guardian.assertNotNull("dom", dom);
        Guardian.assertNotNullOrEmpty("tiePointGridName", tiePointGridName);
        Element rootElement = dom.getRootElement();
        Element dataAccess = rootElement.getChild("Data_Access");
        if (dataAccess == null) {
            return null;
        }
        String index = DimapProductHelpers.getTiePointGridIndex(rootElement, tiePointGridName);
        if (index == null) {
            return null;
        }
        List tiePointGridFiles = dataAccess.getChildren("Tie_Point_Grid_File");
        for (Object child : tiePointGridFiles) {
            Element filePathElement;
            String tiePointGridFilePath;
            Element tiePointGridFile = (Element)child;
            String actualIndex = tiePointGridFile.getChildTextTrim("TIE_POINT_GRID_INDEX");
            if (!index.equals(actualIndex) || (tiePointGridFilePath = (filePathElement = tiePointGridFile.getChild("TIE_POINT_GRID_FILE_PATH")).getAttributeValue("href")) == null || tiePointGridFilePath.length() <= 0) continue;
            return SystemUtils.convertToLocalPath(tiePointGridFilePath);
        }
        return null;
    }

    public static void printColorTag(int indent, Color color, XmlWriter pw) {
        DimapProductHelpers.printColorTag(indent, "COLOR", color, pw);
    }

    public static void printColorTag(int indent, String tag, Color color, XmlWriter pw) {
        if (color == null) {
            return;
        }
        if (pw == null) {
            return;
        }
        String[][] attributes = new String[][]{{"red", String.valueOf(color.getRed())}, {"green", String.valueOf(color.getGreen())}, {"blue", String.valueOf(color.getBlue())}, {"alpha", String.valueOf(color.getAlpha())}};
        pw.printLine(indent, tag, attributes, null);
    }

    public static Color createColor(Element colorElem) {
        int red = Integer.parseInt(colorElem.getAttributeValue("red"));
        int green = Integer.parseInt(colorElem.getAttributeValue("green"));
        int blue = Integer.parseInt(colorElem.getAttributeValue("blue"));
        String alphaStr = colorElem.getAttributeValue("alpha");
        int alpha = alphaStr != null ? Integer.parseInt(alphaStr) : 255;
        return new Color(red, green, blue, alpha);
    }

    public static GeoCoding[] createGeoCoding(Document dom, Product product) {
        Debug.assertNotNull(dom);
        Debug.assertNotNull((Object)product);
        Element rootElem = dom.getRootElement();
        List geoPosElems = rootElem.getChildren("Geoposition");
        List crsElems = rootElem.getChildren("Coordinate_Reference_System");
        Element imageInterpretationElement = rootElem.getChild("Image_Interpretation");
        List bandInfoElems = null;
        if (imageInterpretationElement != null) {
            bandInfoElems = imageInterpretationElement.getChildren("Spectral_Band_Info");
        }
        Datum datum = DimapProductHelpers.createDatum(dom);
        if (geoPosElems.size() > 0) {
            HashMap<String, GeoCoding> wktToCrsGeocodingMap = new HashMap<String, GeoCoding>();
            GeoCoding[] geoCodings = new GeoCoding[geoPosElems.size()];
            for (int i = 0; i < geoPosElems.size(); ++i) {
                Element geoPosElem = (Element)geoPosElems.get(i);
                int bandIndex = geoPosElems.size() > 1 ? Integer.parseInt(geoPosElem.getChildText("BAND_INDEX")) : 0;
                Element bandInfoElem = null;
                if (bandInfoElems != null) {
                    for (Object object : bandInfoElems) {
                        Element element = (Element)object;
                        try {
                            int index = Integer.parseInt(element.getChildText("BAND_INDEX"));
                            if (index != bandIndex) continue;
                            bandInfoElem = element;
                            break;
                        }
                        catch (Exception index) {
                        }
                    }
                }
                if (i < crsElems.size() && crsElems.get(i) != null && ((Element)crsElems.get(i)).getChild("WKT") != null) {
                    GeoCoding crsGeoCoding;
                    Element wktElement = ((Element)crsElems.get(i)).getChild("WKT");
                    String key = wktElement.getTextTrim() + " " + geoPosElem.getChild("IMAGE_TO_MODEL_TRANSFORM").getTextTrim();
                    if (wktToCrsGeocodingMap.containsKey(key)) {
                        geoCodings[bandIndex] = (GeoCoding)wktToCrsGeocodingMap.get(key);
                        continue;
                    }
                    geoCodings[bandIndex] = crsGeoCoding = DimapProductHelpers.createCrsGeoCoding(product, geoPosElem, wktElement, bandInfoElem);
                    wktToCrsGeocodingMap.put(key, crsGeoCoding);
                    continue;
                }
                if (geoPosElem.getChild("Simplified_Location_Model") != null && geoPosElem.getChild("Geoposition_Insert") != null) {
                    geoCodings[bandIndex] = DimapProductHelpers.createFXYGeoCoding(datum, geoPosElem);
                    continue;
                }
                if (geoPosElem.getChild("SEARCH_RADIUS") != null && geoPosElem.getChild("LATITUDE_BAND") != null) {
                    geoCodings[bandIndex] = DimapProductHelpers.createPixelGeoCoding(product, datum, geoPosElem);
                    continue;
                }
                Element geopositionPointsElement = geoPosElem.getChild("Geoposition_Points");
                if (geopositionPointsElement != null) {
                    geoCodings[bandIndex] = DimapProductHelpers.createGeoCodingFromGeoPositionPointsElement(product, datum, geopositionPointsElement);
                    continue;
                }
                DimapPersistable persistable = DimapPersistence.getPersistable(geoPosElem);
                if (persistable == null) continue;
                geoCodings[bandIndex] = (GeoCoding)persistable.createObjectFromXml(geoPosElem, product, null);
            }
            return geoCodings;
        }
        String tagCoordRefSys = "Coordinate_Reference_System";
        if (crsElems.size() == 1) {
            Element coordRefSysElem = (Element)crsElems.get(0);
            String tagHorizontalCs = "Horizontal_CS";
            Element hCsElem = coordRefSysElem.getChild("Horizontal_CS");
            if (hCsElem != null) {
                MapInfo mapInfo = DimapProductHelpers.createMapInfoSinceDimap1_4_0(hCsElem);
                if (mapInfo != null) {
                    mapInfo.setSceneWidth(product.getSceneRasterWidth());
                    mapInfo.setSceneHeight(product.getSceneRasterHeight());
                    return new GeoCoding[]{new MapGeoCoding(mapInfo)};
                }
                return null;
            }
            Debug.trace("DimapProductHelpers.ProductBuilder.createGeoCoding(): the tag <Coordinate_Reference_System> contains no tag <Horizontal_CS>");
            Element tpgElem = coordRefSysElem.getChild("Geocoding_Tie_Point_Grids");
            if (tpgElem != null) {
                String tpgNameLat = tpgElem.getChildTextTrim("TIE_POINT_GRID_NAME_LAT");
                String tpgNameLon = tpgElem.getChildTextTrim("TIE_POINT_GRID_NAME_LON");
                if (tpgNameLat != null && tpgNameLon != null) {
                    TiePointGrid tiePointGridLat = product.getTiePointGrid(tpgNameLat);
                    TiePointGrid tiePointGridLon = product.getTiePointGrid(tpgNameLon);
                    if (tiePointGridLat != null && tiePointGridLon != null) {
                        if (tiePointGridLat.hasRasterData() && tiePointGridLon.hasRasterData()) {
                            return new GeoCoding[]{new TiePointGeoCoding(tiePointGridLat, tiePointGridLon, datum)};
                        }
                        Debug.trace("DimapProductHelpers.ProductBuilder.createGeoCoding(): Tie-point grids have no raster data loaded");
                    } else {
                        Debug.trace("DimapProductHelpers.ProductBuilder.createGeoCoding(): can't find '" + tpgNameLat + "' or '" + tpgNameLon + "'");
                    }
                } else {
                    Debug.trace("DimapProductHelpers.ProductBuilder.createGeoCoding(): missing value for 'TIE_POINT_GRID_NAME_LAT' or 'TIE_POINT_GRID_NAME_LON'");
                }
            } else {
                Debug.trace("DimapProductHelpers.ProductBuilder.createGeoCoding(): the coordinate reference system tag contains no horizontal coordinat system tag");
            }
            Element mapElem = coordRefSysElem.getChild("Geocoding_Map");
            if (mapElem != null) {
                String mapInfoText = mapElem.getChildTextTrim("MAP_INFO");
                if (mapInfoText != null) {
                    String[] strings = org.esa.snap.core.util.StringUtils.toStringArray(mapInfoText, null);
                    if (strings.length >= 9) {
                        String projectionName = strings[0];
                        String datumName = strings[7];
                        MapProjection projection = MapProjectionRegistry.getProjection(projectionName);
                        if (projection != null) {
                            if (Datum.WGS_84.getName().equalsIgnoreCase(datumName)) {
                                float refPixelX = Float.parseFloat(strings[1]);
                                float refPixelY = Float.parseFloat(strings[2]);
                                float refPixelEasting = Float.parseFloat(strings[3]);
                                float refPixelNorthing = Float.parseFloat(strings[4]);
                                float refPixelWidth = Float.parseFloat(strings[5]);
                                float refPixelHeight = Float.parseFloat(strings[6]);
                                MapInfo mapInfo = new MapInfo(projection, refPixelX, refPixelY, refPixelEasting, refPixelNorthing, refPixelWidth, refPixelHeight, Datum.WGS_84);
                                if (strings.length == 9) {
                                    mapInfo.setSceneWidth(product.getSceneRasterWidth());
                                    mapInfo.setSceneHeight(product.getSceneRasterHeight());
                                } else if (strings.length == 11) {
                                    mapInfo.setSceneWidth(Integer.parseInt(strings[9]));
                                    mapInfo.setSceneHeight(Integer.parseInt(strings[10]));
                                }
                                return new GeoCoding[]{new MapGeoCoding(mapInfo)};
                            }
                            Debug.trace("DimapProductHelpers.ProductBuilder.createGeoCoding(): unknown datum '" + datumName + "'");
                        } else {
                            Debug.trace("DimapProductHelpers.ProductBuilder.createGeoCoding(): unknown projection '" + projectionName + "'");
                        }
                    } else {
                        Debug.trace("DimapProductHelpers.ProductBuilder.createGeoCoding(): missing map-info parameters");
                    }
                } else {
                    Debug.trace("DimapProductHelpers.ProductBuilder.createGeoCoding(): map-info text is empty");
                }
            } else {
                Debug.trace("DimapProductHelpers.ProductBuilder.createGeoCoding(): neither 'Geocoding_Tie_Point_Grids' nor 'Geocoding_Map' found in 'Coordinate_Reference_System' element");
            }
        } else {
            Debug.trace("DimapProductHelpers.ProductBuilder.createGeoCoding(): missing 'Coordinate_Reference_System' element");
        }
        TiePointGrid tiePointGridLat = product.getTiePointGrid("latitude");
        TiePointGrid tiePointGridLon = product.getTiePointGrid("longitude");
        if (tiePointGridLat != null && tiePointGridLon != null) {
            return new GeoCoding[]{new TiePointGeoCoding(tiePointGridLat, tiePointGridLon, datum)};
        }
        Debug.trace("DimapProductHelpers.ProductBuilder.createGeoCoding(): can't find 'latitude' or 'longitude'");
        return null;
    }

    private static GeoCoding createGeoCodingFromGeoPositionPointsElement(Product product, Datum datum, Element geoPositionPointsElement) {
        Element originalGeoCodingElement;
        GcpGeoCoding gcpGeoCoding = null;
        GeoCoding originalGeoCoding = null;
        TiePointGeoCoding tiePointGeoCoding = null;
        Element latElement = geoPositionPointsElement.getChild("TIE_POINT_GRID_NAME_LAT");
        Element lonElement = geoPositionPointsElement.getChild("TIE_POINT_GRID_NAME_LON");
        if (latElement != null && lonElement != null) {
            String latName = latElement.getText();
            String lonName = lonElement.getText();
            TiePointGrid latGrid = product.getTiePointGrid(latName);
            TiePointGrid lonGrid = product.getTiePointGrid(lonName);
            try {
                if (latGrid != null && lonGrid != null) {
                    tiePointGeoCoding = new TiePointGeoCoding(latGrid, lonGrid, datum);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tiePointGeoCoding != null) {
            return tiePointGeoCoding;
        }
        Element methodElement = geoPositionPointsElement.getChild("INTERPOLATION_METHOD");
        if (methodElement != null) {
            String methodName = methodElement.getText();
            GcpGeoCoding.Method method = GcpGeoCoding.Method.valueOf(GcpGeoCoding.Method.class, methodName);
            PlacemarkGroup gcpGroup = product.getGcpGroup();
            Placemark[] placemarks = (Placemark[])gcpGroup.toArray(new Placemark[gcpGroup.getNodeCount()]);
            try {
                gcpGeoCoding = new GcpGeoCoding(method, placemarks, product.getSceneRasterWidth(), product.getSceneRasterHeight(), datum);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((originalGeoCodingElement = geoPositionPointsElement.getChild("Original_Geocoding")) != null) {
            try {
                originalGeoCoding = DimapProductHelpers.createGeoCodingFromElement(product, originalGeoCodingElement);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (gcpGeoCoding != null) {
            gcpGeoCoding.setOriginalGeoCoding(originalGeoCoding);
            return gcpGeoCoding;
        }
        return originalGeoCoding;
    }

    private static GeoCoding createGeoCodingFromElement(Product product, Element element) {
        Content content = element.detach();
        GeoCoding[] geoCodings = DimapProductHelpers.createGeoCoding(new Document().addContent(content), product);
        if (geoCodings == null) {
            return null;
        }
        return geoCodings[0];
    }

    private static GeoCoding createCrsGeoCoding(Product product, Element geoPositionElem, Element wktElem) {
        try {
            CoordinateReferenceSystem crs = CRS.parseWKT((String)wktElem.getTextTrim());
            Element i2mElem = geoPositionElem.getChild("IMAGE_TO_MODEL_TRANSFORM");
            if (i2mElem != null) {
                String[] parameters = org.esa.snap.core.util.StringUtils.csvToArray(i2mElem.getTextTrim());
                double[] matrix = new double[parameters.length];
                for (int i = 0; i < matrix.length; ++i) {
                    matrix[i] = Double.valueOf(parameters[i]);
                }
                AffineTransform i2m = new AffineTransform(matrix);
                Rectangle imageBounds = new Rectangle(product.getSceneRasterWidth(), product.getSceneRasterHeight());
                try {
                    return new CrsGeoCoding(crs, imageBounds, i2m);
                }
                catch (TransformException e) {
                    Debug.trace(e);
                }
            }
        }
        catch (FactoryException e) {
            Debug.trace(e);
        }
        return null;
    }

    private static GeoCoding createCrsGeoCoding(Product product, Element geoPositionElem, Element wktElem, Element bandInfoElem) {
        if (bandInfoElem == null) {
            return DimapProductHelpers.createCrsGeoCoding(product, geoPositionElem, wktElem);
        }
        try {
            CoordinateReferenceSystem crs = CRS.parseWKT((String)wktElem.getTextTrim());
            Element i2mElem = geoPositionElem.getChild("IMAGE_TO_MODEL_TRANSFORM");
            Element widthElem = bandInfoElem.getChild("BAND_RASTER_WIDTH");
            Element heightElem = bandInfoElem.getChild("BAND_RASTER_HEIGHT");
            int height = product.getSceneRasterHeight();
            int width = product.getSceneRasterWidth();
            if (heightElem != null) {
                try {
                    height = Integer.valueOf(heightElem.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (widthElem != null) {
                try {
                    width = Integer.valueOf(widthElem.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (i2mElem != null) {
                String[] parameters = org.esa.snap.core.util.StringUtils.csvToArray(i2mElem.getTextTrim());
                double[] matrix = new double[parameters.length];
                for (int i = 0; i < matrix.length; ++i) {
                    matrix[i] = Double.valueOf(parameters[i]);
                }
                AffineTransform i2m = new AffineTransform(matrix);
                Rectangle imageBounds = new Rectangle(width, height);
                try {
                    return new CrsGeoCoding(crs, imageBounds, i2m);
                }
                catch (TransformException e) {
                    Debug.trace(e);
                }
            }
        }
        catch (FactoryException e) {
            Debug.trace(e);
        }
        return null;
    }

    private static GeoCoding createPixelGeoCoding(Product product, Datum datum, Element geoPosElem) {
        Element posEstimatorElement;
        String latBandName = geoPosElem.getChildTextTrim("LATITUDE_BAND");
        String lonBandName = geoPosElem.getChildTextTrim("LONGITUDE_BAND");
        Band latBand = product.getBand(latBandName);
        Band lonBand = product.getBand(lonBandName);
        Element searchRadiusElem = geoPosElem.getChild("SEARCH_RADIUS");
        int searchRadius = Integer.parseInt(searchRadiusElem.getTextTrim());
        if (searchRadius == 0) {
            searchRadius = 6;
        }
        String validMask = null;
        if (geoPosElem.getChild("VALID_MASK_EXPRESSION") != null) {
            validMask = geoPosElem.getChildTextTrim("VALID_MASK_EXPRESSION");
        }
        if ((posEstimatorElement = geoPosElem.getChild("Pixel_Position_Estimator")) != null) {
            Content posEstimatorContent = posEstimatorElement.detach();
            Document dom = new Document();
            dom.addContent(posEstimatorContent);
            product.setSceneGeoCoding(DimapProductHelpers.createGeoCoding(dom, product)[0]);
        }
        return GeoCodingFactory.createPixelGeoCoding(latBand, lonBand, validMask, searchRadius);
    }

    private static FXYGeoCoding createFXYGeoCoding(Datum datum, Element geoPosElem) {
        Element geoPosInsertElem = geoPosElem.getChild("Geoposition_Insert");
        String ulxString = geoPosInsertElem.getChildTextTrim("ULXMAP");
        float ulX = Float.parseFloat(ulxString);
        String ulyString = geoPosInsertElem.getChildTextTrim("ULYMAP");
        float ulY = Float.parseFloat(ulyString);
        String xDimString = geoPosInsertElem.getChildTextTrim("XDIM");
        float xDim = Float.parseFloat(xDimString);
        String yDimString = geoPosInsertElem.getChildTextTrim("YDIM");
        float yDim = Float.parseFloat(yDimString);
        Element simplifiedLMElem = geoPosElem.getChild("Simplified_Location_Model");
        Element directLMElem = simplifiedLMElem.getChild("Direct_Location_Model");
        String dlmOrderString = directLMElem.getAttributeValue("order");
        int dlmOrder = Integer.parseInt(dlmOrderString);
        Element lcListElem = directLMElem.getChild("lc_List");
        List lcElems = lcListElem.getChildren("lc");
        double[] lambdaCoeffs = DimapProductHelpers.readCoefficients(lcElems);
        Element pcListElem = directLMElem.getChild("pc_List");
        List pcElems = pcListElem.getChildren("pc");
        double[] phiCoeffs = DimapProductHelpers.readCoefficients(pcElems);
        Element reverseLMElem = simplifiedLMElem.getChild("Reverse_Location_Model");
        String rlmOrderString = reverseLMElem.getAttributeValue("order");
        int rlmOrder = Integer.parseInt(rlmOrderString);
        Element icListElem = reverseLMElem.getChild("ic_List");
        List icElems = icListElem.getChildren("ic");
        double[] xCoeffs = DimapProductHelpers.readCoefficients(icElems);
        Element jcListElem = reverseLMElem.getChild("jc_List");
        List jcElems = jcListElem.getChildren("jc");
        double[] yCoeffs = DimapProductHelpers.readCoefficients(jcElems);
        FXYSum lambdaSum = FXYSum.createFXYSum(dlmOrder, lambdaCoeffs);
        FXYSum phiSum = FXYSum.createFXYSum(dlmOrder, phiCoeffs);
        FXYSum xSum = FXYSum.createFXYSum(rlmOrder, xCoeffs);
        FXYSum ySum = FXYSum.createFXYSum(rlmOrder, yCoeffs);
        return new FXYGeoCoding(ulX, ulY, xDim, yDim, xSum, ySum, phiSum, lambdaSum, datum);
    }

    private static Datum createDatum(Document dom) {
        Element ellipsoidParamElem;
        Element ellipsoidElem;
        Element horizontalDatumElem;
        Element gcsElem;
        Element hcsElem;
        Element crsElem = dom.getRootElement().getChild("Coordinate_Reference_System");
        if (crsElem != null && (hcsElem = crsElem.getChild("Horizontal_CS")) != null && (gcsElem = hcsElem.getChild("Geographic_CS")) != null && (horizontalDatumElem = gcsElem.getChild("Horizontal_Datum")) != null && (ellipsoidElem = horizontalDatumElem.getChild("Ellipsoid")) != null && (ellipsoidParamElem = ellipsoidElem.getChild("Ellipsoid_Parameters")) != null) {
            Element majorAxisElem = ellipsoidParamElem.getChild("ELLIPSOID_MAJ_AXIS");
            Element minorAxisElem = ellipsoidParamElem.getChild("ELLIPSOID_MIN_AXIS");
            if (majorAxisElem != null && minorAxisElem != null) {
                double majorAxis = Double.parseDouble(majorAxisElem.getTextTrim());
                double minorAxis = Double.parseDouble(minorAxisElem.getTextTrim());
                String ellipsoidName = ellipsoidElem.getChildTextTrim("ELLIPSOID_NAME");
                Ellipsoid ellipsoid = new Ellipsoid(ellipsoidName, minorAxis, majorAxis);
                String datumName = horizontalDatumElem.getChildTextTrim("HORIZONTAL_DATUM_NAME");
                return new Datum(datumName, ellipsoid, 0.0, 0.0, 0.0);
            }
        }
        return Datum.WGS_84;
    }

    private static double[] readCoefficients(List elementList) {
        double[] coeffs = new double[elementList.size()];
        for (Object anElement : elementList) {
            Element element = (Element)anElement;
            String indexString = element.getAttribute("index").getValue();
            int index = Integer.parseInt(indexString);
            coeffs[index] = Double.parseDouble(element.getTextTrim());
        }
        return coeffs;
    }

    private static MapInfo createMapInfoSinceDimap1_4_0(Element horCsElem) {
        try {
            String resamplingName;
            int sceneHeight;
            int sceneWidth;
            boolean sceneFitted;
            boolean orthorectified;
            String elevModelName;
            double noDataValue;
            float orientation;
            String mapUnit;
            float pixelSizeY;
            float pixelSizeX;
            float northing;
            float easting;
            float pixelY;
            float pixelX;
            Element geographicCsElem = horCsElem.getChild("Geographic_CS");
            Element horDatumElem = geographicCsElem.getChild("Horizontal_Datum");
            Element horDatumNameElem = horDatumElem.getChild("HORIZONTAL_DATUM_NAME");
            String datumName = horDatumNameElem.getTextTrim();
            Element ellipsoidElem = horDatumElem.getChild("Ellipsoid");
            Element ellipsoidNameElem = ellipsoidElem.getChild("ELLIPSOID_NAME");
            String ellipsoidName = ellipsoidNameElem.getTextTrim();
            Element ellipsParamsElem = ellipsoidElem.getChild("Ellipsoid_Parameters");
            Element semiMinorElem = ellipsParamsElem.getChild("ELLIPSOID_MIN_AXIS");
            String semiMinorText = semiMinorElem.getTextTrim();
            double semiMinor = Double.parseDouble(semiMinorText);
            Element semiMajorelem = ellipsParamsElem.getChild("ELLIPSOID_MAJ_AXIS");
            String semiMajorText = semiMajorelem.getTextTrim();
            double semiMajor = Double.parseDouble(semiMajorText);
            Element projectionElem = horCsElem.getChild("Projection");
            Element projectionNameElem = projectionElem.getChild("NAME");
            String projectionName = projectionNameElem.getTextTrim();
            Element projCtMethodElem = projectionElem.getChild("Projection_CT_Method");
            Element projectionTypeIDElem = projCtMethodElem.getChild("PROJECTION_CT_NAME");
            String projectionTypeID = projectionTypeIDElem.getTextTrim();
            Element projParametersElem = projCtMethodElem.getChild("Projection_Parameters");
            List projParamList = projParametersElem.getChildren("Projection_Parameter");
            Element[] projParams = projParamList.toArray(new Element[0]);
            double[] parameterValues = new double[projParamList.size()];
            for (int i = 0; i < parameterValues.length; ++i) {
                Element projParam = projParams[i];
                Element valueTextElem = projParam.getChild("PROJECTION_PARAMETER_VALUE");
                String valueText = valueTextElem.getTextTrim();
                parameterValues[i] = Double.parseDouble(valueText);
            }
            Element mapInfoElement = horCsElem.getChild("MAP_INFO");
            String mapInfoText = mapInfoElement.getTextTrim();
            if (!org.esa.snap.core.util.StringUtils.isNullOrEmpty(mapInfoText)) {
                String[] mapInfoStrings = org.esa.snap.core.util.StringUtils.toStringArray(mapInfoText, null);
                int offs = mapInfoStrings.length % 11;
                pixelX = Float.parseFloat(mapInfoStrings[1 + offs]);
                pixelY = Float.parseFloat(mapInfoStrings[2 + offs]);
                easting = Float.parseFloat(mapInfoStrings[3 + offs]);
                northing = Float.parseFloat(mapInfoStrings[4 + offs]);
                pixelSizeX = Float.parseFloat(mapInfoStrings[5 + offs]);
                pixelSizeY = Float.parseFloat(mapInfoStrings[6 + offs]);
                mapUnit = mapInfoStrings[8 + offs].substring(6);
                orientation = 0.0f;
                noDataValue = 9999.0;
                elevModelName = null;
                orthorectified = false;
                sceneFitted = false;
                sceneWidth = 0;
                sceneHeight = 0;
                resamplingName = "NEAREST_NEIGHBOUR";
            } else {
                Element pixelXElem = mapInfoElement.getChild("PIXEL_X");
                pixelX = Float.parseFloat(pixelXElem.getAttributeValue("value"));
                Element pixelYElem = mapInfoElement.getChild("PIXEL_Y");
                pixelY = Float.parseFloat(pixelYElem.getAttributeValue("value"));
                Element eastingElem = mapInfoElement.getChild("EASTING");
                easting = Float.parseFloat(eastingElem.getAttributeValue("value"));
                Element northingElem = mapInfoElement.getChild("NORTHING");
                northing = Float.parseFloat(northingElem.getAttributeValue("value"));
                Element orientationElem = mapInfoElement.getChild("ORIENTATION");
                orientation = Float.parseFloat(orientationElem.getAttributeValue("value"));
                Element pixelSizeXElem = mapInfoElement.getChild("PIXELSIZE_X");
                pixelSizeX = Float.parseFloat(pixelSizeXElem.getAttributeValue("value"));
                Element pixelSizeYElem = mapInfoElement.getChild("PIXELSIZE_Y");
                pixelSizeY = Float.parseFloat(pixelSizeYElem.getAttributeValue("value"));
                Element noDataValueElem = mapInfoElement.getChild("NODATA_VALUE");
                noDataValue = Float.parseFloat(noDataValueElem.getAttributeValue("value"));
                Element mapUnitElem = mapInfoElement.getChild("MAPUNIT");
                mapUnit = mapUnitElem.getAttributeValue("value");
                Element orthoElement = mapInfoElement.getChild("ORTHORECTIFIED");
                orthorectified = Boolean.parseBoolean(orthoElement.getAttributeValue("value"));
                Element elevModelElem = mapInfoElement.getChild("ELEVATION_MODEL");
                elevModelName = elevModelElem.getAttributeValue("value").trim();
                Element sceneFittedElem = mapInfoElement.getChild("SCENE_FITTED");
                sceneFitted = Boolean.parseBoolean(sceneFittedElem.getAttributeValue("value"));
                Element sceneWidthElem = mapInfoElement.getChild("SCENE_WIDTH");
                sceneWidth = Integer.parseInt(sceneWidthElem.getAttributeValue("value"));
                Element sceneHeightElem = mapInfoElement.getChild("SCENE_HEIGHT");
                sceneHeight = Integer.parseInt(sceneHeightElem.getAttributeValue("value"));
                Element resamplingElem = mapInfoElement.getChild("RESAMPLING");
                resamplingName = resamplingElem.getAttributeValue("value");
            }
            MapTransformDescriptor descriptor = MapProjectionRegistry.getDescriptor(projectionTypeID);
            MapTransform mapTransform = descriptor.createTransform(parameterValues);
            MapProjection projection = new MapProjection(projectionName, mapTransform, mapUnit);
            Ellipsoid ellipsoid = new Ellipsoid(ellipsoidName, semiMinor, semiMajor);
            Datum datum = new Datum(datumName, ellipsoid, 0.0, 0.0, 0.0);
            MapInfo mapInfo = new MapInfo(projection, pixelX, pixelY, easting, northing, pixelSizeX, pixelSizeY, datum);
            mapInfo.setOrientation(orientation);
            mapInfo.setNoDataValue(noDataValue);
            mapInfo.setOrthorectified(orthorectified);
            mapInfo.setElevationModelName(elevModelName);
            mapInfo.setSceneSizeFitted(sceneFitted);
            mapInfo.setSceneWidth(sceneWidth);
            mapInfo.setSceneHeight(sceneHeight);
            Resampling resampling = ResamplingFactory.createResampling(resamplingName);
            if (resampling != null) {
                mapInfo.setResampling(resampling);
            } else {
                Debug.trace("Unknown resampling: '" + resamplingName + "'");
            }
            return mapInfo;
        }
        catch (Exception e) {
            Debug.trace("Malformed geo-coding");
            Debug.trace(e);
            return null;
        }
    }

    private static String getTiePointGridIndex(Element rootElement, String tiePointGridName) {
        Element tiePointGrids = rootElement.getChild("Tie_Point_Grids");
        if (tiePointGrids != null) {
            List tiePointGridInfos = tiePointGrids.getChildren("Tie_Point_Grid_Info");
            for (Object child : tiePointGridInfos) {
                Element tiePointGridInfo = (Element)child;
                String actualTiePointGridName = tiePointGridInfo.getChildTextTrim("TIE_POINT_GRID_NAME");
                if (!tiePointGridName.equals(actualTiePointGridName)) continue;
                return tiePointGridInfo.getChildTextTrim("TIE_POINT_GRID_INDEX");
            }
        }
        return null;
    }

    public static int getTiePointDataType(Element rootElement, String tiePointGridName) {
        Element tiePointGrids = rootElement.getChild("Tie_Point_Grids");
        if (tiePointGrids != null) {
            List tiePointGridInfos = tiePointGrids.getChildren("Tie_Point_Grid_Info");
            for (Object child : tiePointGridInfos) {
                Element tiePointGridInfo = (Element)child;
                String actualTiePointGridName = tiePointGridInfo.getChildTextTrim("TIE_POINT_GRID_NAME");
                if (!tiePointGridName.equals(actualTiePointGridName)) continue;
                return ProductData.getType(tiePointGridInfo.getChildTextTrim("DATA_TYPE"));
            }
        }
        return 0;
    }

    private static String getBandName(Element rootElement, String index) {
        Element imageInterpretation = rootElement.getChild("Image_Interpretation");
        if (imageInterpretation != null) {
            List spectralBandInfos = imageInterpretation.getChildren("Spectral_Band_Info");
            for (Object child : spectralBandInfos) {
                Element bandInfo = (Element)child;
                String actualBandIndex = bandInfo.getChildTextTrim("BAND_INDEX");
                if (!index.equals(actualBandIndex)) continue;
                return bandInfo.getChildTextTrim("BAND_NAME");
            }
        }
        return null;
    }

    private static String getTiePointGridName(Element rootElement, String index) {
        Element tiePointGrids = rootElement.getChild("Tie_Point_Grids");
        if (tiePointGrids != null) {
            List tiePointGridInfos = tiePointGrids.getChildren("Tie_Point_Grid_Info");
            for (Object child : tiePointGridInfos) {
                Element tiePointGridInfo = (Element)child;
                String currentTiePointGridIndex = tiePointGridInfo.getChildTextTrim("TIE_POINT_GRID_INDEX");
                if (!index.equals(currentTiePointGridIndex)) continue;
                return tiePointGridInfo.getChildTextTrim("TIE_POINT_GRID_NAME");
            }
        }
        return null;
    }

    @Deprecated
    static void addPins(Document dom, Product product) {
        Element groupElement = dom.getRootElement().getChild("Pin_Group");
        List elements = groupElement != null ? groupElement.getChildren("Placemark") : dom.getRootElement().getChildren("Pin");
        for (Object elementObj : elements) {
            Element element = (Element)elementObj;
            Placemark placemark = PlacemarkIO.createPlacemark(element, PinDescriptor.getInstance(), product.getSceneGeoCoding());
            if (placemark == null) continue;
            product.getPinGroup().add(placemark);
        }
    }

    @Deprecated
    static void addGcps(Document dom, Product product) {
        Element groupElement = dom.getRootElement().getChild("Gcp_Group");
        List elements = groupElement != null ? groupElement.getChildren("Placemark") : Collections.EMPTY_LIST;
        for (Object elementObj : elements) {
            Element element = (Element)elementObj;
            Placemark placemark = PlacemarkIO.createPlacemark(element, GcpDescriptor.getInstance(), product.getSceneGeoCoding());
            if (placemark == null) continue;
            product.getGcpGroup().add(placemark);
        }
    }

    static void addMaskUsages(Document dom, Product product) {
        List imageDisplayElems = dom.getRootElement().getChildren("Image_Display");
        for (Element child : imageDisplayElems) {
            DimapProductHelpers.addMaskUsage(dom.getRootElement(), child, product);
        }
    }

    private static void addMaskUsage(Element rootElement, Element imageDisplayElem, Product product) {
        List maskUsages = imageDisplayElem.getChildren("Mask_Usage");
        for (Element usageElem : maskUsages) {
            TiePointGrid tiePointGrid;
            String tpgName;
            Element tpgIndexElem;
            Band band;
            String bandName;
            Element bandIndexElem;
            String overlayNamesCSV;
            Element overlayNamesElem = usageElem.getChild("OVERLAY");
            String[] overlayNames = null;
            if (overlayNamesElem != null && (overlayNamesCSV = overlayNamesElem.getAttributeValue("names")) != null && overlayNamesCSV.length() != 0) {
                overlayNames = org.esa.snap.core.util.StringUtils.csvToArray(overlayNamesCSV);
            }
            if ((bandIndexElem = usageElem.getChild("BAND_INDEX")) != null && (bandName = DimapProductHelpers.getBandName(rootElement, bandIndexElem.getTextTrim())) != null && (band = product.getBand(bandName)) != null) {
                ProductNodeGroup<Mask> maskGroup = product.getMaskGroup();
                DimapProductHelpers.addMasksToGroup(maskGroup, band.getOverlayMaskGroup(), overlayNames);
            }
            if ((tpgIndexElem = usageElem.getChild("TIE_POINT_GRID_INDEX")) == null || (tpgName = DimapProductHelpers.getTiePointGridName(rootElement, tpgIndexElem.getTextTrim())) == null || (tiePointGrid = product.getTiePointGrid(tpgName)) == null) continue;
            ProductNodeGroup<Mask> maskGroup = product.getMaskGroup();
            DimapProductHelpers.addMasksToGroup(maskGroup, tiePointGrid.getOverlayMaskGroup(), overlayNames);
        }
    }

    private static void addMasksToGroup(ProductNodeGroup<Mask> maskGroup, ProductNodeGroup<Mask> usageMaskGroup, String[] maskNames) {
        if (maskNames == null) {
            return;
        }
        for (String name : maskNames) {
            Mask mask = maskGroup.get(name);
            if (mask == null) continue;
            usageMaskGroup.add(mask);
        }
    }

    public static FileFilter createDimapFileFilter() {
        return new DimapFileFilter();
    }

    public static Document createDom(InputStream inputStream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        org.w3c.dom.Document w3cDocument = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            w3cDocument = builder.parse(inputStream);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Debug.trace(e);
        }
        return new DOMBuilder().build(w3cDocument);
    }

    public static String convertBeamUnitToDimapUnit(String unit) {
        String unitLowerCase = unit.toLowerCase();
        if (unitLowerCase.startsWith("meter")) {
            return "M";
        }
        if (unitLowerCase.startsWith("kilometer")) {
            return "KM";
        }
        if (unitLowerCase.startsWith("deg")) {
            return "DEG";
        }
        if (unitLowerCase.startsWith("rad")) {
            return "RAD";
        }
        return unitLowerCase;
    }

    public static String convertDimapUnitToBeamUnit(String unit) {
        if ("M".equals(unit)) {
            return "meter";
        }
        if ("KM".equals(unit)) {
            return "kilometer";
        }
        if ("DEG".equals(unit)) {
            return "deg";
        }
        if ("RAD".equals(unit)) {
            return "rad";
        }
        return unit;
    }

    public static CoordinateReferenceSystem getCRS(Document dom) {
        Element wktElem;
        Element rootElem = dom.getRootElement();
        Element coordRefSysElem = rootElem.getChild("Coordinate_Reference_System");
        if (coordRefSysElem != null && (wktElem = coordRefSysElem.getChild("WKT")) != null) {
            try {
                return CRS.parseWKT((String)wktElem.getTextTrim());
            }
            catch (FactoryException e) {
                Debug.trace(e);
            }
        }
        return null;
    }

    private static class ProductBuilder {
        private final Document _dom;
        private HashMap<RasterDataNode, List<String>> ancillaryVariables;
        private Product product;

        private ProductBuilder(Document dom) {
            this._dom = dom;
        }

        private Document getDom() {
            return this._dom;
        }

        private Product createProduct(String defaultProductType, Dimension regionRasterSize) {
            if (StringUtils.isBlank((String)defaultProductType)) {
                throw new NullPointerException("The default product type is null or empty.");
            }
            this.ancillaryVariables = new HashMap();
            Dimension productSize = ImageUtils.computeSceneRasterSize(this.getSceneRasterWidth(), this.getSceneRasterHeight(), regionRasterSize);
            String productName = this.getProductName();
            String productType = this.getProductType();
            if (StringUtils.isBlank((String)productType)) {
                productType = defaultProductType;
            }
            this.product = new Product(productName, productType, productSize.width, productSize.height);
            this.setSceneRasterStartAndStopTime();
            this.setDescription();
            this.addQuicklook();
            this.addMasks();
            this.addFlagsCoding();
            this.addIndexCoding();
            this.addBands(regionRasterSize);
            this.addTiePointGrids();
            this.addDisplayInfosToBandsAndTiePointGrids();
            this.addOldBitmaskDefinitions();
            this.addAnnotationDataset();
            this.addPointingFactory();
            this.addCollectedAncillaryVariables();
            return this.product;
        }

        private void addPointingFactory() {
            PointingFactoryRegistry registry = PointingFactoryRegistry.getInstance();
            PointingFactory pointingFactory = registry.getPointingFactory(this.product.getProductType());
            this.product.setPointingFactory(pointingFactory);
        }

        private void addAnnotationDataset() {
            MetadataElement mdElem = this.product.getMetadataRoot();
            if (mdElem == null) {
                return;
            }
            Element datasetSourcesElem = this.getRootElement().getChild("Dataset_Sources");
            if (datasetSourcesElem == null) {
                return;
            }
            Element element = datasetSourcesElem.getChild("MDElem");
            if (element == null) {
                return;
            }
            mdElem.setDescription(element.getAttributeValue("desc"));
            ProductBuilder.addMetadataAttributes(element, mdElem);
            ProductBuilder.addMetadataElements(element, mdElem);
        }

        private static void addMetadataElements(Element element, MetadataElement mdElem) {
            List metadataElements = element.getChildren("MDElem");
            for (Object child : metadataElements) {
                Element metadataElement = (Element)child;
                String elemName = metadataElement.getAttributeValue("name");
                if (elemName == null || elemName.length() == 0) continue;
                MetadataElement newMdElem = new MetadataElement(elemName);
                newMdElem.setDescription(metadataElement.getAttributeValue("desc"));
                ProductBuilder.addMetadataAttributes(metadataElement, newMdElem);
                ProductBuilder.addMetadataElements(metadataElement, newMdElem);
                mdElem.addElement(newMdElem);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void addMetadataAttributes(Element element, MetadataElement mdElem) {
            List attributeElements = element.getChildren("MDATTR");
            for (Object child : attributeElements) {
                ProductData data;
                String attType;
                Element attribElement = (Element)child;
                String attName = attribElement.getAttributeValue("name");
                if (attName == null || attName.length() == 0 || (attType = attribElement.getAttributeValue("type")) == null || attType.length() == 0) continue;
                int type = ProductData.getType(attType);
                String attValue = attribElement.getTextTrim();
                if (attValue == null || attValue.length() == 0) continue;
                if (type == 41) {
                    data = ProductData.createInstance(attValue);
                } else if (type == 51) {
                    if (attValue.contains(",")) {
                        String[] dataValues = org.esa.snap.core.util.StringUtils.csvToArray(attValue);
                        data = ProductData.createInstance(type);
                        data.setElems(dataValues);
                    } else {
                        ProductData.UTC utc = null;
                        try {
                            utc = ProductData.UTC.parse(attValue);
                        }
                        catch (ParseException e) {
                            Debug.trace(e);
                        }
                        finally {
                            data = utc;
                        }
                    }
                } else if (ProductData.isUIntType(type) && attValue.contains("-")) {
                    Object[] elems;
                    int i;
                    String[] dataValues = org.esa.snap.core.util.StringUtils.csvToArray(attValue);
                    int length = dataValues.length;
                    if (type == 20) {
                        byte[] bytes = new byte[length];
                        for (i = 0; i < length; ++i) {
                            bytes[i] = Byte.parseByte(dataValues[i]);
                        }
                        elems = bytes;
                    } else if (type == 21) {
                        short[] shorts = new short[length];
                        for (i = 0; i < length; ++i) {
                            shorts[i] = Short.parseShort(dataValues[i]);
                        }
                        elems = shorts;
                    } else {
                        int[] ints = new int[length];
                        for (i = 0; i < length; ++i) {
                            ints[i] = Integer.parseInt(dataValues[i]);
                        }
                        elems = ints;
                    }
                    data = ProductData.createInstance(type, length);
                    data.setElems(elems);
                } else {
                    String[] dataValues = org.esa.snap.core.util.StringUtils.csvToArray(attValue);
                    int length = dataValues.length;
                    data = ProductData.createInstance(type, length);
                    data.setElems(dataValues);
                }
                if (data == null) continue;
                boolean readOnly = !"rw".equalsIgnoreCase(attribElement.getAttributeValue("mode"));
                MetadataAttribute metadataAttribute = new MetadataAttribute(attName, data, readOnly);
                metadataAttribute.setDescription(attribElement.getAttributeValue("desc"));
                metadataAttribute.setUnit(attribElement.getAttributeValue("unit"));
                mdElem.addAttribute(metadataAttribute);
            }
        }

        private void addDisplayInfosToBandsAndTiePointGrids() {
            List imageDisplayElems = this.getRootElement().getChildren("Image_Display");
            for (Object child : imageDisplayElems) {
                Element imageDisplayElem = (Element)child;
                this.addBandStatistics(imageDisplayElem);
            }
        }

        private void addBandStatistics(Element imageDisplayElem) {
            List bandStatisticsElems = imageDisplayElem.getChildren("Band_Statistics");
            for (Object bandStatistics : bandStatisticsElems) {
                Band band;
                Element bandStatisticsElem = (Element)bandStatistics;
                String bandIndex = bandStatisticsElem.getChildTextTrim("BAND_INDEX");
                String bandName = DimapProductHelpers.getBandName(this.getRootElement(), bandIndex);
                if (bandName == null || (band = this.product.getBand(bandName)) == null) continue;
                Stx stx = ProductBuilder.createStx(band, bandStatisticsElem);
                if (stx != null) {
                    band.setStx(stx);
                }
                band.setImageInfo(ProductBuilder.createImageInfo(bandStatisticsElem));
            }
        }

        private static Stx createStx(Band band, Element bandStatisticsElem) {
            boolean intHistogram;
            Double minSample = ProductBuilder.getElemDouble(bandStatisticsElem, "STX_MIN");
            Double maxSample = ProductBuilder.getElemDouble(bandStatisticsElem, "STX_MAX");
            Double mean = ProductBuilder.getElemDouble(bandStatisticsElem, "STX_MEAN");
            Double stdDev = ProductBuilder.getElemDouble(bandStatisticsElem, "STX_STD_DEV");
            Integer level = ProductBuilder.getElemInt(bandStatisticsElem, "STX_RES_LEVEL");
            int[] bins = ProductBuilder.getHistogramBins(bandStatisticsElem);
            boolean bl = intHistogram = !ProductData.isFloatingPointType(band.getGeophysicalDataType());
            if (minSample != null && maxSample != null) {
                return new StxFactory().withMinimum(minSample).withMaximum(maxSample).withMean(mean).withStandardDeviation(stdDev).withIntHistogram(intHistogram).withHistogramBins(bins == null ? new int[]{} : bins).withResolutionLevel(level).create();
            }
            return null;
        }

        private static ImageInfo createImageInfo(Element bandStatisticsElem) {
            Element histomElem;
            ColorPaletteDef.Point[] points = ProductBuilder.getColorPalettePoints(bandStatisticsElem);
            int numColors = ProductBuilder.getNumColors(bandStatisticsElem);
            ImageInfo imageInfo = new ImageInfo(new ColorPaletteDef(points, numColors));
            Element noDataElem = bandStatisticsElem.getChild("NO_DATA_COLOR");
            if (noDataElem != null) {
                imageInfo.setNoDataColor(DimapProductHelpers.createColor(noDataElem));
            }
            if ((histomElem = bandStatisticsElem.getChild("HISTOGRAM_MATCHING")) != null && histomElem.getValue() != null) {
                imageInfo.setHistogramMatching(ImageInfo.getHistogramMatching(histomElem.getValue()));
            }
            return imageInfo;
        }

        private static Double getElemDouble(Element element, String tag) {
            String text = element.getChildTextTrim(tag);
            if (text != null) {
                try {
                    return Double.parseDouble(text);
                }
                catch (NumberFormatException e) {
                    SystemUtils.LOG.severe("Number format exception at reading DIMAP product tag '" + tag + "'");
                    SystemUtils.LOG.log(Level.SEVERE, "Number format exception at reading DIMAP product tag '" + tag + "'", e);
                    return null;
                }
            }
            return null;
        }

        private static Integer getElemInt(Element element, String tag) {
            String text = element.getChildTextTrim(tag);
            if (text != null) {
                try {
                    return Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    SystemUtils.LOG.severe("Number format exception at reading DIMAP product tag '" + tag + "'");
                    SystemUtils.LOG.log(Level.SEVERE, "Number format exception at reading DIMAP product tag '" + tag + "'", e);
                    return null;
                }
            }
            return null;
        }

        private static int getNumColors(Element bandStatisticsElem) {
            int numColors = 256;
            try {
                numColors = Integer.parseInt(bandStatisticsElem.getChildTextTrim("NUM_COLORS"));
            }
            catch (NumberFormatException e) {
                Debug.trace(e);
            }
            return numColors;
        }

        private static int[] getHistogramBins(Element bandStatisticsElem) {
            String histogramValues = bandStatisticsElem.getChildTextTrim("HISTOGRAM");
            if (org.esa.snap.core.util.StringUtils.isNullOrEmpty(histogramValues)) {
                return null;
            }
            return org.esa.snap.core.util.StringUtils.toIntArray(histogramValues, null);
        }

        private static ColorPaletteDef.Point[] getColorPalettePoints(Element bandStatisticsElem) {
            List colorPalettePointElems = bandStatisticsElem.getChildren("Color_Palette_Point");
            ColorPaletteDef.Point[] points = null;
            if (colorPalettePointElems.size() > 1) {
                Iterator iteratorCPPE = colorPalettePointElems.iterator();
                points = new ColorPaletteDef.Point[colorPalettePointElems.size()];
                for (int i = 0; i < points.length; ++i) {
                    Element colorPalettePointElem = (Element)iteratorCPPE.next();
                    Color color = DimapProductHelpers.createColor(colorPalettePointElem.getChild("COLOR"));
                    double sample = ProductBuilder.getSample(colorPalettePointElem);
                    String label = ProductBuilder.getLabel(colorPalettePointElem);
                    points[i] = new ColorPaletteDef.Point(sample, color, label);
                }
            }
            return points;
        }

        private static double getSample(Element colorPalettePointElem) {
            Element sampleElem = colorPalettePointElem.getChild("SAMPLE");
            if (sampleElem != null) {
                return Double.parseDouble(sampleElem.getTextTrim());
            }
            return 0.0;
        }

        private static String getLabel(Element colorPalettePointElem) {
            Element labelElem = colorPalettePointElem.getChild("LABEL");
            if (labelElem != null) {
                return labelElem.getTextTrim();
            }
            return "";
        }

        private void addTiePointGrids() {
            Element parent = this.getRootElement().getChild("Tie_Point_Grids");
            if (parent != null) {
                List children = parent.getChildren("Tie_Point_Grid_Info");
                for (Object child : children) {
                    boolean cyclic;
                    Element gridInfo = (Element)child;
                    String name = gridInfo.getChildTextTrim("TIE_POINT_GRID_NAME");
                    int width = Integer.parseInt(gridInfo.getChildTextTrim("NCOLS"));
                    int height = Integer.parseInt(gridInfo.getChildTextTrim("NROWS"));
                    double offsX = Double.parseDouble(gridInfo.getChildTextTrim("OFFSET_X"));
                    double offsY = Double.parseDouble(gridInfo.getChildTextTrim("OFFSET_Y"));
                    double subsX = Double.parseDouble(gridInfo.getChildTextTrim("STEP_X"));
                    double subsY = Double.parseDouble(gridInfo.getChildTextTrim("STEP_Y"));
                    TiePointGrid tiePointGrid = new TiePointGrid(name, width, height, offsX, offsY, subsX, subsY);
                    Element cyclicElem = gridInfo.getChild("CYCLIC");
                    if (cyclicElem != null && (cyclic = Boolean.parseBoolean(cyclicElem.getTextTrim()))) {
                        String intVal = cyclicElem.getAttributeValue("discontinuity", String.valueOf(-1));
                        int discontinuity = Integer.parseInt(intVal);
                        tiePointGrid.setDiscontinuity(discontinuity);
                    }
                    tiePointGrid.setDescription(gridInfo.getChildTextTrim("TIE_POINT_DESCRIPTION"));
                    tiePointGrid.setUnit(gridInfo.getChildTextTrim("PHYSICAL_UNIT"));
                    ProductBuilder.setImageToModelTransform(gridInfo, tiePointGrid);
                    ProductBuilder.setAncillaryRelations(gridInfo, tiePointGrid);
                    this.collectAncillaryVariables(gridInfo, tiePointGrid);
                    this.product.addTiePointGrid(tiePointGrid);
                }
            }
        }

        private void addFlagsCoding() {
            this.addSampleCoding("Flag_Coding", "Flag", "Flag_Name", "Flag_Index", "Flag_description");
        }

        private void addIndexCoding() {
            this.addSampleCoding("Index_Coding", "Index", "INDEX_NAME", "INDEX_VALUE", "INDEX_DESCRIPTION");
        }

        private void addSampleCoding(String tagNameSampleCoding, String tagNameSampleElements, String tagNameSampleName, String tagNameSampleValue, String tagNameSampleDescription) {
            List children = this.getRootElement().getChildren(tagNameSampleCoding);
            for (Object aChildren : children) {
                SampleCoding sampleCoding;
                Element flagCodingElem = (Element)aChildren;
                String codingName = flagCodingElem.getAttributeValue("name");
                if (tagNameSampleElements.equals("Index")) {
                    IndexCoding indexCoding = new IndexCoding(codingName);
                    this.product.getIndexCodingGroup().add(indexCoding);
                    sampleCoding = indexCoding;
                } else {
                    FlagCoding flagCoding = new FlagCoding(codingName);
                    this.product.getFlagCodingGroup().add(flagCoding);
                    sampleCoding = flagCoding;
                }
                this.addSamples(tagNameSampleElements, tagNameSampleName, tagNameSampleValue, tagNameSampleDescription, flagCodingElem, sampleCoding);
            }
        }

        private void addSamples(String tagNameSampleElements, String tagNameSampleName, String tagNameSampleValue, String tagNameSampleDescription, Element sampleCodingElement, SampleCoding sampleCoding) {
            List list = sampleCodingElement.getChildren(tagNameSampleElements);
            for (Object o : list) {
                Element element = (Element)o;
                String name = element.getChildTextTrim(tagNameSampleName);
                int value = Integer.parseInt(element.getChildTextTrim(tagNameSampleValue));
                String description = element.getChildTextTrim(tagNameSampleDescription);
                sampleCoding.addSample(name, value, description);
            }
        }

        private void addMasks() {
            Element parent = this.getRootElement().getChild("Masks");
            if (parent != null) {
                List children = parent.getChildren("Mask");
                for (Element child : children) {
                    Object object;
                    DimapPersistable persistable = DimapPersistence.getPersistable(child);
                    if (persistable == null || !((object = persistable.createObjectFromXml(child, this.product, null)) instanceof Mask)) continue;
                    this.product.getMaskGroup().add((Mask)object);
                }
            }
        }

        private void addOldBitmaskDefinitions() {
            Element bitmaskDefs = this.getRootElement().getChild("Bitmask_Definitions");
            List bitmaskDefList = bitmaskDefs != null ? bitmaskDefs.getChildren("Bitmask_Definition") : this.getRootElement().getChildren("Bitmask_Definition");
            for (Object child : bitmaskDefList) {
                Element bitmaskDefElem = (Element)child;
                String name = bitmaskDefElem.getAttributeValue("name");
                String description = null;
                Element descElem = bitmaskDefElem.getChild("DESCRIPTION");
                if (descElem != null) {
                    description = descElem.getAttributeValue("value").trim();
                }
                String expression = bitmaskDefElem.getChild("EXPRESSION").getAttributeValue("value").trim();
                Color color = DimapProductHelpers.createColor(bitmaskDefElem.getChild("COLOR"));
                float transparency = 0.5f;
                try {
                    transparency = Float.parseFloat(bitmaskDefElem.getChild("TRANSPARENCY").getAttributeValue("value"));
                }
                catch (NumberFormatException e) {
                    Debug.trace(e);
                }
                this.product.addMask(name, expression, description, color, (double)transparency);
            }
        }

        private void addBands(Dimension regionRasterSize) {
            Element child = this.getRootElement().getChild("Image_Interpretation");
            if (child != null) {
                this.addSpectralBands(child, regionRasterSize);
            }
        }

        private static void setAutoGrouping(Element element, Product product) {
            String text = element.getChildTextTrim("DATASET_AUTO_GROUPING");
            if (org.esa.snap.core.util.StringUtils.isNotNullAndNotEmpty(text)) {
                product.setAutoGrouping(text);
            } else {
                product.setAutoGrouping("");
            }
        }

        private void addSpectralBands(Element parent, Dimension regionRasterSize) {
            Band band;
            Element element;
            List children = parent.getChildren("Spectral_Band_Info");
            ArrayList<Element> filterBandElementList = new ArrayList<Element>();
            for (Object e : children) {
                element = (Element)e;
                if (ProductBuilder.isFilterBand(element)) {
                    filterBandElementList.add(element);
                    continue;
                }
                band = ProductBuilder.addBand(element, this.product, regionRasterSize);
                ProductBuilder.setGeneralBandProperties(band, element, this.product);
                this.collectAncillaryVariables(element, band);
            }
            for (Object e : filterBandElementList) {
                element = (Element)e;
                band = ProductBuilder.addBand(element, this.product, regionRasterSize);
                ProductBuilder.setGeneralBandProperties(band, element, this.product);
                this.collectAncillaryVariables(element, band);
            }
        }

        private static void setGeneralBandProperties(Band band, Element element, Product product) {
            if (band != null) {
                String validMaskExpression = ProductBuilder.getValidMaskExpression(element);
                if (validMaskExpression != null && validMaskExpression.trim().length() > 0) {
                    band.setValidPixelExpression(validMaskExpression);
                }
                ProductBuilder.setUnit(element, band);
                ProductBuilder.setSpectralWaveLength(element, band);
                ProductBuilder.setSpectralBandWidth(element, band);
                ProductBuilder.setSolarFlux(element, band);
                ProductBuilder.setSpectralBandIndex(element, band);
                ProductBuilder.setScaling(element, band);
                ProductBuilder.setFlagCoding(element, band, product);
                ProductBuilder.setIndexCoding(element, band, product);
                ProductBuilder.setNoDataValueUsed(element, band);
                ProductBuilder.setNoDataValue(element, band);
                ProductBuilder.setAncillaryRelations(element, band);
                ProductBuilder.setImageToModelTransform(element, band);
            }
        }

        private static String getValidMaskExpression(Element element) {
            return element.getChildTextTrim("VALID_MASK_TERM");
        }

        private static void setFlagCoding(Element element, Band band, Product product) {
            FlagCoding flagCoding;
            String codingName = element.getChildTextTrim("FLAG_CODING_NAME");
            if (codingName != null && (flagCoding = product.getFlagCodingGroup().get(codingName)) != null) {
                band.setSampleCoding(flagCoding);
            }
        }

        private static void setIndexCoding(Element element, Band band, Product product) {
            IndexCoding indexCoding;
            String codingName = element.getChildTextTrim("INDEX_CODING_NAME");
            if (codingName != null && (indexCoding = product.getIndexCodingGroup().get(codingName)) != null) {
                band.setSampleCoding(indexCoding);
            }
        }

        private static void setSolarFlux(Element element, Band band) {
            String solarFlux = element.getChildTextTrim("SOLAR_FLUX");
            if (solarFlux != null) {
                band.setSolarFlux(Float.parseFloat(solarFlux));
            }
        }

        private static void setSpectralBandIndex(Element element, Band band) {
            String spectralBandIndex = element.getChildTextTrim("SPECTRAL_BAND_INDEX");
            if (spectralBandIndex != null) {
                band.setSpectralBandIndex(Integer.parseInt(spectralBandIndex));
            } else {
                band.setSpectralBandIndex(-1);
            }
        }

        private static void setScaling(Element element, Band band) {
            String log10ScaledString;
            String scalingOffsetString;
            String scalingFactorString = element.getChildTextTrim("SCALING_FACTOR");
            if (scalingFactorString != null) {
                band.setScalingFactor(Double.parseDouble(scalingFactorString));
            }
            if ((scalingOffsetString = element.getChildTextTrim("SCALING_OFFSET")) != null) {
                band.setScalingOffset(Double.parseDouble(scalingOffsetString));
            }
            if ((log10ScaledString = element.getChildTextTrim("LOG10_SCALED")) != null) {
                band.setLog10Scaled(Boolean.parseBoolean(log10ScaledString));
            }
        }

        private static Band addBand(Element element, Product product, Dimension regionRasterSize) {
            int rasterHeight;
            int rasterWidth;
            Band band = null;
            String bandName = element.getChildTextTrim("BAND_NAME");
            String bandRasterWidthStr = element.getChildTextTrim("BAND_RASTER_WIDTH");
            String bandRasterHeightStr = element.getChildTextTrim("BAND_RASTER_HEIGHT");
            if (bandRasterWidthStr != null && bandRasterHeightStr != null) {
                rasterWidth = Integer.parseInt(bandRasterWidthStr);
                rasterHeight = Integer.parseInt(bandRasterHeightStr);
            } else {
                rasterWidth = product.getSceneRasterWidth();
                rasterHeight = product.getSceneRasterHeight();
            }
            Dimension bandSize = ImageUtils.computeSceneRasterSize(rasterWidth, rasterHeight, regionRasterSize);
            String description = element.getChildTextTrim("BAND_DESCRIPTION");
            String typeAsString = element.getChildTextTrim("DATA_TYPE");
            if (typeAsString == null) {
                return null;
            }
            int type = ProductData.getType(typeAsString);
            if (type == 0) {
                return null;
            }
            if (ProductBuilder.isVirtualBand(element)) {
                VirtualBand virtualBand = new VirtualBand(bandName, type, bandSize.width, bandSize.height, ProductBuilder.getExpression(element));
                product.addBand(virtualBand);
                virtualBand.setNoDataValue(ProductBuilder.getInvalidValue(element));
                virtualBand.setNoDataValueUsed(ProductBuilder.getUseInvalidValue(element));
                band = virtualBand;
            } else if (ProductBuilder.isFilterBand(element)) {
                DimapPersistable persistable = DimapPersistence.getPersistable(element);
                if (persistable != null && (band = (Band)persistable.createObjectFromXml(element, product, regionRasterSize)) != null) {
                    product.addBand(band);
                }
            } else {
                band = new Band(bandName, type, bandSize.width, bandSize.height);
                product.addBand(band);
            }
            if (band != null) {
                band.setDescription(description);
            }
            return band;
        }

        private static float getInvalidValue(Element element) {
            return ProductBuilder.getFloatValue(element, "INVALID_VALUE");
        }

        private static float getFloatValue(Element element, String key) {
            String sfloat = null;
            if (element != null) {
                sfloat = element.getChildTextTrim(key);
            }
            if (sfloat != null) {
                try {
                    return Float.parseFloat(sfloat);
                }
                catch (NumberFormatException e) {
                    Debug.trace(e);
                    return 0.0f;
                }
            }
            return 0.0f;
        }

        private static String getExpression(Element element) {
            if (element != null) {
                return element.getChildTextTrim("EXPRESSION");
            }
            return null;
        }

        private static boolean getUseInvalidValue(Element element) {
            return ProductBuilder.is(element, "USE_INVALID_VALUE");
        }

        private static boolean isVirtualBand(Element element) {
            return ProductBuilder.is(element, "VIRTUAL_BAND");
        }

        private static boolean isFilterBand(Element element) {
            return element != null && element.getChild("Filter_Band_Info") != null;
        }

        private static boolean is(Element element, String tagName) {
            if (element == null) {
                return false;
            }
            String childTextTrim = element.getChildTextTrim(tagName);
            return Boolean.parseBoolean(childTextTrim);
        }

        private static void setSpectralWaveLength(Element element, Band band) {
            String bandWavelen = element.getChildTextTrim("BAND_WAVELEN");
            if (bandWavelen != null) {
                band.setSpectralWavelength(Float.parseFloat(bandWavelen));
            }
        }

        private static void setSpectralBandWidth(Element element, Band band) {
            String bandWidth = element.getChildTextTrim("BANDWIDTH");
            if (bandWidth != null) {
                band.setSpectralBandwidth(Float.parseFloat(bandWidth));
            }
        }

        private void addCollectedAncillaryVariables() {
            Set<Map.Entry<RasterDataNode, List<String>>> entries = this.ancillaryVariables.entrySet();
            for (Map.Entry<RasterDataNode, List<String>> entry : entries) {
                List<String> variableNames = entry.getValue();
                RasterDataNode dataNode = entry.getKey();
                for (String variableName : variableNames) {
                    dataNode.addAncillaryVariable(this.product.getRasterDataNode(variableName), new String[0]);
                }
            }
        }

        private void collectAncillaryVariables(Element element, RasterDataNode rasterDataNode) {
            List children = element.getChildren("ANCILLARY_VARIABLE");
            if (children.size() == 0) {
                return;
            }
            if (!this.ancillaryVariables.containsKey(rasterDataNode)) {
                this.ancillaryVariables.put(rasterDataNode, new ArrayList());
            }
            List<String> variableNames = this.ancillaryVariables.get(rasterDataNode);
            for (Element child : children) {
                variableNames.add(child.getTextTrim());
            }
        }

        private static void setAncillaryRelations(Element element, RasterDataNode rasterDataNode) {
            List children = element.getChildren("ANCILLARY_RELATION");
            TreeSet<String> relationsSet = new TreeSet<String>();
            for (Element child : children) {
                relationsSet.add(child.getTextTrim());
            }
            String[] relations = relationsSet.toArray(new String[0]);
            rasterDataNode.setAncillaryRelations(relations);
        }

        private static void setImageToModelTransform(Element element, RasterDataNode rasterDataNode) {
            if (!rasterDataNode.isSourceImageSet()) {
                String transform = element.getChildTextTrim("IMAGE_TO_MODEL_TRANSFORM");
                if (transform != null && transform.length() > 0) {
                    double[] matrix = org.esa.snap.core.util.StringUtils.toDoubleArray(transform, null);
                    rasterDataNode.setImageToModelTransform(new AffineTransform(matrix));
                }
            } else {
                SystemUtils.LOG.warning(String.format("RasterDataNode '%s': can't set image-to-model transform, source image already set", rasterDataNode.getName()));
            }
        }

        private static void setNoDataValue(Element element, Band band) {
            String noDataValue = element.getChildTextTrim("NO_DATA_VALUE");
            if (noDataValue != null) {
                band.setNoDataValue(Double.parseDouble(noDataValue));
            }
        }

        private static void setNoDataValueUsed(Element element, Band band) {
            String noDataValueUsed = element.getChildTextTrim("NO_DATA_VALUE_USED");
            if (noDataValueUsed != null) {
                band.setNoDataValueUsed(Boolean.parseBoolean(noDataValueUsed));
            }
        }

        private static void setUnit(Element element, Band band) {
            String unit = element.getChildTextTrim("PHYSICAL_UNIT");
            if (unit != null) {
                band.setUnit(unit);
            }
        }

        private String getProductName() {
            Element child = this.getRootElement().getChild("Dataset_Id");
            if (child != null) {
                return child.getChildTextTrim("DATASET_NAME");
            }
            return "";
        }

        private void addQuicklook() {
            String quicklookString = this.getQuicklookBandName();
            if (quicklookString != null) {
                this.product.setQuicklookBandName(quicklookString);
            }
        }

        private void setDescription() {
            if (this.product == null) {
                return;
            }
            String description = null;
            Element child = this.getRootElement().getChild("Dataset_Use");
            if (child != null) {
                description = child.getChildTextTrim("DATASET_COMMENTS");
                ProductBuilder.setAutoGrouping(child, this.product);
            }
            if ((description == null || description.length() == 0) && (child = this.getRootElement().getChild("Dataset_Id")) != null) {
                description = child.getChildTextTrim("DATASET_DESCRIPTION");
            }
            if (description != null && description.length() > 0) {
                this.product.setDescription(description);
            }
        }

        private void setSceneRasterStartAndStopTime() {
            ProductData.UTC sceneRasterStopTime;
            ProductData.UTC sceneRasterStartTime = this.getSceneRasterStartTime();
            if (sceneRasterStartTime != null) {
                this.product.setStartTime(sceneRasterStartTime);
            }
            if ((sceneRasterStopTime = this.getSceneRasterStopTime()) != null) {
                this.product.setEndTime(sceneRasterStopTime);
            }
        }

        private String getProductType() {
            Element child = this.getRootElement().getChild("Production");
            return child.getChildTextTrim("PRODUCT_TYPE");
        }

        private String getQuicklookBandName() {
            Element child = this.getRootElement().getChild("Production");
            return child.getChildTextTrim("QUICKLOOK_BAND_NAME");
        }

        private ProductData.UTC getSceneRasterStartTime() {
            Element child = this.getRootElement().getChild("Production");
            String timeString = child.getChildTextTrim("PRODUCT_SCENE_RASTER_START_TIME");
            if (org.esa.snap.core.util.StringUtils.isNullOrEmpty(timeString)) {
                timeString = child.getChildTextTrim("SENSING_START");
            }
            return ProductBuilder.parseTimeString(timeString);
        }

        private ProductData.UTC getSceneRasterStopTime() {
            Element child = this.getRootElement().getChild("Production");
            String timeString = child.getChildTextTrim("PRODUCT_SCENE_RASTER_STOP_TIME");
            if (org.esa.snap.core.util.StringUtils.isNullOrEmpty(timeString)) {
                timeString = child.getChildTextTrim("SENSING_STOP");
            }
            return ProductBuilder.parseTimeString(timeString);
        }

        private static ProductData.UTC parseTimeString(String timeString) {
            if (timeString != null && timeString.trim().length() > 0) {
                ProductData.UTC utc = null;
                try {
                    utc = ProductData.UTC.parse(timeString);
                }
                catch (ParseException e) {
                    Debug.trace(e);
                }
                return utc;
            }
            return null;
        }

        private int getSceneRasterWidth() {
            Element child = this.getRootElement().getChild("Raster_Dimensions");
            return Integer.parseInt(child.getChildTextTrim("NCOLS"));
        }

        private int getSceneRasterHeight() {
            Element child = this.getRootElement().getChild("Raster_Dimensions");
            return Integer.parseInt(child.getChildTextTrim("NROWS"));
        }

        private Element getRootElement() {
            return this.getDom().getRootElement();
        }
    }
}

