/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.dimap;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.ImageGeometry;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.maptransf.MapInfo;
import org.esa.snap.core.dataop.maptransf.MapProjection;
import org.esa.snap.core.dataop.maptransf.MapTransform;
import org.esa.snap.core.dataop.maptransf.UTMProjection;
import org.geotools.referencing.wkt.UnformattableObjectException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class EnviHeader {
    public static final String FILE_EXTENSION = ".hdr";
    private static final String _enviHeaderTag = "ENVI";
    private static final String _enviSamplesTag = "samples";
    private static final String _enviLinesTag = "lines";
    private static final String _enviBandsTag = "bands";
    private static final String _enviOffsetTag = "header offset";
    private static final String _enviFileTypeTag = "file type";
    private static final String _enviDataTypeTag = "data type";
    private static final String _enviInterleaveTag = "interleave";
    private static final String _enviByteOrderTag = "byte order";
    private static final String _enviMapInfo = "map info";
    private static final String _enviProjectionInfo = "projection info";
    private static final String _enviCoordinateSystemString = "coordinate system string";
    private static final String _enviStandardType = "ENVI Standard";
    private static final String _enviBSQType = "bsq";
    private static final int _enviTypeByte = 1;
    private static final int _enviTypeShort = 2;
    private static final int _enviTypeUShort = 12;
    private static final int _enviTypeInt = 3;
    private static final int _enviTypeFloat = 4;
    private static final int _enviTypeDouble = 5;
    private static final int _enviMSFOrder = 1;

    public static void createPhysicalFile(File headerFile, RasterDataNode rasterDataNode, int width, int height) throws IOException {
        EnviHeader.createPhysicalFile(headerFile, rasterDataNode, width, height, 1);
    }

    public static void createPhysicalFile(File headerFile, RasterDataNode rasterDataNode, int width, int height, int byteorder) throws IOException {
        FileWriter fileWriter = new FileWriter(headerFile);
        PrintWriter out = new PrintWriter(fileWriter);
        EnviHeader.writeFileMagic(out);
        EnviHeader.writedescription(out, rasterDataNode);
        EnviHeader.writeBandSize(out, width, height);
        EnviHeader.writeNumBands(out);
        EnviHeader.writeHeaderOffset(out);
        EnviHeader.writeFileType(out);
        EnviHeader.writeDataType(out, rasterDataNode.getDataType());
        EnviHeader.writeInterleave(out);
        EnviHeader.writeByteOrder(out, byteorder);
        EnviHeader.writeBandNames(out, rasterDataNode);
        EnviHeader.writeMapProjectionInfo(out, rasterDataNode);
        EnviHeader.writeWavelength(out, rasterDataNode);
        EnviHeader.writeScalingFactor(out, rasterDataNode);
        EnviHeader.writeScalingOffset(out, rasterDataNode);
        out.close();
    }

    private static void writedescription(PrintWriter out, RasterDataNode rasterDataNode) {
        Band band;
        assert (rasterDataNode != null);
        String description = rasterDataNode.getDescription();
        String unit = rasterDataNode.getUnit();
        if (unit == null || unit.trim().length() == 0) {
            unit = "1";
        }
        if (rasterDataNode.isLog10Scaled()) {
            unit = "log(" + unit + ")";
        }
        unit = " - Unit: " + unit;
        String wavelength = "";
        if (rasterDataNode instanceof Band && (double)(band = (Band)rasterDataNode).getSpectralWavelength() != 0.0) {
            wavelength = " - Wavelength: " + band.getSpectralWavelength() + "nm";
        }
        if (description == null || description.trim().length() == 0) {
            description = rasterDataNode.getProduct().getDescription();
        }
        out.println("description = {" + description + unit + wavelength + "}");
    }

    private static void writeFileMagic(PrintWriter out) {
        out.println(_enviHeaderTag);
    }

    private static void writeBandSize(PrintWriter out, int width, int height) {
        out.print(_enviSamplesTag);
        out.print(" = ");
        out.println(width);
        out.print(_enviLinesTag);
        out.print(" = ");
        out.println(height);
    }

    private static void writeNumBands(PrintWriter out) {
        out.print(_enviBandsTag);
        out.print(" = ");
        out.println(1);
    }

    private static void writeBandNames(PrintWriter out, RasterDataNode rasterDataNode) {
        assert (rasterDataNode != null);
        out.println("band names = { " + rasterDataNode.getName() + " }");
    }

    private static void writeHeaderOffset(PrintWriter out) {
        out.print(_enviOffsetTag);
        out.print(" = ");
        out.println(0);
    }

    private static void writeFileType(PrintWriter out) {
        out.print(_enviFileTypeTag);
        out.print(" = ");
        out.println(_enviStandardType);
    }

    private static void writeDataType(PrintWriter out, int dataType) {
        int enviType;
        switch (dataType) {
            case 10: {
                enviType = 1;
                break;
            }
            case 20: {
                enviType = 1;
                break;
            }
            case 11: {
                enviType = 2;
                break;
            }
            case 21: {
                enviType = 12;
                break;
            }
            case 12: {
                enviType = 3;
                break;
            }
            case 22: {
                enviType = 3;
                break;
            }
            case 30: {
                enviType = 4;
                break;
            }
            case 31: {
                enviType = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid data type ID: " + dataType);
            }
        }
        out.print(_enviDataTypeTag);
        out.print(" = ");
        out.println(enviType);
    }

    private static void writeInterleave(PrintWriter out) {
        out.print(_enviInterleaveTag);
        out.print(" = ");
        out.println(_enviBSQType);
    }

    private static void writeByteOrder(PrintWriter out, int order) {
        out.print(_enviByteOrderTag);
        out.print(" = ");
        out.println(order);
    }

    static void writeMapProjectionInfo(PrintWriter out, RasterDataNode rasterDataNode) {
        GeoCoding geoCoding;
        String datumName;
        CoordinateReferenceSystem crs;
        String mapProjectionName = "Arbitrary";
        String mapUnits = "Meters";
        double referencePixelX = 0.0;
        double referencePixelY = 0.0;
        double easting = 0.0;
        double northing = 0.0;
        double pixelSizeX = 0.0;
        double pixelSizeY = 0.0;
        int utmZone = -1;
        String utmHemisphere = "";
        MapProjection mapProjection = null;
        if (rasterDataNode.getGeoCoding() instanceof CrsGeoCoding) {
            CrsGeoCoding crsGeoCoding = (CrsGeoCoding)rasterDataNode.getGeoCoding();
            crs = crsGeoCoding.getMapCRS();
            ImageGeometry imgGeom = ImageGeometry.createTargetGeometry(rasterDataNode, crs, null, null, null, null, null, null, null, null, null);
            String crsName = crs.getName().toString().toUpperCase();
            if (crsName.equals("WGS84(DD)")) {
                mapProjectionName = "Geographic Lat/Lon";
                mapUnits = "Degrees";
            } else if (crsName.contains("UTM")) {
                mapProjectionName = "UTM";
                String zoneStr = crsName.substring(crsName.indexOf("ZONE") + 5, crsName.length()).trim();
                int i = 0;
                StringBuilder zoneNumStr = new StringBuilder();
                while (Character.isDigit(zoneStr.charAt(i))) {
                    zoneNumStr.append(zoneStr.charAt(i++));
                }
                utmZone = Integer.parseInt(zoneNumStr.toString());
                GeoPos centrePos = crsGeoCoding.getGeoPos(new PixelPos(rasterDataNode.getRasterWidth() / 2, rasterDataNode.getRasterHeight() / 2), null);
                utmHemisphere = centrePos.getLat() > 0.0 ? "North" : "South";
            }
            referencePixelX = imgGeom.getReferencePixelX();
            referencePixelY = imgGeom.getReferencePixelY();
            easting = imgGeom.getEasting();
            northing = imgGeom.getNorthing();
            pixelSizeX = imgGeom.getPixelSizeX();
            pixelSizeY = imgGeom.getPixelSizeY();
            datumName = crsGeoCoding.getDatum().getName();
        } else if (rasterDataNode.getGeoCoding() instanceof MapGeoCoding) {
            MapGeoCoding mapGeoCoding = (MapGeoCoding)rasterDataNode.getGeoCoding();
            MapInfo info = mapGeoCoding.getMapInfo();
            if (info == null) {
                return;
            }
            mapProjection = info.getMapProjection();
            if (mapProjection instanceof UTMProjection) {
                mapProjectionName = "UTM";
                UTMProjection utmProjection = (UTMProjection)mapProjection;
                utmZone = utmProjection.getZone();
                utmHemisphere = utmProjection.isNorth() ? "North" : "South";
            } else if (mapProjection.isPreDefined()) {
                mapProjectionName = mapProjection.getName();
            }
            mapUnits = "meter".equals(mapProjection.getMapUnit()) ? "Meters" : ("degree".equals(mapProjection.getMapUnit()) ? "Degrees" : mapProjection.getMapUnit());
            datumName = mapGeoCoding.getDatum().getName();
        } else {
            return;
        }
        out.print(_enviMapInfo);
        out.print(" = {");
        out.print(mapProjectionName);
        out.print(",");
        out.print(referencePixelX + 1.0);
        out.print(",");
        out.print(referencePixelY + 1.0);
        out.print(",");
        out.print(easting);
        out.print(",");
        out.print(northing);
        out.print(",");
        out.print(pixelSizeX);
        out.print(",");
        out.print(pixelSizeY);
        out.print(",");
        if (utmZone != -1) {
            out.print(utmZone);
            out.print(",");
            out.print(utmHemisphere);
            out.print(",");
        }
        out.print(datumName);
        out.print(",");
        out.print("units=" + mapUnits);
        out.print("}");
        out.println();
        if (mapProjection != null && !mapProjection.isPreDefined()) {
            MapTransform mapTransform = mapProjection.getMapTransform();
            double[] parameterValues = mapTransform.getParameterValues();
            String transformName = mapTransform.getDescriptor().getName();
            out.print(_enviProjectionInfo);
            out.print(" = {");
            if (transformName.equals("Transverse Mercator")) {
                out.print(3);
                out.print(",");
                out.print(parameterValues[0]);
                out.print(",");
                out.print(parameterValues[1]);
                out.print(",");
                out.print(parameterValues[2]);
                out.print(",");
                out.print(parameterValues[3]);
                out.print(",");
                out.print(parameterValues[5]);
                out.print(",");
                out.print(parameterValues[6]);
                out.print(",");
                out.print(parameterValues[4]);
                out.print(",");
            } else if (transformName.equals("Lambert Conformal Conic")) {
                out.print(4);
                out.print(",");
                out.print(parameterValues[0]);
                out.print(",");
                out.print(parameterValues[1]);
                out.print(",");
                out.print(parameterValues[2]);
                out.print(",");
                out.print(parameterValues[3]);
                out.print(",");
                out.print(0.0);
                out.print(",");
                out.print(0.0);
                out.print(",");
                out.print(parameterValues[4]);
                out.print(",");
                out.print(parameterValues[5]);
                out.print(",");
            }
            out.print(mapProjectionName);
            out.print(",");
            out.print("units=" + mapUnits);
            out.print("}");
            out.println();
        }
        if ((crs = (geoCoding = rasterDataNode.getGeoCoding()).getMapCRS()) != null) {
            String wkt;
            try {
                wkt = crs.toWKT();
            }
            catch (UnformattableObjectException e) {
                wkt = crs.toString();
            }
            wkt = wkt.replace("\r", "").replace("\n", "");
            wkt = wkt.trim().replaceAll(" +", " ");
            out.print(_enviCoordinateSystemString);
            out.print(" = {");
            out.print(wkt);
            out.print("}");
            out.println();
        }
    }

    private static void writeWavelength(PrintWriter out, RasterDataNode rasterDataNode) {
        Band band;
        float spectralWavelength;
        if (rasterDataNode instanceof Band && (spectralWavelength = (band = (Band)rasterDataNode).getSpectralWavelength()) != 0.0f) {
            out.println("wavelength = {" + spectralWavelength + "}");
        }
    }

    private static void writeScalingFactor(PrintWriter out, RasterDataNode rasterDataNode) {
        out.println("data gain values = {" + rasterDataNode.getScalingFactor() + "}");
    }

    private static void writeScalingOffset(PrintWriter out, RasterDataNode rasterDataNode) {
        out.println("data offset values = {" + rasterDataNode.getScalingOffset() + "}");
    }

    private EnviHeader() {
    }
}

