/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.dimap.spi;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import org.esa.snap.core.dataio.dimap.spi.ConvolutionFilterBandPersistable;
import org.esa.snap.core.dataio.dimap.spi.RasterDataNodePersistable;
import org.esa.snap.core.datamodel.GeneralFilterBand;
import org.esa.snap.core.datamodel.Kernel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.ImageUtils;
import org.esa.snap.core.util.SystemUtils;
import org.jdom.Element;

class GeneralFilterBandPersistable
extends RasterDataNodePersistable {
    static final String VERSION_1_0 = "1.0";
    static final String VERSION_1_1 = "1.1";
    static final String VERSION_1_2 = "1.2";
    static final String ATTRIBUTE_BAND_TYPE = "bandType";
    static final String ATTRIBUTE_VERSION = "version";
    static final String GENERAL_FILTER_BAND_TYPE = "GeneralFilterBand";

    GeneralFilterBandPersistable() {
    }

    @Override
    public Object createObjectFromXml(Element element, Product product, Dimension regionRasterSize) {
        Kernel kernel;
        Element filterBandInfo = element.getChild("Filter_Band_Info");
        GeneralFilterBand.OpType opType = this.parseOpType(filterBandInfo);
        if (opType == null) {
            SystemUtils.LOG.warning(String.format("BEAM-DIMAP problem in element '%s': missing or illegal value for element '%s'", filterBandInfo.getName(), "FILTER_OP_TYPE"));
            return null;
        }
        Element kernelInfo = filterBandInfo.getChild("Filter_Kernel");
        if (kernelInfo != null) {
            kernel = ConvolutionFilterBandPersistable.convertElementToKernel(kernelInfo);
        } else {
            Dimension size = this.parseSize(filterBandInfo);
            if (size.width <= 0 || size.height <= 0) {
                SystemUtils.LOG.warning(String.format("BEAM-DIMAP problem in element '%s': missing or illegal value for element '%s'", filterBandInfo.getName(), "FILTER_SUB_WINDOW_SIZE"));
                return null;
            }
            double[] data = new double[size.width * size.height];
            Arrays.fill(data, 1.0);
            kernel = new Kernel(size.width, size.height, data);
        }
        String sourceName = filterBandInfo.getChildTextTrim("FILTER_SOURCE");
        RasterDataNode sourceNode = product.getRasterDataNode(sourceName);
        String bandName = element.getChildTextTrim("BAND_NAME");
        Dimension filterBandSize = ImageUtils.computeSceneRasterSize(sourceNode.getRasterWidth(), sourceNode.getRasterHeight(), regionRasterSize);
        GeneralFilterBand gfb = new GeneralFilterBand(bandName, sourceNode, filterBandSize, opType, kernel, 1);
        gfb.setDescription(element.getChildTextTrim("BAND_DESCRIPTION"));
        gfb.setUnit(element.getChildTextTrim("PHYSICAL_UNIT"));
        gfb.setSolarFlux(Float.parseFloat(element.getChildTextTrim("SOLAR_FLUX")));
        gfb.setSpectralWavelength(Float.parseFloat(element.getChildTextTrim("BAND_WAVELEN")));
        gfb.setSpectralBandwidth(Float.parseFloat(element.getChildTextTrim("BANDWIDTH")));
        gfb.setScalingFactor(Double.parseDouble(element.getChildTextTrim("SCALING_FACTOR")));
        gfb.setScalingOffset(Double.parseDouble(element.getChildTextTrim("SCALING_OFFSET")));
        gfb.setLog10Scaled(Boolean.parseBoolean(element.getChildTextTrim("LOG10_SCALED")));
        gfb.setNoDataValueUsed(Boolean.parseBoolean(element.getChildTextTrim("NO_DATA_VALUE_USED")));
        gfb.setNoDataValue(Double.parseDouble(element.getChildTextTrim("NO_DATA_VALUE")));
        this.setAncillaryRelations(element, gfb);
        this.setAncillaryVariables(element, gfb, product);
        this.setImageToModelTransform(element, gfb);
        return gfb;
    }

    private Dimension parseSize(Element filterBandInfo) {
        int width = 1;
        int height = 1;
        String sizeText = filterBandInfo.getChildTextTrim("FILTER_SUB_WINDOW_SIZE");
        if (sizeText != null) {
            int size;
            width = size = Integer.parseInt(sizeText);
            height = size;
        } else {
            String heightText;
            String widthText = filterBandInfo.getChildTextTrim("FILTER_SUB_WINDOW_WIDTH");
            if (widthText != null) {
                width = Integer.parseInt(widthText);
            }
            if ((heightText = filterBandInfo.getChildTextTrim("FILTER_SUB_WINDOW_HEIGHT")) != null) {
                height = Integer.parseInt(heightText);
            }
        }
        return new Dimension(width, height);
    }

    private GeneralFilterBand.OpType parseOpType(Element filterBandInfo) {
        GeneralFilterBand.OpType opType = null;
        String filterOpClassName = filterBandInfo.getChildTextTrim("FILTER_OPERATOR_CLASS_NAME");
        if (filterOpClassName != null) {
            int index = filterOpClassName.lastIndexOf(36);
            if (index > 0) {
                filterOpClassName = filterOpClassName.substring(index + 1);
            }
            switch (filterOpClassName) {
                case "Min": {
                    opType = GeneralFilterBand.OpType.MIN;
                    break;
                }
                case "Max": {
                    opType = GeneralFilterBand.OpType.MAX;
                    break;
                }
                case "Mean": {
                    opType = GeneralFilterBand.OpType.MEAN;
                    break;
                }
                case "Median": {
                    opType = GeneralFilterBand.OpType.MEDIAN;
                    break;
                }
                case "StdDev": {
                    opType = GeneralFilterBand.OpType.STDDEV;
                }
            }
        } else {
            String filterOpTypeName = filterBandInfo.getChildTextTrim("FILTER_OP_TYPE");
            if (filterOpTypeName != null) {
                opType = GeneralFilterBand.OpType.valueOf(filterOpTypeName);
            }
        }
        return opType;
    }

    @Override
    public Element createXmlFromObject(Object object) {
        GeneralFilterBand gfb = (GeneralFilterBand)object;
        ArrayList<Element> contentList = new ArrayList<Element>(20);
        contentList.add(GeneralFilterBandPersistable.createElement("BAND_INDEX", String.valueOf(gfb.getProduct().getBandIndex(gfb.getName()))));
        contentList.add(GeneralFilterBandPersistable.createElement("BAND_NAME", gfb.getName()));
        contentList.add(GeneralFilterBandPersistable.createElement("BAND_DESCRIPTION", gfb.getDescription()));
        contentList.add(GeneralFilterBandPersistable.createElement("DATA_TYPE", ProductData.getTypeString(gfb.getDataType())));
        contentList.add(GeneralFilterBandPersistable.createElement("PHYSICAL_UNIT", gfb.getUnit()));
        contentList.add(GeneralFilterBandPersistable.createElement("SOLAR_FLUX", String.valueOf(gfb.getSolarFlux())));
        contentList.add(GeneralFilterBandPersistable.createElement("BAND_WAVELEN", String.valueOf(gfb.getSpectralWavelength())));
        contentList.add(GeneralFilterBandPersistable.createElement("BANDWIDTH", String.valueOf(gfb.getSpectralBandwidth())));
        contentList.add(GeneralFilterBandPersistable.createElement("SCALING_FACTOR", String.valueOf(gfb.getScalingFactor())));
        contentList.add(GeneralFilterBandPersistable.createElement("SCALING_OFFSET", String.valueOf(gfb.getScalingOffset())));
        contentList.add(GeneralFilterBandPersistable.createElement("LOG10_SCALED", String.valueOf(gfb.isLog10Scaled())));
        contentList.add(GeneralFilterBandPersistable.createElement("NO_DATA_VALUE_USED", String.valueOf(gfb.isNoDataValueUsed())));
        contentList.add(GeneralFilterBandPersistable.createElement("NO_DATA_VALUE", String.valueOf(gfb.getNoDataValue())));
        ArrayList<Element> filterBandInfoList = new ArrayList<Element>(5);
        filterBandInfoList.add(GeneralFilterBandPersistable.createElement("FILTER_SOURCE", gfb.getSource().getName()));
        filterBandInfoList.add(GeneralFilterBandPersistable.createElement("FILTER_OP_TYPE", gfb.getOpType().toString()));
        filterBandInfoList.add(ConvolutionFilterBandPersistable.convertKernelToElement(gfb.getStructuringElement()));
        Element filterBandInfo = new Element("Filter_Band_Info");
        filterBandInfo.setAttribute(ATTRIBUTE_BAND_TYPE, GENERAL_FILTER_BAND_TYPE);
        filterBandInfo.setAttribute(ATTRIBUTE_VERSION, VERSION_1_2);
        filterBandInfo.addContent(filterBandInfoList);
        contentList.add(filterBandInfo);
        Element root = new Element("Spectral_Band_Info");
        root.setContent(contentList);
        this.addImageToModelTransformElement(root, gfb);
        this.addAncillaryElements(root, gfb);
        return root;
    }
}

