/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.dimap.spi;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.esa.snap.core.dataio.dimap.spi.DimapPersistable;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.StringUtils;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public abstract class RasterDataNodePersistable
implements DimapPersistable {
    protected void setAncillaryVariables(Element element, final RasterDataNode rasterDataNode, final Product product) {
        List variableElems = element.getChildren("ANCILLARY_VARIABLE");
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Element variableElem : variableElems) {
            variableNames.add(variableElem.getTextTrim());
        }
        for (final String variableName : variableNames) {
            RasterDataNode variable = product.getRasterDataNode(variableName);
            if (variable != null) {
                rasterDataNode.addAncillaryVariable(variable, new String[0]);
                continue;
            }
            product.addProductNodeListener(new ProductNodeListenerAdapter(){

                @Override
                public void nodeAdded(ProductNodeEvent event) {
                    ProductNode sourceNode = event.getSourceNode();
                    String sourceNodeName = sourceNode.getName();
                    if (!variableName.equals(sourceNodeName)) {
                        return;
                    }
                    if (!(sourceNode instanceof RasterDataNode)) {
                        return;
                    }
                    product.removeProductNodeListener(this);
                    rasterDataNode.addAncillaryVariable((RasterDataNode)sourceNode, new String[0]);
                }
            });
        }
    }

    protected void setAncillaryRelations(Element element, RasterDataNode rasterDataNode) {
        List relationElems = element.getChildren("ANCILLARY_RELATION");
        TreeSet<String> relations = new TreeSet<String>();
        for (Element relation : relationElems) {
            relations.add(relation.getTextTrim());
        }
        if (relations.size() > 0) {
            rasterDataNode.setAncillaryRelations(relations.toArray(new String[0]));
        }
    }

    protected void addAncillaryElements(Element root, RasterDataNode rasterDataNode) {
        RasterDataNode[] ancillaryVariables;
        String[] ancillaryRelations;
        for (String ancillaryRelation : ancillaryRelations = rasterDataNode.getAncillaryRelations()) {
            root.addContent((Content)RasterDataNodePersistable.createValueAttributeElement("ANCILLARY_RELATION", ancillaryRelation));
        }
        for (RasterDataNode ancillaryVariable : ancillaryVariables = rasterDataNode.getAncillaryVariables(new String[0])) {
            root.addContent((Content)RasterDataNodePersistable.createValueAttributeElement("ANCILLARY_VARIABLE", ancillaryVariable.getName()));
        }
    }

    protected void setImageToModelTransform(Element element, RasterDataNode rasterDataNode) {
        String matrix = element.getChildTextTrim("IMAGE_TO_MODEL_TRANSFORM");
        if (matrix == null || matrix.length() == 0) {
            Element child = element.getChild("IMAGE_TO_MODEL_TRANSFORM");
            if (child == null) {
                return;
            }
            Attribute attribute = child.getAttribute("value");
            if (attribute == null) {
                return;
            }
            matrix = attribute.getValue().trim();
        }
        if (matrix != null && matrix.length() > 0) {
            AffineTransform transform = new AffineTransform(StringUtils.toDoubleArray(matrix, null));
            rasterDataNode.setImageToModelTransform(transform);
        }
    }

    protected void addImageToModelTransformElement(Element root, RasterDataNode rasterDataNode) {
        AffineTransform imageToModelTransform = rasterDataNode.getImageToModelTransform();
        if (!imageToModelTransform.isIdentity()) {
            double[] matrix = new double[6];
            imageToModelTransform.getMatrix(matrix);
            String csvValue = StringUtils.arrayToCsv(matrix);
            root.addContent((Content)RasterDataNodePersistable.createValueAttributeElement("IMAGE_TO_MODEL_TRANSFORM", csvValue));
        }
    }

    protected static Element createValueAttributeElement(String elementName, String value) {
        Element elem = new Element(elementName);
        if (value != null) {
            elem.setAttribute("value", value);
        } else {
            elem.setAttribute("value", "");
        }
        return elem;
    }

    protected static Element createElement(String elementName, String value) {
        Element elem = new Element(elementName);
        elem.setText(value);
        return elem;
    }
}

