/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding;

import java.io.IOException;
import java.util.stream.IntStream;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.dataio.geocoding.ComponentFactory;
import org.esa.snap.core.dataio.geocoding.ForwardCoding;
import org.esa.snap.core.dataio.geocoding.GeoChecks;
import org.esa.snap.core.dataio.geocoding.GeoRaster;
import org.esa.snap.core.dataio.geocoding.InverseCoding;
import org.esa.snap.core.dataio.geocoding.util.RasterUtils;
import org.esa.snap.core.datamodel.AbstractGeoCoding;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.util.SystemUtils;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class ComponentGeoCoding
extends AbstractGeoCoding {
    public static final String SYSPROP_SNAP_PIXEL_CODING_FRACTION_ACCURACY = "snap.pixelGeoCoding.fractionAccuracy";
    private static final GeoPos INVALID_GEO_POS = new GeoPos(Double.NaN, Double.NaN);
    private static final PixelPos INVALID_PIXEL_POS = new PixelPos(Double.NaN, Double.NaN);
    private final ForwardCoding forwardCoding;
    private final InverseCoding inverseCoding;
    private final GeoRaster geoRaster;
    private final GeoChecks geoChecks;
    private boolean isInitialized;
    private boolean isCrossingAntiMeridian;

    public ComponentGeoCoding(GeoRaster geoRaster, ForwardCoding forwardCoding, InverseCoding inverseCoding) {
        this(geoRaster, forwardCoding, inverseCoding, GeoChecks.NONE, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public ComponentGeoCoding(GeoRaster geoRaster, ForwardCoding forwardCoding, InverseCoding inverseCoding, GeoChecks geoChecks) {
        this(geoRaster, forwardCoding, inverseCoding, geoChecks, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public ComponentGeoCoding(GeoRaster geoRaster, ForwardCoding forwardCoding, InverseCoding inverseCoding, CoordinateReferenceSystem geoCRS) {
        this(geoRaster, forwardCoding, inverseCoding, GeoChecks.NONE, geoCRS);
    }

    public ComponentGeoCoding(GeoRaster geoRaster, ForwardCoding forwardCoding, InverseCoding inverseCoding, GeoChecks geoChecks, CoordinateReferenceSystem geoCRS) {
        super(geoCRS);
        this.forwardCoding = forwardCoding;
        this.inverseCoding = inverseCoding;
        this.geoRaster = geoRaster;
        this.geoChecks = geoChecks;
        this.isInitialized = false;
        this.isCrossingAntiMeridian = false;
    }

    @Override
    public boolean isCrossingMeridianAt180() {
        if (!this.isInitialized) {
            throw new IllegalStateException("Geocoding is not initialized.");
        }
        return this.isCrossingAntiMeridian;
    }

    @Override
    public boolean canGetPixelPos() {
        return this.inverseCoding != null;
    }

    @Override
    public boolean canGetGeoPos() {
        return this.forwardCoding != null;
    }

    @Override
    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        if (this.inverseCoding == null) {
            return INVALID_PIXEL_POS;
        }
        return this.inverseCoding.getPixelPos(geoPos, pixelPos);
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        if (this.forwardCoding == null) {
            return INVALID_GEO_POS;
        }
        return this.forwardCoding.getGeoPos(pixelPos, geoPos);
    }

    @Override
    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        GeoRaster geoRaster;
        this.transferRequiredRasters(srcScene, destScene, subsetDef);
        if (subsetDef == null || subsetDef.isEntireProductSelected()) {
            destScene.setGeoCoding(this.clone());
            return true;
        }
        String lonVariableName = this.geoRaster.getLonVariableName();
        String latVariableName = this.geoRaster.getLatVariableName();
        try {
            geoRaster = this.calculateGeoRaster(destScene, subsetDef, lonVariableName, latVariableName);
        }
        catch (IOException e) {
            SystemUtils.LOG.warning("error loading geolocation data: " + e.getMessage());
            return false;
        }
        ForwardCoding forwardCoding = null;
        if (this.forwardCoding != null) {
            forwardCoding = ComponentFactory.getForward(this.forwardCoding.getKey());
        }
        InverseCoding inverseCoding = null;
        if (this.inverseCoding != null) {
            inverseCoding = ComponentFactory.getInverse(this.inverseCoding.getKey());
        }
        CoordinateReferenceSystem geoCRS = this.getGeoCRS();
        ComponentGeoCoding destGeoCoding = new ComponentGeoCoding(geoRaster, forwardCoding, inverseCoding, this.geoChecks, geoCRS);
        destGeoCoding.initialize();
        destScene.setGeoCoding(destGeoCoding);
        return true;
    }

    GeoRaster cloneGeoRaster(String lonVariableName, String latVariableName) {
        return new GeoRaster(this.geoRaster.getLongitudes(), this.geoRaster.getLatitudes(), lonVariableName, latVariableName, this.geoRaster.getRasterWidth(), this.geoRaster.getRasterHeight(), this.geoRaster.getSceneWidth(), this.geoRaster.getSceneHeight(), this.geoRaster.getRasterResolutionInKm(), this.geoRaster.getOffsetX(), this.geoRaster.getOffsetY(), this.geoRaster.getSubsamplingX(), this.geoRaster.getSubsamplingY());
    }

    void transferRequiredRasters(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        String lonVarName = this.geoRaster.getLonVariableName();
        String latVarName = this.geoRaster.getLatVariableName();
        Product srcProduct = srcScene.getProduct();
        Product destProduct = destScene.getProduct();
        RasterDataNode srcLonRaster = srcProduct.getRasterDataNode(lonVarName);
        if (srcLonRaster instanceof TiePointGrid) {
            TiePointGrid destTpgLat;
            TiePointGrid destTpgLon = destProduct.getTiePointGrid(lonVarName);
            if (destTpgLon == null) {
                TiePointGrid srcTpgLon = srcProduct.getTiePointGrid(lonVarName);
                destTpgLon = TiePointGrid.createSubset(srcTpgLon, subsetDef);
                destProduct.addTiePointGrid(destTpgLon);
            }
            if ((destTpgLat = destProduct.getTiePointGrid(latVarName)) == null) {
                TiePointGrid srcTpgLat = srcProduct.getTiePointGrid(latVarName);
                destTpgLat = TiePointGrid.createSubset(srcTpgLat, subsetDef);
                destProduct.addTiePointGrid(destTpgLat);
            }
        } else {
            Band destLatBand;
            Band destLonBand = destProduct.getBand(lonVarName);
            if (destLonBand == null) {
                Band srcLonBand = srcProduct.getBand(lonVarName);
                destLonBand = GeoCodingFactory.createSubset(srcLonBand, destScene, subsetDef);
                destProduct.addBand(destLonBand);
            }
            if ((destLatBand = destProduct.getBand(latVarName)) == null) {
                Band srcLatBand = srcProduct.getBand(latVarName);
                destLatBand = GeoCodingFactory.createSubset(srcLatBand, destScene, subsetDef);
                destProduct.addBand(destLatBand);
            }
        }
    }

    @Override
    public void dispose() {
        this.isInitialized = false;
        if (this.forwardCoding != null) {
            this.forwardCoding.dispose();
        }
        if (this.inverseCoding != null) {
            this.inverseCoding.dispose();
        }
        if (this.geoRaster != null) {
            this.geoRaster.dispose();
        }
    }

    @Override
    @Deprecated
    public Datum getDatum() {
        throw new NotImplementedException();
    }

    @Override
    public GeoCoding clone() {
        GeoRaster geoRaster = this.cloneGeoRaster(this.geoRaster.getLonVariableName(), this.geoRaster.getLatVariableName());
        ForwardCoding cloneForward = null;
        if (this.forwardCoding != null) {
            cloneForward = this.forwardCoding.clone();
        }
        InverseCoding cloneInverse = null;
        if (this.inverseCoding != null) {
            cloneInverse = this.inverseCoding.clone();
        }
        ComponentGeoCoding clone = new ComponentGeoCoding(geoRaster, cloneForward, cloneInverse, this.geoChecks);
        clone.isInitialized = this.isInitialized;
        return clone;
    }

    @Override
    public boolean canClone() {
        return true;
    }

    public void initialize() {
        PixelPos[] poleLocations = new PixelPos[]{};
        if (this.geoChecks != GeoChecks.NONE) {
            this.isCrossingAntiMeridian = RasterUtils.containsAntiMeridian(this.geoRaster.getLongitudes(), this.geoRaster.getRasterWidth());
            if (this.isCrossingAntiMeridian && this.geoChecks == GeoChecks.POLES) {
                poleLocations = RasterUtils.getPoleLocations(this.geoRaster);
            }
        }
        if (this.forwardCoding != null) {
            this.forwardCoding.initialize(this.geoRaster, this.isCrossingAntiMeridian, poleLocations);
        }
        if (this.inverseCoding != null) {
            this.inverseCoding.initialize(this.geoRaster, this.isCrossingAntiMeridian, poleLocations);
        }
        this.isInitialized = true;
    }

    public GeoChecks getGeoChecks() {
        return this.geoChecks;
    }

    public ForwardCoding getForwardCoding() {
        return this.forwardCoding;
    }

    public InverseCoding getInverseCoding() {
        return this.inverseCoding;
    }

    public GeoRaster getGeoRaster() {
        return this.geoRaster;
    }

    private GeoRaster calculateGeoRaster(Scene destScene, ProductSubsetDef subsetDef, String lonVariableName, String latVariableName) throws IOException {
        double subsamplingY;
        double subsamplingX;
        double offsetY;
        double offsetX;
        double[] latitudes;
        double[] longitudes;
        int gridHeight;
        int gridWidth;
        Product destProduct = destScene.getProduct();
        RasterDataNode lonRaster = destProduct.getRasterDataNode(lonVariableName);
        RasterDataNode latRaster = destProduct.getRasterDataNode(latVariableName);
        if (lonRaster instanceof TiePointGrid) {
            TiePointGrid lonTPG = (TiePointGrid)lonRaster;
            TiePointGrid latTPG = (TiePointGrid)latRaster;
            gridWidth = lonTPG.getGridWidth();
            gridHeight = lonTPG.getGridHeight();
            float[] lons = (float[])lonTPG.getGridData().getElems();
            longitudes = IntStream.range(0, lons.length).mapToDouble(i -> lons[i]).toArray();
            float[] lats = (float[])latTPG.getGridData().getElems();
            latitudes = IntStream.range(0, lats.length).mapToDouble(i -> lats[i]).toArray();
            offsetX = lonTPG.getOffsetX();
            offsetY = lonTPG.getOffsetY();
            subsamplingX = lonTPG.getSubSamplingX();
            subsamplingY = lonTPG.getSubSamplingY();
        } else {
            gridWidth = lonRaster.getRasterWidth();
            gridHeight = lonRaster.getRasterHeight();
            longitudes = RasterUtils.loadGeoData(lonRaster);
            latitudes = RasterUtils.loadGeoData(latRaster);
            offsetX = 0.5;
            offsetY = 0.5;
            subsamplingX = 1.0;
            subsamplingY = 1.0;
        }
        GeoRaster geoRaster = new GeoRaster(longitudes, latitudes, lonVariableName, latVariableName, gridWidth, gridHeight, destScene.getRasterWidth(), destScene.getRasterHeight(), this.geoRaster.getRasterResolutionInKm() * subsamplingY, offsetX, offsetY, subsamplingX, subsamplingY);
        return geoRaster;
    }
}

