/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding;

import java.awt.Dimension;
import java.io.IOException;
import java.util.prefs.Preferences;
import java.util.stream.IntStream;
import org.esa.snap.core.dataio.dimap.spi.DimapPersistable;
import org.esa.snap.core.dataio.geocoding.ComponentFactory;
import org.esa.snap.core.dataio.geocoding.ComponentGeoCoding;
import org.esa.snap.core.dataio.geocoding.ForwardCoding;
import org.esa.snap.core.dataio.geocoding.GeoChecks;
import org.esa.snap.core.dataio.geocoding.GeoRaster;
import org.esa.snap.core.dataio.geocoding.InverseCoding;
import org.esa.snap.core.dataio.geocoding.util.RasterUtils;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Config;
import org.geotools.referencing.CRS;
import org.jdom.Content;
import org.jdom.Element;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ComponentGeoCodingPersistable
implements DimapPersistable {
    public static final String TAG_COMPONENT_GEO_CODING = "ComponentGeoCoding";
    public static final String TAG_FORWARD_CODING_KEY = "ForwardCodingKey";
    public static final String TAG_INVERSE_CODING_KEY = "InverseCodingKey";
    public static final String TAG_GEO_CHECKS = "GeoChecks";
    public static final String TAG_GEO_CRS = "GeoCRS";
    public static final String TAG_LON_VARIABLE_NAME = "LonVariableName";
    public static final String TAG_LAT_VARIABLE_NAME = "LatVariableName";
    public static final String TAG_RASTER_RESOLUTION_KM = "RasterResolutionKm";
    public static final String TAG_OFFSET_X = "OffsetX";
    public static final String TAG_OFFSET_Y = "OffsetY";
    public static final String TAG_SUBSAMPLING_X = "SubsamplingX";
    public static final String TAG_SUBSAMPLING_Y = "SubsamplingY";

    @Override
    public Object createObjectFromXml(Element element, Product product, Dimension regionRasterSize) {
        GeoRaster geoRaster;
        boolean resolutionKmInvalid;
        String gcElemName = element.getName();
        Element codingMain = element.getChild(TAG_COMPONENT_GEO_CODING);
        if (codingMain == null) {
            SystemUtils.LOG.warning("Child element <ComponentGeoCoding> expected in element <" + gcElemName + ">");
            return null;
        }
        String forwardKey = codingMain.getChildTextTrim(TAG_FORWARD_CODING_KEY);
        String inverseKey = codingMain.getChildTextTrim(TAG_INVERSE_CODING_KEY);
        String geoChecksName = codingMain.getChildTextTrim(TAG_GEO_CHECKS);
        String geoCrsWKT = codingMain.getChildTextTrim(TAG_GEO_CRS);
        String lonVarName = codingMain.getChildTextTrim(TAG_LON_VARIABLE_NAME);
        String latVarName = codingMain.getChildTextTrim(TAG_LAT_VARIABLE_NAME);
        String resolutionKmStr = codingMain.getChildTextTrim(TAG_RASTER_RESOLUTION_KM);
        boolean forwardInvalid = forwardKey == null;
        boolean inverseInvalid = inverseKey == null;
        boolean geoChecksInvalid = geoChecksName == null;
        boolean geoCrsWKTInvalid = geoCrsWKT == null;
        boolean lonVarNameInvalid = lonVarName == null;
        boolean latVarNameInvalid = latVarName == null;
        boolean bl = resolutionKmInvalid = resolutionKmStr == null;
        if (forwardInvalid) {
            SystemUtils.LOG.warning("Child element <ForwardCodingKey> expected in element <ComponentGeoCoding>.");
        }
        if (inverseInvalid) {
            SystemUtils.LOG.warning("Child element <InverseCodingKey> expected in element <ComponentGeoCoding>.");
        }
        if (geoChecksInvalid) {
            SystemUtils.LOG.warning("Child element <GeoChecks> expected in element <ComponentGeoCoding>.");
        }
        if (geoCrsWKTInvalid) {
            SystemUtils.LOG.warning("Child element <GeoCRS> expected in element <ComponentGeoCoding>.");
        }
        if (lonVarNameInvalid) {
            SystemUtils.LOG.warning("Child element <LonVariableName> expected in element <ComponentGeoCoding>.");
        }
        if (latVarNameInvalid) {
            SystemUtils.LOG.warning("Child element <LatVariableName> expected in element <ComponentGeoCoding>.");
        }
        if (resolutionKmInvalid) {
            SystemUtils.LOG.warning("Child element <RasterResolutionKm> expected in element <ComponentGeoCoding>.");
        }
        Double resolutionInKm = null;
        try {
            resolutionInKm = Double.parseDouble(resolutionKmStr);
        }
        catch (NumberFormatException e) {
            SystemUtils.LOG.warning(e.getMessage());
            SystemUtils.LOG.warning("The value of tag <RasterResolutionKm> is not a parseable text representation of a double value.");
        }
        boolean invalidValueGeoChecks = false;
        try {
            GeoChecks.valueOf(geoChecksName);
        }
        catch (IllegalArgumentException e) {
            invalidValueGeoChecks = true;
            SystemUtils.LOG.warning(e.getMessage());
            SystemUtils.LOG.warning("The value '" + geoChecksName + "' of tag <" + TAG_GEO_CHECKS + "> is not valid.");
        }
        CoordinateReferenceSystem geoCRS = null;
        try {
            geoCRS = CRS.parseWKT((String)geoCrsWKT);
        }
        catch (FactoryException e) {
            SystemUtils.LOG.warning(e.getMessage());
            SystemUtils.LOG.warning("The WKT value '" + geoCrsWKT + "' of tag <" + TAG_GEO_CRS + "> is not valid.");
        }
        if (forwardInvalid || inverseInvalid || geoChecksInvalid || lonVarNameInvalid || latVarNameInvalid || resolutionKmInvalid || resolutionInKm == null || geoChecksName == null || invalidValueGeoChecks || geoCRS == null) {
            SystemUtils.LOG.warning("Unable to create ComponentGeoCoding.");
            return null;
        }
        RasterDataNode lonRaster = product.getRasterDataNode(lonVarName);
        RasterDataNode latRaster = product.getRasterDataNode(latVarName);
        if (lonRaster == null || latRaster == null) {
            if (lonRaster == null) {
                SystemUtils.LOG.warning("Unable to find expected longitude raster '" + lonVarName + "' in product.");
            }
            if (latRaster == null) {
                SystemUtils.LOG.warning("Unable to find expected latitude raster '" + lonVarName + "' in product.");
            }
            SystemUtils.LOG.warning("Unable to create ComponentGeoCoding.");
            return null;
        }
        if (lonRaster instanceof TiePointGrid) {
            int sceneWidth = product.getSceneRasterWidth();
            int sceneHeight = product.getSceneRasterHeight();
            TiePointGrid lonTPG = (TiePointGrid)lonRaster;
            TiePointGrid latTPG = (TiePointGrid)latRaster;
            int gridWidth = lonTPG.getGridWidth();
            int gridHeight = lonTPG.getGridHeight();
            float[] lons = (float[])lonTPG.getGridData().getElems();
            double[] longitudes = IntStream.range(0, lons.length).mapToDouble(i -> lons[i]).toArray();
            float[] lats = (float[])latTPG.getGridData().getElems();
            double[] latitudes = IntStream.range(0, lats.length).mapToDouble(i -> lats[i]).toArray();
            double offsetX = lonTPG.getOffsetX();
            double offsetY = lonTPG.getOffsetY();
            double subsamplingX = lonTPG.getSubSamplingX();
            double subsamplingY = lonTPG.getSubSamplingY();
            geoRaster = new GeoRaster(longitudes, latitudes, lonVarName, latVarName, gridWidth, gridHeight, sceneWidth, sceneHeight, resolutionInKm, offsetX, offsetY, subsamplingX, subsamplingY);
        } else {
            double[] latitudes;
            double[] longitudes;
            int rasterWidth = lonRaster.getRasterWidth();
            int rasterHeight = lonRaster.getRasterHeight();
            try {
                longitudes = RasterUtils.loadGeoData(lonRaster);
                latitudes = RasterUtils.loadGeoData(latRaster);
            }
            catch (IOException e) {
                SystemUtils.LOG.warning("Unable to create ComponentGeoCoding. Reading geo-data failed.");
                SystemUtils.LOG.severe(e.getMessage());
                return null;
            }
            geoRaster = new GeoRaster(longitudes, latitudes, lonVarName, latVarName, rasterWidth, rasterHeight, resolutionInKm);
        }
        Preferences snapPreferences = Config.instance((String)"snap").preferences();
        boolean isFractionalEnabled = snapPreferences.getBoolean("snap.pixelGeoCoding.fractionAccuracy", false);
        if (isFractionalEnabled && "FWD_PIXEL".equals(forwardKey)) {
            forwardKey = "FWD_PIXEL_INTERPOLATING";
        }
        if (isFractionalEnabled && "INV_PIXEL_QUAD_TREE".equals(inverseKey)) {
            inverseKey = "INV_PIXEL_QUAD_TREE_INTERPOLATING";
        }
        if (isFractionalEnabled && "INV_PIXEL_GEO_INDEX".equals(inverseKey)) {
            inverseKey = "INV_PIXEL_GEO_INDEX_INTERPOLATING";
        }
        ForwardCoding forwardCoding = ComponentFactory.getForward(forwardKey);
        InverseCoding inverseCoding = ComponentFactory.getInverse(inverseKey);
        ComponentGeoCoding geoCoding = new ComponentGeoCoding(geoRaster, forwardCoding, inverseCoding, GeoChecks.valueOf(geoChecksName), geoCRS);
        geoCoding.initialize();
        return geoCoding;
    }

    @Override
    public Element createXmlFromObject(Object object) {
        if (!(object instanceof ComponentGeoCoding)) {
            return null;
        }
        ComponentGeoCoding geoCoding = (ComponentGeoCoding)object;
        String forwardKey = geoCoding.getForwardCoding().getKey();
        String inverseKey = geoCoding.getInverseCoding().getKey();
        GeoChecks geoChecks = geoCoding.getGeoChecks();
        CoordinateReferenceSystem geoCRS = geoCoding.getGeoCRS();
        GeoRaster geoRaster = geoCoding.getGeoRaster();
        String lonVarName = geoRaster.getLonVariableName();
        String latVarName = geoRaster.getLatVariableName();
        double resolutionKm = geoRaster.getRasterResolutionInKm();
        double offsetX = geoRaster.getOffsetX();
        double offsetY = geoRaster.getOffsetY();
        double subsamplingX = geoRaster.getSubsamplingX();
        double subsamplingY = geoRaster.getSubsamplingY();
        Element codingMain = new Element(TAG_COMPONENT_GEO_CODING);
        Element forwardKeyElem = new Element(TAG_FORWARD_CODING_KEY);
        Element inverseKeyElem = new Element(TAG_INVERSE_CODING_KEY);
        Element geoChecksElem = new Element(TAG_GEO_CHECKS);
        Element geoCRSElem = new Element(TAG_GEO_CRS);
        Element lonVarNameElem = new Element(TAG_LON_VARIABLE_NAME);
        Element latVarNameElem = new Element(TAG_LAT_VARIABLE_NAME);
        Element resolutionKmElem = new Element(TAG_RASTER_RESOLUTION_KM);
        Element offsetXElem = new Element(TAG_OFFSET_X);
        Element offsetYElem = new Element(TAG_OFFSET_Y);
        Element subsamplingXElem = new Element(TAG_SUBSAMPLING_X);
        Element subsamplingYElem = new Element(TAG_SUBSAMPLING_Y);
        codingMain.addContent((Content)forwardKeyElem);
        codingMain.addContent((Content)inverseKeyElem);
        codingMain.addContent((Content)geoChecksElem);
        codingMain.addContent((Content)geoCRSElem);
        codingMain.addContent((Content)lonVarNameElem);
        codingMain.addContent((Content)latVarNameElem);
        codingMain.addContent((Content)resolutionKmElem);
        codingMain.addContent((Content)offsetXElem);
        codingMain.addContent((Content)offsetYElem);
        codingMain.addContent((Content)subsamplingXElem);
        codingMain.addContent((Content)subsamplingYElem);
        forwardKeyElem.setText(forwardKey);
        inverseKeyElem.setText(inverseKey);
        geoChecksElem.setText(geoChecks.name());
        geoCRSElem.setText(geoCRS.toWKT());
        lonVarNameElem.setText(lonVarName);
        latVarNameElem.setText(latVarName);
        resolutionKmElem.setText(String.valueOf(resolutionKm));
        offsetXElem.setText(String.valueOf(offsetX));
        offsetYElem.setText(String.valueOf(offsetY));
        subsamplingXElem.setText(String.valueOf(subsamplingX));
        subsamplingYElem.setText(String.valueOf(subsamplingY));
        return codingMain;
    }
}

