/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding.forward;

import org.esa.snap.core.dataio.geocoding.ForwardCoding;
import org.esa.snap.core.dataio.geocoding.GeoRaster;
import org.esa.snap.core.dataio.geocoding.forward.ForwardPlugin;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;

public class PixelForward
implements ForwardCoding {
    public static final String KEY = "FWD_PIXEL";
    private int sceneWidth;
    private int sceneHeight;
    private double[] longitudes;
    private double[] latitudes;

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        if (geoPos == null) {
            geoPos = new GeoPos();
        }
        geoPos.setInvalid();
        if (!pixelPos.isValid()) {
            return geoPos;
        }
        double x = pixelPos.getX();
        double y = pixelPos.getY();
        if (x < 0.0 || x > (double)this.sceneWidth || y < 0.0 || y > (double)this.sceneHeight) {
            return geoPos;
        }
        int xf = (int)Math.floor(x);
        int yf = (int)Math.floor(y);
        if (xf == this.sceneWidth) {
            --xf;
        }
        if (yf == this.sceneHeight) {
            --yf;
        }
        int index = yf * this.sceneWidth + xf;
        geoPos.setLocation(this.latitudes[index], this.longitudes[index]);
        return geoPos;
    }

    @Override
    public void initialize(GeoRaster geoRaster, boolean containsAntiMeridian, PixelPos[] poleLocations) {
        this.sceneWidth = geoRaster.getSceneWidth();
        this.sceneHeight = geoRaster.getSceneHeight();
        this.longitudes = geoRaster.getLongitudes();
        this.latitudes = geoRaster.getLatitudes();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void dispose() {
        this.longitudes = null;
        this.latitudes = null;
    }

    @Override
    public ForwardCoding clone() {
        PixelForward clone = new PixelForward();
        clone.longitudes = this.longitudes;
        clone.latitudes = this.latitudes;
        clone.sceneWidth = this.sceneWidth;
        clone.sceneHeight = this.sceneHeight;
        return clone;
    }

    public static class Plugin
    implements ForwardPlugin {
        @Override
        public ForwardCoding create() {
            return new PixelForward();
        }
    }
}

