/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding.forward;

import org.esa.snap.core.dataio.geocoding.ForwardCoding;
import org.esa.snap.core.dataio.geocoding.GeoRaster;
import org.esa.snap.core.dataio.geocoding.forward.ForwardPlugin;
import org.esa.snap.core.dataio.geocoding.forward.TiePointForward;
import org.esa.snap.core.dataio.geocoding.util.RasterUtils;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.TiePointGrid;

public class TiePointBilinearForward
extends TiePointForward {
    public static final String KEY = "FWD_TIE_POINT_BILINEAR";
    private TiePointGrid lonGrid = null;
    private TiePointGrid latGrid = null;
    private int sceneWidth;
    private int sceneHeight;

    TiePointBilinearForward() {
    }

    @Override
    public void initialize(GeoRaster geoRaster, boolean containsAntiMeridian, PixelPos[] poleLocations) {
        int discontinuity = containsAntiMeridian ? 180 : 0;
        this.lonGrid = new TiePointGrid("lon", geoRaster.getRasterWidth(), geoRaster.getRasterHeight(), geoRaster.getOffsetX(), geoRaster.getOffsetY(), geoRaster.getSubsamplingX(), geoRaster.getSubsamplingY(), RasterUtils.toFloat(geoRaster.getLongitudes()), discontinuity);
        this.latGrid = new TiePointGrid("lat", geoRaster.getRasterWidth(), geoRaster.getRasterHeight(), geoRaster.getOffsetX(), geoRaster.getOffsetY(), geoRaster.getSubsamplingX(), geoRaster.getSubsamplingY(), RasterUtils.toFloat(geoRaster.getLatitudes()));
        this.checkGrids(this.lonGrid, this.latGrid);
        this.sceneWidth = geoRaster.getSceneWidth();
        this.sceneHeight = geoRaster.getSceneHeight();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        if (geoPos == null) {
            geoPos = new GeoPos();
        }
        if (pixelPos.x < 0.0 || pixelPos.x > (double)this.sceneWidth || pixelPos.y < 0.0 || pixelPos.y > (double)this.sceneHeight) {
            geoPos.setInvalid();
        } else {
            geoPos.lat = this.latGrid.getPixelDouble(pixelPos.x, pixelPos.y);
            geoPos.lon = this.lonGrid.getPixelDouble(pixelPos.x, pixelPos.y);
        }
        return geoPos;
    }

    @Override
    public void dispose() {
        this.lonGrid = null;
        this.latGrid = null;
    }

    @Override
    public ForwardCoding clone() {
        TiePointBilinearForward clone = new TiePointBilinearForward();
        clone.lonGrid = this.lonGrid.cloneTiePointGrid();
        clone.latGrid = this.latGrid.cloneTiePointGrid();
        clone.sceneWidth = this.sceneWidth;
        clone.sceneHeight = this.sceneHeight;
        return clone;
    }

    public static class Plugin
    implements ForwardPlugin {
        @Override
        public ForwardCoding create() {
            return new TiePointBilinearForward();
        }
    }
}

