/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding.forward;

import org.esa.snap.core.dataio.geocoding.ForwardCoding;
import org.esa.snap.core.dataio.geocoding.GeoRaster;
import org.esa.snap.core.dataio.geocoding.forward.ForwardPlugin;
import org.esa.snap.core.dataio.geocoding.forward.TiePointForward;
import org.esa.snap.core.dataio.geocoding.util.SplineInterpolator;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;

public class TiePointSplineForward
extends TiePointForward {
    public static final String KEY = "FWD_TIE_POINT_SPLINE";
    private GeoRaster geoRaster;
    private ThreadLocal<InterpolationContext> contextTL;
    private int gridWidth;
    private int gridHeight;
    private boolean containsAntiMeridian;

    @Override
    public void initialize(GeoRaster geoRaster, boolean containsAntiMeridian, PixelPos[] poleLocations) {
        this.checkGeoRaster(geoRaster);
        this.geoRaster = geoRaster;
        this.containsAntiMeridian = containsAntiMeridian;
        this.contextTL = ThreadLocal.withInitial(() -> this.initThreadLocal(containsAntiMeridian));
        this.gridWidth = geoRaster.getRasterWidth();
        this.gridHeight = geoRaster.getRasterHeight();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        if (geoPos == null) {
            geoPos = new GeoPos();
        }
        double x = pixelPos.x - this.geoRaster.getOffsetX();
        double y = pixelPos.y - this.geoRaster.getOffsetY();
        if (x < 0.0 || x > (double)this.geoRaster.getSceneWidth() || y < 0.0 || y > (double)this.geoRaster.getSceneHeight()) {
            geoPos.setInvalid();
        } else {
            int j;
            InterpolationContext ic = this.contextTL.get();
            double fi = x / this.geoRaster.getSubsamplingX();
            double fj = y / this.geoRaster.getSubsamplingY();
            int i = (int)(fi / 2.0) * 2;
            if (i + 2 >= this.gridWidth) {
                i = this.gridWidth - 3;
            }
            if ((j = (int)(fj / 2.0) * 2) + 2 >= this.gridHeight) {
                j = this.gridHeight - 3;
            }
            fi -= (double)i;
            fj -= (double)j;
            if (i != ic.xSpline || j != ic.ySpline) {
                this.copyInterpolationSubset(this.gridWidth, i, j);
                ic.xSpline = i;
                ic.ySpline = j;
            }
            geoPos.lon = ic.lonInterpolator.interpolate(fi, fj);
            geoPos.lat = SplineInterpolator.interpolate2d(ic.latSubset, fi, fj);
        }
        return geoPos;
    }

    @Override
    public void dispose() {
        this.geoRaster = null;
        if (this.contextTL != null) {
            this.contextTL.remove();
            this.contextTL = null;
        }
    }

    @Override
    public ForwardCoding clone() {
        TiePointSplineForward clone = new TiePointSplineForward();
        clone.geoRaster = this.geoRaster;
        clone.containsAntiMeridian = this.containsAntiMeridian;
        clone.gridHeight = this.gridHeight;
        clone.gridWidth = this.gridWidth;
        clone.contextTL = ThreadLocal.withInitial(() -> this.initThreadLocal(this.containsAntiMeridian));
        return clone;
    }

    private InterpolationContext initThreadLocal(boolean containsAntiMeridian) {
        InterpolationContext context = new InterpolationContext();
        context.lonInterpolator = containsAntiMeridian ? new AntiMeridianLonInterpolator() : new StandardLonInterpolator();
        context.latSubset = new double[3][3];
        context.lonSubset = new double[3][3];
        context.xSpline = Integer.MIN_VALUE;
        context.ySpline = Integer.MIN_VALUE;
        return context;
    }

    private void copyInterpolationSubset(int gridWidth, int i, int j) {
        InterpolationContext ic = this.contextTL.get();
        double[] lonTiePoints = this.geoRaster.getLongitudes();
        System.arraycopy(lonTiePoints, j * gridWidth + i, ic.lonSubset[0], 0, 3);
        System.arraycopy(lonTiePoints, (j + 1) * gridWidth + i, ic.lonSubset[1], 0, 3);
        System.arraycopy(lonTiePoints, (j + 2) * gridWidth + i, ic.lonSubset[2], 0, 3);
        ic.lonInterpolator.setData(ic.lonSubset);
        double[] latTiePoints = this.geoRaster.getLatitudes();
        System.arraycopy(latTiePoints, j * gridWidth + i, ic.latSubset[0], 0, 3);
        System.arraycopy(latTiePoints, (j + 1) * gridWidth + i, ic.latSubset[1], 0, 3);
        System.arraycopy(latTiePoints, (j + 2) * gridWidth + i, ic.latSubset[2], 0, 3);
    }

    public static class Plugin
    implements ForwardPlugin {
        @Override
        public ForwardCoding create() {
            return new TiePointSplineForward();
        }
    }

    private static class InterpolationContext {
        double[][] latSubset;
        double[][] lonSubset;
        LonInterpolator lonInterpolator;
        int xSpline;
        int ySpline;

        private InterpolationContext() {
        }
    }

    static class AntiMeridianLonInterpolator
    implements LonInterpolator {
        private static final double OFFSET = 360.0;
        private double[][] longitudes;

        AntiMeridianLonInterpolator() {
        }

        @Override
        public void setData(double[][] longitudes) {
            int l;
            int k;
            this.longitudes = longitudes;
            boolean containsAntiMeridian = false;
            for (k = 0; k < 3; ++k) {
                for (l = 1; l < 3; ++l) {
                    double delta = Math.abs(this.longitudes[k][l] - this.longitudes[k][l - 1]);
                    if (!(delta > 180.0)) continue;
                    containsAntiMeridian = true;
                    break;
                }
                if (containsAntiMeridian) break;
            }
            if (containsAntiMeridian) {
                for (k = 0; k < 3; ++k) {
                    for (l = 0; l < 3; ++l) {
                        if (!(this.longitudes[k][l] < 0.0)) continue;
                        double[] dArray = this.longitudes[k];
                        int n = l;
                        dArray[n] = dArray[n] + 360.0;
                    }
                }
            }
        }

        @Override
        public double interpolate(double fi, double fj) {
            double lon = SplineInterpolator.interpolate2d(this.longitudes, fi, fj);
            return lon > 180.0 ? lon - 360.0 : lon;
        }
    }

    static class StandardLonInterpolator
    implements LonInterpolator {
        private double[][] longitudes;

        StandardLonInterpolator() {
        }

        @Override
        public void setData(double[][] longitudes) {
            this.longitudes = longitudes;
        }

        @Override
        public double interpolate(double fi, double fj) {
            return SplineInterpolator.interpolate2d(this.longitudes, fi, fj);
        }
    }

    private static interface LonInterpolator {
        public void setData(double[][] var1);

        public double interpolate(double var1, double var3);
    }
}

