/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding.inverse;

import java.util.Properties;
import java.util.TreeMap;
import org.esa.snap.core.dataio.geocoding.GeoRaster;
import org.esa.snap.core.dataio.geocoding.InverseCoding;
import org.esa.snap.core.dataio.geocoding.inverse.InversePlugin;
import org.esa.snap.core.dataio.geocoding.inverse.Result;
import org.esa.snap.core.dataio.geocoding.util.InterpolationContext;
import org.esa.snap.core.dataio.geocoding.util.InterpolatorFactory;
import org.esa.snap.core.dataio.geocoding.util.XYInterpolator;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.util.PreferencesPropertyMap;
import org.esa.snap.core.util.math.SphericalDistance;
import org.esa.snap.runtime.Config;

public class PixelGeoIndexInverse
implements InverseCoding {
    public static final String KEY = "INV_PIXEL_GEO_INDEX";
    public static final String KEY_INTERPOLATING = "INV_PIXEL_GEO_INDEX_INTERPOLATING";
    private final boolean fractionalAccuracy;
    private final XYInterpolator interpolator;
    private TreeMap<Long, RasterRegion> regionIndex;
    private GeoRaster geoRaster;
    private double multiplicator;
    private double[] longitudes;
    private double[] latitudes;
    private double epsilon;

    PixelGeoIndexInverse() {
        this(false);
    }

    PixelGeoIndexInverse(boolean fractionalAccuracy) {
        this(fractionalAccuracy, new PreferencesPropertyMap(Config.instance((String)"snap").preferences()).getProperties());
    }

    PixelGeoIndexInverse(boolean fractionalAccuracy, Properties properties) {
        this(fractionalAccuracy, InterpolatorFactory.create(properties));
    }

    PixelGeoIndexInverse(boolean fractionalAccuracy, XYInterpolator interpolator) {
        this.fractionalAccuracy = fractionalAccuracy;
        this.interpolator = interpolator;
    }

    @Override
    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        if (pixelPos == null) {
            pixelPos = new PixelPos();
        }
        pixelPos.setInvalid();
        if (!geoPos.isValid()) {
            return pixelPos;
        }
        long index = this.toIndex(geoPos.lon, geoPos.lat);
        RasterRegion rasterRegion = this.regionIndex.get(index);
        if (rasterRegion == null) {
            return pixelPos;
        }
        if (rasterRegion.isPoint()) {
            this.getSingleResultPixel(pixelPos, rasterRegion);
        } else {
            this.getMinimumDistancePixel(pixelPos, geoPos, rasterRegion);
        }
        SphericalDistance sphericalDistance = new SphericalDistance(geoPos.lon, geoPos.lat);
        int location = (int)pixelPos.y * this.geoRaster.getSceneWidth() + (int)pixelPos.x;
        double distance = sphericalDistance.distance(this.longitudes[location], this.latitudes[location]) * 6370997.0;
        if (distance < this.epsilon) {
            if (this.fractionalAccuracy) {
                InterpolationContext context = InterpolationContext.extract((int)pixelPos.x, (int)pixelPos.y, this.longitudes, this.latitudes, this.geoRaster.getSceneWidth(), this.geoRaster.getSceneHeight());
                PixelPos interpolated = this.interpolator.interpolate(geoPos, pixelPos, context);
                pixelPos.setLocation(interpolated.x, interpolated.y);
            }
            pixelPos.x += this.geoRaster.getOffsetX();
            pixelPos.y += this.geoRaster.getOffsetY();
        } else {
            pixelPos.setInvalid();
        }
        return pixelPos;
    }

    @Override
    public void initialize(GeoRaster geoRaster, boolean containsAntiMeridian, PixelPos[] poleLocations) {
        this.geoRaster = geoRaster;
        this.regionIndex = new TreeMap();
        this.multiplicator = PixelGeoIndexInverse.getMultiplicator(geoRaster.getRasterResolutionInKm());
        this.longitudes = geoRaster.getLongitudes();
        this.latitudes = geoRaster.getLatitudes();
        int width = geoRaster.getSceneWidth();
        for (int y = 0; y < geoRaster.getSceneHeight(); ++y) {
            int y_offset = y * width;
            for (int x = 0; x < width; ++x) {
                double lon = this.longitudes[y_offset + x];
                double lat = this.latitudes[y_offset + x];
                if (Double.isNaN(lon) || Double.isNaN(lat)) continue;
                long index = this.toIndex(lon, lat);
                RasterRegion rasterRegion = this.regionIndex.get(index);
                if (rasterRegion == null) {
                    this.regionIndex.put(index, new RasterRegion(x, y));
                    continue;
                }
                rasterRegion.extend(x, y);
            }
        }
        this.epsilon = geoRaster.getRasterResolutionInKm() * 1000.0 / Math.sqrt(2.0);
    }

    @Override
    public String getKey() {
        if (this.fractionalAccuracy) {
            return KEY_INTERPOLATING;
        }
        return KEY;
    }

    @Override
    public void dispose() {
        if (this.regionIndex != null) {
            this.regionIndex.clear();
            this.regionIndex = null;
        }
        this.geoRaster = null;
    }

    @Override
    public InverseCoding clone() {
        PixelGeoIndexInverse clone = new PixelGeoIndexInverse(this.fractionalAccuracy, this.interpolator);
        clone.regionIndex = (TreeMap)this.regionIndex.clone();
        clone.multiplicator = this.multiplicator;
        clone.geoRaster = this.geoRaster;
        clone.longitudes = this.longitudes;
        clone.latitudes = this.latitudes;
        clone.epsilon = this.epsilon;
        return clone;
    }

    long toIndex(double lon, double lat) {
        int lon_idx = (int)Math.floor((lon + 180.0) * this.multiplicator);
        int lat_idx = (int)Math.floor((lat + 90.0) * this.multiplicator);
        return 100000L * (long)lon_idx + (long)lat_idx;
    }

    static double getMultiplicator(double resolutionInKm) {
        if (resolutionInKm > 33.3) {
            return 1.0;
        }
        if (resolutionInKm <= 0.333) {
            return 100.0;
        }
        return 100.0 / (3.0 * resolutionInKm);
    }

    private void getSingleResultPixel(PixelPos pixelPos, RasterRegion rasterRegion) {
        pixelPos.x = rasterRegion.min_x;
        pixelPos.y = rasterRegion.min_y;
    }

    private void getMinimumDistancePixel(PixelPos pixelPos, GeoPos geoPos, RasterRegion rasterRegion) {
        Result result = new Result();
        for (int y = rasterRegion.min_y; y <= rasterRegion.max_y; ++y) {
            int offset = y * this.geoRaster.getSceneWidth();
            for (int x = rasterRegion.min_x; x <= rasterRegion.max_x; ++x) {
                double lon = this.longitudes[offset + x];
                double lat = this.latitudes[offset + x];
                double dLon = lon - geoPos.lon;
                double dLat = lat - geoPos.lat;
                double squareDistance = dLon * dLon + dLat * dLat;
                result.update(x, y, squareDistance);
            }
        }
        pixelPos.x = result.x;
        pixelPos.y = result.y;
    }

    public static class Plugin
    implements InversePlugin {
        private final boolean fractionalAccuracy;

        public Plugin(boolean fractionalAccuracy) {
            this.fractionalAccuracy = fractionalAccuracy;
        }

        @Override
        public InverseCoding create() {
            return new PixelGeoIndexInverse(this.fractionalAccuracy);
        }
    }

    static class RasterRegion {
        int min_x;
        int max_x;
        int min_y;
        int max_y;

        RasterRegion(int x, int y) {
            this.min_x = x;
            this.max_x = x;
            this.min_y = y;
            this.max_y = y;
        }

        void extend(int x, int y) {
            if (x < this.min_x) {
                this.min_x = x;
            }
            if (x > this.max_x) {
                this.max_x = x;
            }
            if (y < this.min_y) {
                this.min_y = y;
            }
            if (y > this.max_y) {
                this.max_y = y;
            }
        }

        boolean isPoint() {
            return this.min_x == this.max_x && this.min_y == this.max_y;
        }
    }
}

