/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding.inverse;

import java.util.ArrayList;
import java.util.Properties;
import org.esa.snap.core.dataio.geocoding.GeoRaster;
import org.esa.snap.core.dataio.geocoding.InverseCoding;
import org.esa.snap.core.dataio.geocoding.inverse.GeoPosCalculator;
import org.esa.snap.core.dataio.geocoding.inverse.InversePlugin;
import org.esa.snap.core.dataio.geocoding.inverse.Result;
import org.esa.snap.core.dataio.geocoding.inverse.Segment;
import org.esa.snap.core.dataio.geocoding.inverse.SegmentCoverage;
import org.esa.snap.core.dataio.geocoding.util.InterpolationContext;
import org.esa.snap.core.dataio.geocoding.util.InterpolatorFactory;
import org.esa.snap.core.dataio.geocoding.util.XYInterpolator;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.util.PreferencesPropertyMap;
import org.esa.snap.core.util.math.Range;
import org.esa.snap.runtime.Config;

public class PixelQuadTreeInverse
implements InverseCoding,
GeoPosCalculator {
    public static final String KEY = "INV_PIXEL_QUAD_TREE";
    public static final String KEY_INTERPOLATING = "INV_PIXEL_QUAD_TREE_INTERPOLATING";
    private static final double TO_DEG = 57.29577951308232;
    private static final double ANGLE_THRESHOLD = 270.0;
    private final boolean fractionalAccuracy;
    private final XYInterpolator interpolator;
    private int rasterWidth;
    private int rasterHeight;
    private double epsilon;
    private double[] epsilonLon;
    private double offsetX;
    private double offsetY;
    private boolean isCrossingMeridian;
    private double[] longitudes;
    private double[] latitudes;
    private Range lonRange;
    private Range latRange;
    private ArrayList<Segment> segmentList;

    PixelQuadTreeInverse() {
        this(false);
    }

    PixelQuadTreeInverse(boolean fractionalAccuracy) {
        this(fractionalAccuracy, new PreferencesPropertyMap(Config.instance((String)"snap").preferences()).getProperties());
    }

    PixelQuadTreeInverse(boolean fractionalAccuracy, Properties properties) {
        this(fractionalAccuracy, InterpolatorFactory.create(properties));
    }

    private PixelQuadTreeInverse(boolean fractionalAccuracy, XYInterpolator interpolator) {
        this.fractionalAccuracy = fractionalAccuracy;
        this.interpolator = interpolator;
        this.segmentList = new ArrayList();
    }

    static double getPositiveLonMin(double[] longitudes) {
        double lonMin = Double.MAX_VALUE;
        for (double lon : longitudes) {
            if (!(lon >= 0.0) || !(lon < lonMin)) continue;
            lonMin = lon;
        }
        return lonMin;
    }

    static double getNegativeLonMax(double[] longitudes) {
        double lonMax = -1.7976931348623157E308;
        for (double lon : longitudes) {
            if (!(lon < 0.0) || !(lon > lonMax)) continue;
            lonMax = lon;
        }
        return lonMax;
    }

    static boolean isCrossingAntiMeridianInsideQuad(double[] longitudes) {
        double delta;
        int numLons = longitudes.length;
        double maxDelta = -1.0;
        for (int i = 1; i < numLons; ++i) {
            delta = Math.abs(longitudes[i] - longitudes[i - 1]);
            if (!(delta > maxDelta)) continue;
            maxDelta = delta;
        }
        delta = Math.abs(longitudes[numLons - 1] - longitudes[0]);
        if (delta > maxDelta) {
            maxDelta = delta;
        }
        return maxDelta > 270.0;
    }

    static double sq(double dx, double dy) {
        return dx * dx + dy * dy;
    }

    static double[] createEpsilonLongitude(double epsilon) {
        double[] d = new double[901];
        for (int i = 0; i < d.length; ++i) {
            double ang = (double)i * 0.1;
            double rad = Math.toRadians(ang);
            double multiplier = 1.0 / Math.cos(rad);
            d[i] = epsilon * multiplier;
        }
        return d;
    }

    static Segment getPoleSegment(PixelPos[] poleLocations, int rasterWidth, int rasterHeight) {
        int x_min = Integer.MAX_VALUE;
        int x_max = Integer.MIN_VALUE;
        int y_min = Integer.MAX_VALUE;
        int y_max = Integer.MIN_VALUE;
        for (PixelPos location : poleLocations) {
            if (location.x > (double)x_max) {
                x_max = (int)location.x;
            }
            if (location.x < (double)x_min) {
                x_min = (int)location.x;
            }
            if (location.y > (double)y_max) {
                y_max = (int)location.y;
            }
            if (!(location.y < (double)y_min)) continue;
            y_min = (int)location.y;
        }
        int minDimHalf = 2;
        if ((x_min -= minDimHalf) <= 4) {
            x_min = 0;
        }
        if ((x_max += minDimHalf) > rasterWidth - 1 - 4) {
            x_max = rasterWidth - 1;
        }
        if ((y_min -= minDimHalf) < 4) {
            y_min = 0;
        }
        if ((y_max += minDimHalf) > rasterHeight - 1 - 4) {
            y_max = rasterHeight - 1;
        }
        return new Segment(x_min, x_max, y_min, y_max);
    }

    static Segment[] removeSegment(Segment toRemove, Segment origin, int rasterWidth, int rasterHeight) {
        Segment remaining;
        Segment[] splits;
        ArrayList<Segment> segmentList = new ArrayList<Segment>();
        if (toRemove.y_min > 0) {
            splits = origin.split_y(toRemove.y_min);
            segmentList.add(splits[0]);
            remaining = splits[1];
        } else {
            remaining = origin;
        }
        if (toRemove.y_max < rasterHeight - 1) {
            splits = remaining.split_y(toRemove.y_max + 1);
            remaining = splits[0];
            segmentList.add(splits[1]);
        }
        if (toRemove.x_min > 0) {
            splits = remaining.split_x(toRemove.x_min);
            segmentList.add(splits[0]);
            remaining = splits[1];
        }
        if (toRemove.x_max < rasterWidth - 1) {
            splits = remaining.split_x(toRemove.x_max + 1);
            segmentList.add(splits[1]);
        }
        return segmentList.toArray(new Segment[0]);
    }

    static double getMin(double[] values, double epsilon) {
        double min = Double.MAX_VALUE;
        for (double value : values) {
            if (!(value < min)) continue;
            min = value;
        }
        return min - epsilon;
    }

    static double getMax(double[] values, double epsilon) {
        double max = -1.7976931348623157E308;
        for (double value : values) {
            if (!(value > max)) continue;
            max = value;
        }
        return max + epsilon;
    }

    ArrayList<Segment> getSegmentList() {
        return this.segmentList;
    }

    private ArrayList<Segment> calculateSegmentation(int rasterWidth, int rasterHeight, PixelPos[] poleLocations) {
        ArrayList<Segment> segmentList = new ArrayList<Segment>();
        Segment fullProductSegment = new Segment(0, rasterWidth - 1, 0, rasterHeight - 1);
        if (poleLocations.length == 0) {
            this.calculateSegmentation(fullProductSegment, segmentList);
        } else {
            Segment[] segments;
            Segment poleSegment = PixelQuadTreeInverse.getPoleSegment(poleLocations, rasterWidth, rasterHeight);
            for (Segment segment : segments = PixelQuadTreeInverse.removeSegment(poleSegment, fullProductSegment, rasterWidth, rasterHeight)) {
                this.calculateSegmentation(segment, segmentList);
            }
        }
        return segmentList;
    }

    private void calculateSegmentation(Segment segment, ArrayList<Segment> segmentList) {
        segment.calculateGeoPoints(this);
        SegmentCoverage segmentCoverage = this.hasGeoCoverage(segment);
        if (segmentCoverage == SegmentCoverage.INSIDE) {
            segmentList.add(segment);
        } else {
            Segment[] splits = new Segment[]{};
            if (segment.containsAntiMeridian) {
                splits = PixelQuadTreeInverse.splitAtAntiMeridian(segment, segmentCoverage, this);
            }
            if (splits.length == 0) {
                splits = PixelQuadTreeInverse.splitAtOutsidePoint(segment, segmentCoverage, this);
            }
            if (splits.length == 0) {
                segmentList.add(segment);
            } else if (splits.length == 1) {
                segmentList.add(splits[0]);
            } else {
                this.calculateSegmentation(splits[0], segmentList);
                this.calculateSegmentation(splits[1], segmentList);
            }
        }
    }

    static Segment[] splitAtOutsidePoint(Segment segment, SegmentCoverage segmentCoverage, GeoPosCalculator calculator) {
        GeoPos geoPos = new GeoPos();
        if (segmentCoverage == SegmentCoverage.ACROSS) {
            int delta_r;
            int y_l = -1;
            for (int y = segment.y_min + 1; y < segment.y_max; ++y) {
                calculator.getGeoPos(segment.x_min, y, geoPos);
                if (segment.isInside(geoPos.lon, geoPos.lat)) continue;
                y_l = y;
                break;
            }
            int y_r = -1;
            for (int y = segment.y_min + 1; y < segment.y_max; ++y) {
                calculator.getGeoPos(segment.x_max, y, geoPos);
                if (segment.isInside(geoPos.lon, geoPos.lat)) continue;
                y_r = y;
                break;
            }
            if (y_l - segment.y_min < 4 && y_r - segment.y_min < 4) {
                return segment.split(true);
            }
            int center = segment.y_min + segment.getHeight() / 2;
            int delta_l = Math.abs(center - y_l);
            if (delta_l < (delta_r = Math.abs(center - y_r))) {
                return segment.split_y(y_l);
            }
            return segment.split_y(y_r);
        }
        if (segmentCoverage == SegmentCoverage.ALONG) {
            int delta_b;
            int x_t = -1;
            for (int x = segment.x_min + 1; x < segment.x_max; ++x) {
                calculator.getGeoPos(x, segment.y_min, geoPos);
                if (segment.isInside(geoPos.lon, geoPos.lat)) continue;
                x_t = x;
                break;
            }
            int x_b = -1;
            for (int x = segment.x_min + 1; x < segment.x_max; ++x) {
                calculator.getGeoPos(x, segment.y_max, geoPos);
                if (segment.isInside(geoPos.lon, geoPos.lat)) continue;
                x_b = x;
                break;
            }
            if (x_t - segment.x_min < 4 && x_b - segment.x_min < 4) {
                return segment.split(false);
            }
            int center = segment.x_min + segment.getWidth() / 2;
            int delta_t = Math.abs(center - x_t);
            if (delta_t < (delta_b = Math.abs(center - x_b))) {
                return segment.split_x(x_t);
            }
            return segment.split_x(x_b);
        }
        throw new IllegalStateException("should not come here");
    }

    static Segment[] splitAtAntiMeridian(Segment segment, SegmentCoverage segmentCoverage, GeoPosCalculator calculator) {
        GeoPos geoPos = new GeoPos();
        if (segmentCoverage == SegmentCoverage.ACROSS) {
            int delta_r;
            calculator.getGeoPos(segment.x_min, segment.y_min, geoPos);
            double lon_l = geoPos.lon;
            calculator.getGeoPos(segment.x_max, segment.y_min, geoPos);
            double lon_r = geoPos.lon;
            int y_l = Integer.MIN_VALUE;
            int y_r = Integer.MIN_VALUE;
            for (int y = segment.y_min + 1; y <= segment.y_max; ++y) {
                calculator.getGeoPos(segment.x_min, y, geoPos);
                double delta = Math.abs(lon_l - geoPos.lon);
                if (delta > 270.0) {
                    y_l = y;
                }
                lon_l = geoPos.lon;
                calculator.getGeoPos(segment.x_max, y, geoPos);
                delta = Math.abs(lon_r - geoPos.lon);
                if (delta > 270.0) {
                    y_r = y;
                }
                lon_r = geoPos.lon;
            }
            if (y_l < 4 && y_r < 4) {
                return new Segment[0];
            }
            int center = segment.y_min + segment.getHeight() / 2;
            int delta_l = Math.abs(center - y_l);
            if (delta_l < (delta_r = Math.abs(center - y_r))) {
                return segment.split_y(y_l);
            }
            return segment.split_y(y_r);
        }
        if (segmentCoverage == SegmentCoverage.ALONG) {
            int delta_b;
            calculator.getGeoPos(segment.x_min, segment.y_min, geoPos);
            double lon_t = geoPos.lon;
            calculator.getGeoPos(segment.x_min, segment.y_max, geoPos);
            double lon_b = geoPos.lon;
            int x_t = Integer.MIN_VALUE;
            int x_b = Integer.MIN_VALUE;
            for (int x = segment.x_min + 1; x <= segment.x_max; ++x) {
                calculator.getGeoPos(x, segment.y_min, geoPos);
                double delta = Math.abs(lon_t - geoPos.lon);
                if (delta > 270.0) {
                    x_t = x;
                }
                lon_t = geoPos.lon;
                calculator.getGeoPos(x, segment.y_max, geoPos);
                delta = Math.abs(lon_b - geoPos.lon);
                if (delta > 270.0) {
                    x_b = x;
                }
                lon_b = geoPos.lon;
            }
            if (x_t < 4 && x_b < 4) {
                return new Segment[0];
            }
            int center = segment.x_min + segment.getWidth() / 2;
            int delta_t = Math.abs(center - x_t);
            if (delta_t < (delta_b = Math.abs(center - x_b))) {
                return segment.split_x(x_t);
            }
            return segment.split_x(x_b);
        }
        throw new IllegalStateException("not implemented");
    }

    private SegmentCoverage hasGeoCoverage(Segment segment) {
        GeoPos geoPos = new GeoPos();
        int xOffset = segment.getWidth() / 2;
        int yOffset = segment.getHeight() / 2;
        this.getGeoPos(segment.x_min + xOffset, segment.y_min, geoPos);
        boolean b1 = segment.isInside(geoPos.lon, geoPos.lat);
        this.getGeoPos(segment.x_max, segment.y_min + yOffset, geoPos);
        boolean b2 = segment.isInside(geoPos.lon, geoPos.lat);
        this.getGeoPos(segment.x_min + xOffset, segment.y_max, geoPos);
        boolean b3 = segment.isInside(geoPos.lon, geoPos.lat);
        this.getGeoPos(segment.x_min, segment.y_min + yOffset, geoPos);
        boolean b4 = segment.isInside(geoPos.lon, geoPos.lat);
        if (!b2 || !b4) {
            return SegmentCoverage.ACROSS;
        }
        if (!b1 || !b3) {
            return SegmentCoverage.ALONG;
        }
        return SegmentCoverage.INSIDE;
    }

    @Override
    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        if (pixelPos == null) {
            pixelPos = new PixelPos();
        }
        pixelPos.setInvalid();
        ArrayList<Result> results = new ArrayList<Result>();
        for (Segment segment : this.segmentList) {
            Result result;
            boolean found;
            if (!segment.isInside(geoPos.lon, geoPos.lat) || !(found = this.segmentSearch(geoPos.lon, geoPos.lat, segment, result = new Result()))) continue;
            results.add(result);
        }
        if (results.size() > 0) {
            Result minDeltaResult = null;
            double minDelta = Double.MAX_VALUE;
            for (Result result : results) {
                double absLatDist;
                GeoPos resultGeoPos = new GeoPos();
                this.getGeoPos(result.x, result.y, resultGeoPos);
                double absLonDist = Math.abs(resultGeoPos.lon - geoPos.lon);
                double delta = absLonDist * absLonDist + (absLatDist = Math.abs(resultGeoPos.lat - geoPos.lat)) * absLatDist;
                if (!(delta < minDelta)) continue;
                minDelta = delta;
                minDeltaResult = result;
            }
            if (minDelta < this.epsilon && minDeltaResult != null) {
                if (this.fractionalAccuracy) {
                    InterpolationContext context = InterpolationContext.extract(minDeltaResult.x, minDeltaResult.y, this.longitudes, this.latitudes, this.rasterWidth, this.rasterHeight);
                    PixelPos interpolated = this.interpolator.interpolate(geoPos, pixelPos, context);
                    pixelPos.setLocation(interpolated.x + this.offsetX, interpolated.y + this.offsetY);
                } else {
                    pixelPos.setLocation((double)minDeltaResult.x + this.offsetX, (double)minDeltaResult.y + this.offsetY);
                }
            }
        }
        return pixelPos;
    }

    @Override
    public void initialize(GeoRaster geoRaster, boolean containsAntiMeridian, PixelPos[] poleLocations) {
        this.rasterWidth = geoRaster.getSceneWidth();
        this.rasterHeight = geoRaster.getSceneHeight();
        this.longitudes = geoRaster.getLongitudes();
        this.latitudes = geoRaster.getLatitudes();
        this.epsilon = this.getEpsilon(geoRaster.getRasterResolutionInKm());
        this.epsilonLon = PixelQuadTreeInverse.createEpsilonLongitude(this.epsilon);
        this.isCrossingMeridian = containsAntiMeridian;
        this.offsetX = geoRaster.getOffsetX();
        this.offsetY = geoRaster.getOffsetY();
        this.lonRange = Range.computeRangeDouble(this.longitudes, null);
        this.latRange = Range.computeRangeDouble(this.latitudes, null);
        this.segmentList = this.calculateSegmentation(this.rasterWidth, this.rasterHeight, poleLocations);
    }

    @Override
    public String getKey() {
        if (this.fractionalAccuracy) {
            return KEY_INTERPOLATING;
        }
        return KEY;
    }

    @Override
    public void dispose() {
        this.longitudes = null;
        this.latitudes = null;
        this.segmentList.clear();
    }

    @Override
    public InverseCoding clone() {
        PixelQuadTreeInverse clone = new PixelQuadTreeInverse(this.fractionalAccuracy, this.interpolator);
        clone.rasterWidth = this.rasterWidth;
        clone.rasterHeight = this.rasterHeight;
        clone.longitudes = this.longitudes;
        clone.latitudes = this.latitudes;
        clone.lonRange = new Range(this.lonRange.getMin(), this.lonRange.getMax());
        clone.latRange = new Range(this.latRange.getMin(), this.latRange.getMax());
        clone.epsilon = this.epsilon;
        clone.epsilonLon = this.epsilonLon;
        clone.isCrossingMeridian = this.isCrossingMeridian;
        clone.offsetX = this.offsetX;
        clone.offsetY = this.offsetY;
        for (Segment segment : this.segmentList) {
            clone.segmentList.add(segment.clone());
        }
        return clone;
    }

    @Override
    public void getGeoPos(int pixelX, int pixelY, GeoPos geoPos) {
        int index = pixelY * this.rasterWidth + pixelX;
        geoPos.setLocation(this.latitudes[index], this.longitudes[index]);
    }

    double getEpsilon(double resolutionInKm) {
        double angle = 2.0 * Math.asin(resolutionInKm * 1000.0 / 1.2741994E7);
        return 57.29577951308232 * angle * 2.0;
    }

    private boolean segmentSearch(double lon, double lat, Segment segment, Result result) {
        return this.quadTreeSearch(0, lat, lon, segment.x_min, segment.y_min, segment.getWidth(), segment.getHeight(), result);
    }

    private boolean quadTreeSearch(int depth, double lat, double lon, int x, int y, int w, int h, Result result) {
        double[] latArray;
        double[] lonArray;
        boolean closeToPole;
        if (w < 2 || h < 2) {
            return false;
        }
        int x_1 = x;
        int x_2 = x_1 + w - 1;
        int y_1 = y;
        int y_2 = y_1 + h - 1;
        boolean bl = closeToPole = Math.abs(lon) > 70.0;
        if (closeToPole) {
            lonArray = new double[8];
            latArray = new double[8];
        } else {
            lonArray = new double[4];
            latArray = new double[4];
        }
        GeoPos geoPos = new GeoPos();
        this.getGeoPos(x_1, y_1, geoPos);
        lonArray[0] = geoPos.lon;
        latArray[0] = geoPos.lat;
        this.getGeoPos(x_1, y_2, geoPos);
        lonArray[1] = geoPos.lon;
        latArray[1] = geoPos.lat;
        this.getGeoPos(x_2, y_1, geoPos);
        lonArray[2] = geoPos.lon;
        latArray[2] = geoPos.lat;
        this.getGeoPos(x_2, y_2, geoPos);
        lonArray[3] = geoPos.lon;
        latArray[3] = geoPos.lat;
        if (closeToPole) {
            int xOffset = w / 2;
            int yOffset = h / 2;
            this.getGeoPos(x_1 + xOffset, y_1, geoPos);
            lonArray[4] = geoPos.lon;
            latArray[4] = geoPos.lat;
            this.getGeoPos(x_2, y_1 + yOffset, geoPos);
            lonArray[5] = geoPos.lon;
            latArray[5] = geoPos.lat;
            this.getGeoPos(x_1 + xOffset, y_2, geoPos);
            lonArray[6] = geoPos.lon;
            latArray[6] = geoPos.lat;
            this.getGeoPos(x_1, y_1 + yOffset, geoPos);
            lonArray[7] = geoPos.lon;
            latArray[7] = geoPos.lat;
        }
        double latMin = PixelQuadTreeInverse.getMin(latArray, this.epsilon);
        double latMax = PixelQuadTreeInverse.getMax(latArray, this.epsilon);
        if (lat < latMin || lat > latMax) {
            return false;
        }
        int idx = (int)Math.floor((Math.abs(latMin) + Math.abs(latMax)) / 2.0 * 10.0);
        double epsLon = this.epsilonLon[idx];
        if (this.isCrossingMeridian && PixelQuadTreeInverse.isCrossingAntiMeridianInsideQuad(lonArray)) {
            boolean lonOutside = false;
            if (lon > 0.0) {
                double lonMin = PixelQuadTreeInverse.getPositiveLonMin(lonArray);
                if (lon + epsLon < lonMin) {
                    lonOutside = true;
                }
            } else {
                double lonMax = PixelQuadTreeInverse.getNegativeLonMax(lonArray);
                if (lon - epsLon > lonMax) {
                    lonOutside = true;
                }
            }
            if (lonOutside) {
                return false;
            }
        } else {
            double lonMin = PixelQuadTreeInverse.getMin(lonArray, epsLon);
            double lonMax = PixelQuadTreeInverse.getMax(lonArray, epsLon);
            if (lon < lonMin || lon > lonMax) {
                return false;
            }
        }
        boolean pixelFound = false;
        if (w == 2 && h == 2) {
            double f = Math.cos(lat * (Math.PI / 180));
            if (result.update(x_1, y_1, PixelQuadTreeInverse.sq(lat - latArray[0], f * (lon - lonArray[0])))) {
                pixelFound = true;
            }
            if (result.update(x_1, y_2, PixelQuadTreeInverse.sq(lat - latArray[1], f * (lon - lonArray[1])))) {
                pixelFound = true;
            }
            if (result.update(x_2, y_1, PixelQuadTreeInverse.sq(lat - latArray[2], f * (lon - lonArray[2])))) {
                pixelFound = true;
            }
            if (result.update(x_2, y_2, PixelQuadTreeInverse.sq(lat - latArray[3], f * (lon - lonArray[3])))) {
                pixelFound = true;
            }
        } else {
            pixelFound = this.quadTreeRecursion(depth, lat, lon, x_1, y_1, w, h, result);
        }
        return pixelFound;
    }

    private boolean quadTreeRecursion(int depth, double lat, double lon, int i, int j, int w, int h, Result result) {
        int w2 = w >> 1;
        int h2 = h >> 1;
        int i2 = i + w2;
        int j2 = j + h2;
        int w2r = w - w2;
        int h2r = h - h2;
        if (w2 < 2) {
            w2 = 2;
        }
        if (h2 < 2) {
            h2 = 2;
        }
        int increasedDepth = depth + 1;
        boolean b1 = this.quadTreeSearch(increasedDepth, lat, lon, i, j, w2, h2, result);
        boolean b2 = this.quadTreeSearch(increasedDepth, lat, lon, i, j2, w2, h2r, result);
        boolean b3 = this.quadTreeSearch(increasedDepth, lat, lon, i2, j, w2r, h2, result);
        boolean b4 = this.quadTreeSearch(increasedDepth, lat, lon, i2, j2, w2r, h2r, result);
        return b1 || b2 || b3 || b4;
    }

    public static class Plugin
    implements InversePlugin {
        private final boolean fractionalAccuracy;

        public Plugin(boolean fractionalAccuracy) {
            this.fractionalAccuracy = fractionalAccuracy;
        }

        @Override
        public InverseCoding create() {
            return new PixelQuadTreeInverse(this.fractionalAccuracy);
        }
    }
}

