/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding.inverse;

import java.util.ArrayList;
import org.esa.snap.core.dataio.geocoding.inverse.GeoPosCalculator;
import org.esa.snap.core.datamodel.GeoPos;

class Segment {
    static final int MIN_DIMENSION = 4;
    final int x_min;
    final int x_max;
    final int y_min;
    final int y_max;
    double lon_min;
    double lon_max;
    double lat_min;
    double lat_max;
    boolean containsAntiMeridian;

    Segment(int x_min, int x_max, int y_min, int y_max) {
        this.x_min = x_min;
        this.x_max = x_max;
        this.y_min = y_min;
        this.y_max = y_max;
        this.lon_min = Double.NaN;
        this.lon_max = Double.NaN;
        this.lat_min = Double.NaN;
        this.lat_max = Double.NaN;
        this.containsAntiMeridian = false;
    }

    Segment[] split(boolean acrossTrack) {
        int width = this.x_max - this.x_min + 1;
        int height = this.y_max - this.y_min + 1;
        if (width <= 4 || height <= 4) {
            return new Segment[]{this};
        }
        Segment[] segments = new Segment[2];
        if (acrossTrack) {
            int y_split = this.y_min + height / 2;
            segments[0] = new Segment(this.x_min, this.x_max, this.y_min, y_split);
            segments[1] = new Segment(this.x_min, this.x_max, y_split + 1, this.y_max);
        } else {
            int x_split = this.x_min + width / 2;
            segments[0] = new Segment(this.x_min, x_split, this.y_min, this.y_max);
            segments[1] = new Segment(x_split + 1, this.x_max, this.y_min, this.y_max);
        }
        return segments;
    }

    Segment[] split_x(int xPos) {
        if (xPos <= this.x_min || xPos >= this.x_max) {
            throw new IllegalArgumentException("attempt to split outside segment region");
        }
        if (xPos - this.x_min < 4 || this.x_max - xPos < 4) {
            return new Segment[]{this};
        }
        Segment[] segments = new Segment[]{new Segment(this.x_min, xPos - 1, this.y_min, this.y_max), new Segment(xPos, this.x_max, this.y_min, this.y_max)};
        return segments;
    }

    Segment[] split_y(int yPos) {
        if (yPos <= this.y_min || yPos >= this.y_max) {
            throw new IllegalArgumentException("attempt to split outside segment region");
        }
        if (yPos - this.y_min < 4 || this.y_max - yPos < 4) {
            return new Segment[]{this};
        }
        Segment[] segments = new Segment[]{new Segment(this.x_min, this.x_max, this.y_min, yPos - 1), new Segment(this.x_min, this.x_max, yPos, this.y_max)};
        return segments;
    }

    void calculateGeoPoints(GeoPosCalculator calculator) {
        GeoPos geoPos;
        int i;
        ArrayList<GeoPos> geoPosList = new ArrayList<GeoPos>();
        for (int i2 = 0; i2 < 4; ++i2) {
            geoPosList.add(new GeoPos());
        }
        calculator.getGeoPos(this.x_min, this.y_min, (GeoPos)geoPosList.get(0));
        calculator.getGeoPos(this.x_max, this.y_min, (GeoPos)geoPosList.get(1));
        calculator.getGeoPos(this.x_max, this.y_max, (GeoPos)geoPosList.get(2));
        calculator.getGeoPos(this.x_min, this.y_max, (GeoPos)geoPosList.get(3));
        double minItLon = 180.0;
        double maxItLon = -180.0;
        double minItLat = 90.0;
        double maxItLat = -90.0;
        for (i = 0; i < 4; ++i) {
            geoPos = (GeoPos)geoPosList.get(i);
            if (geoPos.lon < minItLon) {
                minItLon = geoPos.lon;
            }
            if (geoPos.lon > maxItLon) {
                maxItLon = geoPos.lon;
            }
            if (geoPos.lat < minItLat) {
                minItLat = geoPos.lat;
            }
            if (!(geoPos.lat > maxItLat)) continue;
            maxItLat = geoPos.lat;
        }
        this.lon_min = minItLon;
        this.lon_max = maxItLon;
        this.lat_min = minItLat;
        this.lat_max = maxItLat;
        if (Math.abs(maxItLon - minItLon) > 270.0) {
            this.containsAntiMeridian = true;
        }
        if (this.containsAntiMeridian) {
            minItLon = -180.0;
            maxItLon = 180.0;
            for (i = 0; i < 4; ++i) {
                geoPos = (GeoPos)geoPosList.get(i);
                if (geoPos.lon > 0.0) {
                    if (!(geoPos.lon < maxItLon)) continue;
                    maxItLon = geoPos.lon;
                    continue;
                }
                if (!(geoPos.lon > minItLon)) continue;
                minItLon = geoPos.lon;
            }
            this.lon_min = minItLon;
            this.lon_max = maxItLon;
        }
    }

    boolean isInside(double lon, double lat) {
        if (this.containsAntiMeridian) {
            if (lon >= 0.0) {
                return lon >= this.lon_max && lat >= this.lat_min && lat <= this.lat_max;
            }
            return lon <= this.lon_min && lat >= this.lat_min && lat <= this.lat_max;
        }
        return lon >= this.lon_min && lon <= this.lon_max && lat >= this.lat_min && lat <= this.lat_max;
    }

    int getWidth() {
        return this.x_max - this.x_min + 1;
    }

    int getHeight() {
        return this.y_max - this.y_min + 1;
    }

    public Segment clone() {
        Segment clone = new Segment(this.x_min, this.x_max, this.y_min, this.y_max);
        clone.lon_min = this.lon_min;
        clone.lon_max = this.lon_max;
        clone.lat_min = this.lat_min;
        clone.lat_max = this.lat_max;
        clone.containsAntiMeridian = this.containsAntiMeridian;
        return clone;
    }
}

