/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding.util;

import org.esa.snap.core.util.math.EuclideanDistance;

public class InterpolationContext {
    public double[] lons = new double[4];
    public double[] lats = new double[4];
    public int[] x = new int[4];
    public int[] y = new int[4];

    public static InterpolationContext extract(int x, int y, double[] longitudes, double[] latitudes, int rasterWidth, int rasterHeight) {
        int y_start;
        int x_start;
        double[] center_lons = new double[4];
        double[] center_lats = new double[4];
        int lineOffset = y * rasterWidth;
        int lineOffset_minus = (y - 1) * rasterWidth;
        int centerIndex = lineOffset + x;
        double ref_lon = longitudes[centerIndex];
        double ref_lat = latitudes[centerIndex];
        if (y - 1 >= 0 && x - 1 >= 0) {
            center_lons[0] = 0.25 * (longitudes[lineOffset_minus + x - 1] + longitudes[lineOffset_minus + x] + longitudes[lineOffset + x - 1] + longitudes[lineOffset + x]);
            center_lats[0] = 0.25 * (latitudes[lineOffset_minus + x - 1] + latitudes[lineOffset_minus + x] + latitudes[lineOffset + x - 1] + latitudes[lineOffset + x]);
        } else {
            center_lons[0] = Double.NaN;
            center_lats[0] = Double.NaN;
        }
        if (y - 1 >= 0 && x + 1 < rasterWidth) {
            center_lons[1] = 0.25 * (longitudes[lineOffset_minus + x] + longitudes[lineOffset_minus + x + 1] + longitudes[lineOffset + x] + longitudes[lineOffset + x + 1]);
            center_lats[1] = 0.25 * (latitudes[lineOffset_minus + x] + latitudes[lineOffset_minus + x + 1] + latitudes[lineOffset + x] + latitudes[lineOffset + x + 1]);
        } else {
            center_lons[1] = Double.NaN;
            center_lats[1] = Double.NaN;
        }
        if (y + 1 < rasterHeight && x + 1 < rasterWidth) {
            center_lons[2] = 0.25 * (longitudes[lineOffset + x] + longitudes[lineOffset + x + 1] + longitudes[(y + 1) * rasterWidth + x + 1] + longitudes[(y + 1) * rasterWidth + x]);
            center_lats[2] = 0.25 * (latitudes[lineOffset + x] + latitudes[lineOffset + x + 1] + latitudes[(y + 1) * rasterWidth + x + 1] + latitudes[(y + 1) * rasterWidth + x]);
        } else {
            center_lons[2] = Double.NaN;
            center_lats[2] = Double.NaN;
        }
        if (y + 1 < rasterHeight && x - 1 >= 0) {
            center_lons[3] = 0.25 * (longitudes[lineOffset + x - 1] + longitudes[lineOffset + x] + longitudes[(y + 1) * rasterWidth + x] + longitudes[(y + 1) * rasterWidth + x - 1]);
            center_lats[3] = 0.25 * (latitudes[lineOffset + x - 1] + latitudes[lineOffset + x] + latitudes[(y + 1) * rasterWidth + x] + latitudes[(y + 1) * rasterWidth + x - 1]);
        } else {
            center_lons[3] = Double.NaN;
            center_lats[3] = Double.NaN;
        }
        int quadrant = -1;
        EuclideanDistance distCalc = new EuclideanDistance(ref_lon, ref_lat);
        double min_dist = Double.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            double distance;
            if (Double.isNaN(center_lons[i]) || !((distance = distCalc.distance(center_lons[i], center_lats[i])) < min_dist)) continue;
            min_dist = distance;
            quadrant = i;
        }
        if (quadrant == 0) {
            x_start = x - 1;
            y_start = y - 1;
        } else if (quadrant == 1) {
            x_start = x;
            y_start = y - 1;
        } else if (quadrant == 2) {
            x_start = x;
            y_start = y;
        } else {
            x_start = x - 1;
            y_start = y;
        }
        InterpolationContext context = new InterpolationContext();
        for (int m = 0; m < 2; ++m) {
            for (int k = 0; k < 2; ++k) {
                int writeIndex = 2 * m + k;
                int readIndex = (y_start + m) * rasterWidth + x_start + k;
                context.lons[writeIndex] = longitudes[readIndex];
                context.lats[writeIndex] = latitudes[readIndex];
                context.x[writeIndex] = x_start + k;
                context.y[writeIndex] = y_start + m;
            }
        }
        return context;
    }
}

