/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geocoding.util;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import org.esa.snap.core.dataio.geocoding.Discontinuity;
import org.esa.snap.core.dataio.geocoding.GeoRaster;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.math.SphericalDistance;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.datum.Ellipsoid;

public class RasterUtils {
    private static final double MEAN_EARTH_RADIUS_KM = 6370.997;
    private static final double STEP_THRESH = 180.0;

    static Discontinuity calculateDiscontinuity(float[] longitudes) {
        float max = Float.MIN_VALUE;
        for (float value : longitudes) {
            if (!(value > max)) continue;
            max = value;
        }
        if ((double)max > 180.0) {
            return Discontinuity.AT_360;
        }
        return Discontinuity.AT_180;
    }

    public static boolean containsAntiMeridian(double[] longitudes, int width) {
        double step;
        int y;
        int height = longitudes.length / width;
        for (int x = 1; x < width; ++x) {
            double step2 = Math.abs(longitudes[x] - longitudes[x - 1]);
            if (!(step2 > 180.0)) continue;
            return true;
        }
        for (y = 1; y < height; ++y) {
            step = Math.abs(longitudes[y * width] - longitudes[(y - 1) * width]);
            if (!(step > 180.0)) continue;
            return true;
        }
        int lineOffset = (height - 1) * width;
        for (int x = 1; x < width; ++x) {
            step = Math.abs(longitudes[lineOffset + x] - longitudes[lineOffset + x - 1]);
            if (!(step > 180.0)) continue;
            return true;
        }
        for (y = 1; y < height; ++y) {
            lineOffset = width - 1;
            step = Math.abs(longitudes[y * width + lineOffset] - longitudes[(y - 1) * width + lineOffset]);
            if (!(step > 180.0)) continue;
            return true;
        }
        return false;
    }

    public static PixelPos[] getPoleLocations(GeoRaster geoRaster) {
        double minLat;
        double deltaToPole = RasterUtils.getLatDeltaToPole(geoRaster.getRasterResolutionInKm());
        double maxLat = 90.0 - deltaToPole;
        ArrayList<PixelPos> poleCandidates = RasterUtils.findPoleCandidates(geoRaster, maxLat, minLat = -90.0 + deltaToPole);
        if (poleCandidates.size() == 0) {
            return new PixelPos[0];
        }
        ArrayList<PixelPos> consolidatedPoleLocations = new ArrayList<PixelPos>();
        double[] lons = geoRaster.getLongitudes();
        int width = geoRaster.getRasterWidth();
        for (PixelPos candidate : poleCandidates) {
            double[] deltas = new double[8];
            int x = (int)candidate.x;
            int y = (int)candidate.y;
            deltas[0] = Math.abs(lons[y * width + (x - 1)] - lons[(y - 1) * width + (x - 1)]);
            deltas[1] = Math.abs(lons[(y + 1) * width + (x - 1)] - lons[y * width + (x - 1)]);
            deltas[2] = Math.abs(lons[(y + 1) * width + x] - lons[(y + 1) * width + (x - 1)]);
            deltas[3] = Math.abs(lons[(y + 1) * width + (x + 1)] - lons[(y + 1) * width + x]);
            deltas[4] = Math.abs(lons[y * width + (x + 1)] - lons[(y + 1) * width + (x + 1)]);
            deltas[5] = Math.abs(lons[(y - 1) * width + (x + 1)] - lons[y * width + (x + 1)]);
            deltas[6] = Math.abs(lons[(y - 1) * width + x] - lons[(y - 1) * width + (x + 1)]);
            deltas[7] = Math.abs(lons[(y - 1) * width + (x - 1)] - lons[(y - 1) * width + x]);
            int numMeridianCrossings = 0;
            for (double delta : deltas) {
                if (!(delta > 180.0)) continue;
                ++numMeridianCrossings;
            }
            if (numMeridianCrossings % 2 != 1) continue;
            consolidatedPoleLocations.add(candidate);
        }
        return consolidatedPoleLocations.toArray(new PixelPos[0]);
    }

    static double getLatDeltaToPole(double distanceInKm) {
        return distanceInKm * 180.0 / 20015.077371242613;
    }

    public static float[] toFloat(double[] doubles) {
        float[] floats = new float[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            floats[i] = (float)doubles[i];
        }
        return floats;
    }

    static double[] toDouble(float[] floats) {
        double[] doubles = new double[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            doubles[i] = floats[i];
        }
        return doubles;
    }

    public static double[] loadDataScaled(RasterDataNode dataNode) throws IOException {
        dataNode.loadRasterData();
        Dimension rasterSize = dataNode.getRasterSize();
        double[] values = new double[rasterSize.width * rasterSize.height];
        dataNode.readPixels(0, 0, rasterSize.width, rasterSize.height, values);
        return values;
    }

    public static double[] loadData(RasterDataNode dataNode) throws IOException {
        dataNode.loadRasterData();
        ProductData data = dataNode.getData();
        double[] values = new double[data.getNumElems()];
        for (int i = 0; i < data.getNumElems(); ++i) {
            values[i] = data.getElemDoubleAt(i);
        }
        return values;
    }

    public static double[] loadGeoData(RasterDataNode dataNode) throws IOException {
        Dimension rasterSize = dataNode.getRasterSize();
        double[] geoData = new double[rasterSize.width * rasterSize.height];
        dataNode.readPixels(0, 0, rasterSize.width, rasterSize.height, geoData);
        dataNode.unloadRasterData();
        dataNode.removeCachedImageData();
        return geoData;
    }

    private static ArrayList<PixelPos> findPoleCandidates(GeoRaster geoRaster, double maxLat, double minLat) {
        ArrayList<PixelPos> poleCandidates = new ArrayList<PixelPos>();
        double[] latitudes = geoRaster.getLatitudes();
        int rasterWidth = geoRaster.getRasterWidth();
        for (int y = 0; y < geoRaster.getRasterHeight(); ++y) {
            int lineOffset = y * rasterWidth;
            for (int x = 0; x < rasterWidth; ++x) {
                double lat = latitudes[lineOffset + x];
                if (!(lat >= maxLat) && !(lat <= minLat)) continue;
                poleCandidates.add(new PixelPos(x, y));
            }
        }
        return poleCandidates;
    }

    public static double computeResolutionInKm(double[] lonData, double[] latData, int width, int height) {
        Rectangle r = RasterUtils.getCenterExtractWindow(width, height);
        int count = 0;
        double distanceSum = 0.0;
        int yMax = r.y + r.height - 1;
        int xMax = r.x + r.width - 1;
        for (int y = r.y; y <= yMax; ++y) {
            for (int x = r.x; x <= xMax; ++x) {
                double distance;
                int idx = y * width + x;
                double resLon = lonData[idx];
                double resLat = latData[idx];
                SphericalDistance spherDist = new SphericalDistance(resLon, resLat);
                if (x < xMax) {
                    int idxRight = idx + 1;
                    distance = spherDist.distance(lonData[idxRight], latData[idxRight]);
                    distanceSum += distance;
                    ++count;
                }
                if (y >= yMax) continue;
                int idxBottom = idx + width;
                distance = spherDist.distance(lonData[idxBottom], latData[idxBottom]);
                distanceSum += distance;
                ++count;
            }
        }
        double distanceMeanRadian = distanceSum / (double)count;
        DefaultGeographicCRS wgs84 = DefaultGeographicCRS.WGS84;
        Ellipsoid ellipsoid = wgs84.getDatum().getEllipsoid();
        double meanEarthRadiusM = (ellipsoid.getSemiMajorAxis() + ellipsoid.getSemiMinorAxis()) / 2.0;
        double meanEarthRadiusKm = meanEarthRadiusM / 1000.0;
        return distanceMeanRadian * meanEarthRadiusKm;
    }

    public static void printPointWkt(GeoPos geoPos) {
        System.out.println("POINT( " + geoPos.lon + " " + geoPos.lat + ")");
    }

    private static Rectangle getCenterExtractWindow(int width, int height) {
        Rectangle R = new Rectangle(0, 0, 10, 10);
        R.width = Math.min(R.width, width);
        R.height = Math.min(R.height, height);
        if (width > R.width) {
            R.x = (width - R.width) / 2;
        }
        if (height > R.height) {
            R.y = (height - R.height) / 2;
        }
        return R;
    }
}

