/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.jai.GeneralFilterFunction;
import com.bc.ceres.jai.operator.GeneralFilterDescriptor;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import javax.media.jai.RenderedOp;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.Kernel;
import org.esa.snap.core.datamodel.RasterDataNode;

public class GeneralFilterBand
extends FilterBand {
    private final OpType opType;
    private final Kernel structuringElement;
    private final int iterationCount;

    public GeneralFilterBand(String name, RasterDataNode source, OpType opType, Kernel structuringElement, int iterationCount) {
        super(name, source.getGeophysicalDataType() == 31 ? 31 : 30, source.getRasterWidth(), source.getRasterHeight(), source);
        Assert.notNull((Object)((Object)opType), (String)"opType");
        Assert.notNull((Object)structuringElement, (String)"structuringElement");
        this.opType = opType;
        this.structuringElement = structuringElement;
        this.iterationCount = iterationCount;
    }

    public GeneralFilterBand(String name, RasterDataNode source, Dimension filterBandSize, OpType opType, Kernel structuringElement, int iterationCount) {
        super(name, source.getGeophysicalDataType() == 31 ? 31 : 30, filterBandSize.width, filterBandSize.height, source);
        Assert.notNull((Object)((Object)opType), (String)"opType");
        Assert.notNull((Object)structuringElement, (String)"structuringElement");
        this.opType = opType;
        this.structuringElement = structuringElement;
        this.iterationCount = iterationCount;
    }

    public OpType getOpType() {
        return this.opType;
    }

    public Kernel getStructuringElement() {
        return this.structuringElement;
    }

    @Override
    protected RenderedImage createSourceLevelImage(RenderedImage sourceImage, int level, RenderingHints rh) {
        int x = this.structuringElement.getXOrigin();
        int y = this.structuringElement.getYOrigin();
        int w = this.structuringElement.getWidth();
        int h = this.structuringElement.getHeight();
        boolean[] data = GeneralFilterBand.toStructuringElementData(this.structuringElement);
        RenderedImage targetImage = sourceImage;
        for (int i = 0; i < this.iterationCount; ++i) {
            targetImage = this.createSourceLevelImage(targetImage, x, y, w, h, data, rh);
        }
        return targetImage;
    }

    private RenderedImage createSourceLevelImage(RenderedImage sourceImage, int x, int y, int w, int h, boolean[] data, RenderingHints rh) {
        RenderedOp targetImage;
        if (this.getOpType() == OpType.MIN) {
            targetImage = GeneralFilterDescriptor.create((RenderedImage)sourceImage, (GeneralFilterFunction)new GeneralFilterFunction.Min(w, h, x, y, data), (RenderingHints)rh);
        } else if (this.getOpType() == OpType.MAX) {
            targetImage = GeneralFilterDescriptor.create((RenderedImage)sourceImage, (GeneralFilterFunction)new GeneralFilterFunction.Max(w, h, x, y, data), (RenderingHints)rh);
        } else if (this.getOpType() == OpType.MEDIAN) {
            targetImage = GeneralFilterDescriptor.create((RenderedImage)sourceImage, (GeneralFilterFunction)new GeneralFilterFunction.Median(w, h, x, y, data), (RenderingHints)rh);
        } else if (this.getOpType() == OpType.MEAN) {
            targetImage = GeneralFilterDescriptor.create((RenderedImage)sourceImage, (GeneralFilterFunction)new GeneralFilterFunction.Mean(w, h, x, y, data), (RenderingHints)rh);
        } else if (this.getOpType() == OpType.STDDEV) {
            targetImage = GeneralFilterDescriptor.create((RenderedImage)sourceImage, (GeneralFilterFunction)new GeneralFilterFunction.StdDev(w, h, x, y, data), (RenderingHints)rh);
        } else if (this.getOpType() == OpType.EROSION) {
            targetImage = GeneralFilterDescriptor.create((RenderedImage)sourceImage, (GeneralFilterFunction)new GeneralFilterFunction.Erosion(w, h, x, y, data), (RenderingHints)rh);
        } else if (this.getOpType() == OpType.DILATION) {
            targetImage = GeneralFilterDescriptor.create((RenderedImage)sourceImage, (GeneralFilterFunction)new GeneralFilterFunction.Dilation(w, h, x, y, data), (RenderingHints)rh);
        } else if (this.getOpType() == OpType.OPENING) {
            targetImage = GeneralFilterDescriptor.create((RenderedImage)sourceImage, (GeneralFilterFunction)new GeneralFilterFunction.Erosion(w, h, x, y, data), (RenderingHints)rh);
            targetImage = GeneralFilterDescriptor.create((RenderedImage)targetImage, (GeneralFilterFunction)new GeneralFilterFunction.Dilation(w, h, x, y, data), (RenderingHints)rh);
        } else if (this.getOpType() == OpType.CLOSING) {
            targetImage = GeneralFilterDescriptor.create((RenderedImage)sourceImage, (GeneralFilterFunction)new GeneralFilterFunction.Dilation(w, h, x, y, data), (RenderingHints)rh);
            targetImage = GeneralFilterDescriptor.create((RenderedImage)targetImage, (GeneralFilterFunction)new GeneralFilterFunction.Erosion(w, h, x, y, data), (RenderingHints)rh);
        } else {
            throw new IllegalStateException(String.format("Unsupported operation type '%s'", new Object[]{this.getOpType()}));
        }
        return targetImage;
    }

    private static boolean[] toStructuringElementData(Kernel kernel) {
        double[] kernelElements = kernel.getKernelData(null);
        boolean[] structuringElement = new boolean[kernelElements.length];
        boolean hasFalse = false;
        boolean hasTrue = false;
        for (int i = 0; i < kernelElements.length; ++i) {
            boolean b;
            boolean bl = b = kernelElements[i] != 0.0;
            if (b) {
                hasTrue = true;
            } else {
                hasFalse = true;
            }
            structuringElement[i] = b;
        }
        return hasTrue && hasFalse ? structuringElement : null;
    }

    public static enum OpType {
        MIN,
        MAX,
        MEDIAN,
        MEAN,
        STDDEV,
        EROSION,
        DILATION,
        OPENING,
        CLOSING;

    }
}

