/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.AbstractGeoCoding;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.PixelFinder;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.PixelPosEstimator;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.datamodel.SimplePixelDimensionEstimator;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.runtime.Config;

@Deprecated
class PixelGeoCoding2
extends AbstractGeoCoding
implements BasicPixelGeoCoding {
    private static final String SYSPROP_PIXEL_GEO_CODING_FRACTION_ACCURACY = "snap.pixelGeoCoding.fractionAccuracy";
    private static final String SYSPROP_PIXEL_GEO_CODING_USE_TILING = "snap.pixelGeoCoding.useTiling";
    private final Band latBand;
    private final Band lonBand;
    private final String maskExpression;
    private final int rasterW;
    private final int rasterH;
    private final int searchRadius;
    private final boolean fractionAccuracy;
    private final DataProvider dataProvider;
    private final GeoCoding formerGeocoding;
    private transient PixelPosEstimator pixelPosEstimator;
    private transient PixelFinder pixelFinder;

    PixelGeoCoding2(Band latBand, Band lonBand, String maskExpression, int searchRadius) {
        MultiLevelImage latImage;
        MultiLevelImage lonImage;
        Guardian.assertNotNull("latBand", latBand);
        Guardian.assertNotNull("lonBand", lonBand);
        Product product = latBand.getProduct();
        if (product == null) {
            throw new IllegalArgumentException("latBand.getProduct() == null");
        }
        if (lonBand.getProduct() == null) {
            throw new IllegalArgumentException("lonBand.getProduct() == null");
        }
        if (product != lonBand.getProduct()) {
            throw new IllegalArgumentException("latBand.getProduct() != lonBand.getProduct()");
        }
        if (product.getSceneRasterWidth() < 2 || product.getSceneRasterHeight() < 2) {
            throw new IllegalArgumentException("latBand.getProduct().getSceneRasterWidth() < 2 || latBand.getProduct().getSceneRasterHeight() < 2");
        }
        this.searchRadius = searchRadius;
        this.fractionAccuracy = Config.instance().preferences().getBoolean(SYSPROP_PIXEL_GEO_CODING_FRACTION_ACCURACY, false);
        this.latBand = latBand;
        this.lonBand = lonBand;
        this.formerGeocoding = product.getSceneGeoCoding();
        this.rasterW = latBand.getRasterWidth();
        this.rasterH = latBand.getRasterHeight();
        try {
            lonImage = (PlanarImage)lonBand.getGeophysicalImage().getImage(0);
        }
        catch (ClassCastException e) {
            lonImage = lonBand.getGeophysicalImage();
        }
        try {
            latImage = (PlanarImage)latBand.getGeophysicalImage().getImage(0);
        }
        catch (ClassCastException e) {
            latImage = latBand.getGeophysicalImage();
        }
        PlanarImage maskImage = null;
        if (maskExpression != null) {
            if ((maskExpression = maskExpression.trim()).length() > 0) {
                ProductNodeGroup<Mask> maskGroup = product.getMaskGroup();
                for (int i = 0; i < maskGroup.getNodeCount(); ++i) {
                    Mask mask = maskGroup.get(i);
                    if (mask.getImageType() != Mask.BandMathsType.INSTANCE || !maskExpression.equals(Mask.BandMathsType.getExpression(mask))) continue;
                    maskImage = mask.getSourceImage();
                    break;
                }
                if (maskImage == null) {
                    maskImage = (PlanarImage)lonBand.getProduct().getMaskImage(maskExpression, lonBand).getImage(0);
                }
            } else {
                maskExpression = null;
                maskImage = null;
            }
        } else {
            maskExpression = null;
            maskImage = null;
        }
        this.maskExpression = maskExpression;
        SimplePixelDimensionEstimator pixelDimensionEstimator = new SimplePixelDimensionEstimator();
        Dimension2D pixelDimension = pixelDimensionEstimator.getPixelDimension((PlanarImage)lonImage, (PlanarImage)latImage, maskImage);
        double pixelSizeX = pixelDimension.getWidth();
        double pixelSizeY = pixelDimension.getHeight();
        double pixelDiagonalSquared = pixelSizeX * pixelSizeX + pixelSizeY * pixelSizeY;
        double halfPixelDiagonal = Math.sqrt(pixelDiagonalSquared) / 2.0;
        this.pixelPosEstimator = new PixelPosEstimator((PlanarImage)lonImage, (PlanarImage)latImage, maskImage, 0.5, true);
        this.pixelFinder = new PixelFinder((PlanarImage)lonImage, (PlanarImage)latImage, maskImage, halfPixelDiagonal, this.fractionAccuracy, searchRadius);
        boolean useTiling = Config.instance().preferences().getBoolean(SYSPROP_PIXEL_GEO_CODING_USE_TILING, true);
        boolean disableTiling = !useTiling;
        this.dataProvider = disableTiling ? new ArrayDataProvider(lonBand, latBand, maskImage) : new ImageDataProvider((RenderedImage)lonImage, (RenderedImage)maskImage, (RenderedImage)latImage, (RenderedImage)maskImage);
    }

    @Override
    public Band getLatBand() {
        return this.latBand;
    }

    @Override
    public Band getLonBand() {
        return this.lonBand;
    }

    @Override
    public String getValidMask() {
        return this.maskExpression;
    }

    @Override
    public GeoCoding getPixelPosEstimator() {
        return this.formerGeocoding;
    }

    @Override
    public int getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public boolean isCrossingMeridianAt180() {
        return false;
    }

    @Override
    public boolean canGetPixelPos() {
        return this.pixelPosEstimator.canGetPixelPos();
    }

    @Override
    public boolean canGetGeoPos() {
        return true;
    }

    @Override
    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        if (pixelPos == null) {
            pixelPos = new PixelPos();
        }
        if (geoPos.isValid()) {
            this.pixelPosEstimator.getPixelPos(geoPos, pixelPos);
            if (pixelPos.isValid()) {
                this.pixelFinder.findPixelPos(geoPos, pixelPos);
            }
        } else {
            pixelPos.setInvalid();
        }
        return pixelPos;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        if (geoPos == null) {
            geoPos = new GeoPos();
        }
        geoPos.setInvalid();
        if (pixelPos.isValid()) {
            if (this.pixelPosIsInsideRasterWH(pixelPos)) {
                int x0 = (int)Math.floor(pixelPos.getX()) - (pixelPos.x == (double)this.rasterW ? 1 : 0);
                int y0 = (int)Math.floor(pixelPos.getY()) - (pixelPos.y == (double)this.rasterH ? 1 : 0);
                if (this.fractionAccuracy && !this.isInPixelCenter(pixelPos)) {
                    if (x0 > 0 && pixelPos.x - (double)x0 < 0.5 || x0 == this.rasterW - 1) {
                        --x0;
                    }
                    if (y0 > 0 && pixelPos.y - (double)y0 < 0.5 || y0 == this.rasterH - 1) {
                        --y0;
                    }
                    double wx = pixelPos.x - ((double)x0 + 0.5);
                    double wy = pixelPos.y - ((double)y0 + 0.5);
                    this.dataProvider.getGeoPosDouble(x0, y0, wx, wy, geoPos);
                    if (!geoPos.isValid()) {
                        this.dataProvider.getGeoPosInteger(x0, y0, geoPos);
                    }
                } else {
                    this.dataProvider.getGeoPosInteger(x0, y0, geoPos);
                }
            }
            if (!geoPos.isValid()) {
                if (this.formerGeocoding != null && this.formerGeocoding.canGetGeoPos()) {
                    this.formerGeocoding.getGeoPos(pixelPos, geoPos);
                } else {
                    this.pixelPosEstimator.getGeoPos(pixelPos, geoPos);
                }
            }
        }
        return geoPos;
    }

    private boolean isInPixelCenter(PixelPos pixelPos) {
        return Math.abs(pixelPos.getX() - Math.floor(pixelPos.getX()) - 0.5) < 1.0E-8 && Math.abs(pixelPos.getY() - Math.floor(pixelPos.getY()) - 0.5) < 1.0E-8;
    }

    private boolean pixelPosIsInsideRasterWH(PixelPos pixelPos) {
        double x = pixelPos.x;
        double y = pixelPos.y;
        return x >= 0.0 && x <= (double)this.rasterW && y >= 0.0 && y <= (double)this.rasterH;
    }

    public int getRasterWidth() {
        return this.rasterW;
    }

    public int getRasterHeight() {
        return this.rasterH;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PixelGeoCoding2 that = (PixelGeoCoding2)o;
        if (!this.latBand.equals(that.latBand)) {
            return false;
        }
        if (!this.lonBand.equals(that.lonBand)) {
            return false;
        }
        return !(this.maskExpression != null ? !this.maskExpression.equals(that.maskExpression) : that.maskExpression != null);
    }

    public int hashCode() {
        int result = this.latBand.hashCode();
        result = 31 * result + this.lonBand.hashCode();
        if (this.maskExpression != null) {
            result = 31 * result + this.maskExpression.hashCode();
        }
        return result;
    }

    @Override
    public synchronized void dispose() {
        this.pixelPosEstimator = null;
        this.pixelFinder = null;
    }

    @Override
    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        Band srcLonBand;
        Band lonBand;
        Band srcLatBand = this.getLatBand();
        Product destProduct = destScene.getProduct();
        Band latBand = destProduct.getBand(srcLatBand.getName());
        if (latBand == null) {
            latBand = GeoCodingFactory.createSubset(srcLatBand, destScene, subsetDef);
            destProduct.addBand(latBand);
        }
        if ((lonBand = destProduct.getBand((srcLonBand = this.getLonBand()).getName())) == null) {
            lonBand = GeoCodingFactory.createSubset(srcLonBand, destScene, subsetDef);
            destProduct.addBand(lonBand);
        }
        String validMaskExpression = this.getValidMask();
        try {
            if (validMaskExpression != null) {
                GeoCodingFactory.copyReferencedRasters(validMaskExpression, srcScene, destScene, subsetDef);
            }
        }
        catch (ParseException ignored) {
            validMaskExpression = null;
        }
        destScene.setGeoCoding(new PixelGeoCoding2(latBand, lonBand, validMaskExpression, this.searchRadius));
        return true;
    }

    @Override
    public Datum getDatum() {
        return Datum.WGS_84;
    }

    private static class ArrayDataProvider
    implements DataProvider {
        private final double[] lonData;
        private final double[] latData;
        private final int width;

        ArrayDataProvider(RasterDataNode lonBand, RasterDataNode latBand, PlanarImage maskImage) {
            this.width = lonBand.getRasterWidth();
            int height = lonBand.getRasterHeight();
            MultiLevelImage lonImage = ImageManager.createMaskedGeophysicalImage(lonBand, Double.NaN);
            this.lonData = lonImage.getData().getSamples(0, 0, this.width, height, 0, (double[])null);
            MultiLevelImage latImage = ImageManager.createMaskedGeophysicalImage(latBand, Double.NaN);
            this.latData = latImage.getData().getSamples(0, 0, this.width, height, 0, (double[])null);
            if (maskImage != null) {
                int[] maskValues = maskImage.getData().getSamples(0, 0, this.width, height, 0, (int[])null);
                for (int i = 0; i < maskValues.length; ++i) {
                    if (maskValues[i] != 0) continue;
                    this.lonData[i] = Double.NaN;
                    this.latData[i] = Double.NaN;
                }
            }
        }

        @Override
        public void getGeoPosInteger(int x0, int y0, GeoPos geoPos) {
            int i = this.width * y0 + x0;
            double lon0 = this.lonData[i];
            double lat0 = this.latData[i];
            if (lat0 >= -90.0 && lat0 <= 90.0 && lon0 >= -180.0 && lon0 <= 180.0) {
                geoPos.setLocation(lat0, lon0);
            }
        }

        @Override
        public void getGeoPosDouble(int x0, int y0, double wx, double wy, GeoPos geoPos) {
            geoPos.lon = this.interpolate(x0, y0, wx, wy, this.lonData, 1);
            geoPos.lat = this.interpolate(x0, y0, wx, wy, this.latData, 0);
        }

        private double interpolate(int x0, int y0, double wx, double wy, double[] data, int latLon) {
            double d11;
            double d01;
            double d10;
            double min = latLon == 0 ? -90.0 : -180.0;
            double max = latLon == 0 ? 90.0 : 180.0;
            int x1 = x0 + 1;
            int y1 = y0 + 1;
            double d00 = data[this.width * y0 + x0];
            if (d00 >= min && d00 <= max && (d10 = data[this.width * y0 + x1]) >= min && d10 <= max && (d01 = data[this.width * y1 + x0]) >= min && d01 <= max && (d11 = data[this.width * y1 + x1]) >= min && d11 <= max) {
                if (latLon == 0) {
                    return MathUtils.interpolate2D(wx, wy, d00, d10, d01, d11);
                }
                return GeoCodingFactory.interpolateLon(wx, wy, d00, d10, d01, d11);
            }
            return Double.NaN;
        }
    }

    private static class ImageDataProvider
    implements DataProvider {
        private final RenderedImage lonImage;
        private final RenderedImage lonMaskImage;
        private final RenderedImage latImage;
        private final RenderedImage latMaskImage;

        ImageDataProvider(RenderedImage lonImage, RenderedImage lonMaskImage, RenderedImage latImage, RenderedImage latMaskImage) {
            this.lonImage = lonImage;
            this.lonMaskImage = lonMaskImage;
            this.latImage = latImage;
            this.latMaskImage = latMaskImage;
        }

        @Override
        public void getGeoPosInteger(int x0, int y0, GeoPos geoPos) {
            double lon0 = this.getSampleDouble(x0, y0, this.lonImage, this.lonMaskImage);
            double lat0 = this.getSampleDouble(x0, y0, this.latImage, this.latMaskImage);
            if (lat0 >= -90.0 && lat0 <= 90.0 && lon0 >= -180.0 && lon0 <= 180.0) {
                geoPos.setLocation(lat0, lon0);
            }
        }

        @Override
        public void getGeoPosDouble(int x0, int y0, double wx, double wy, GeoPos geoPos) {
            Rectangle region = new Rectangle(x0, y0, 2, 2);
            if (this.lonMaskImage != null && !this.allValid(this.lonMaskImage.getData(region))) {
                geoPos.lon = Double.NaN;
                return;
            }
            Raster lonData = this.lonImage.getData(region);
            geoPos.lon = this.interpolate(wx, wy, lonData, 1);
            if (this.latMaskImage == null || this.allValid(this.latMaskImage.getData(region))) {
                Raster latData = this.latImage.getData(region);
                geoPos.lat = this.interpolate(wx, wy, latData, 0);
            } else {
                geoPos.lat = Double.NaN;
            }
        }

        private boolean allValid(Raster raster) {
            int x0 = raster.getMinX() - raster.getSampleModelTranslateX();
            int x1 = x0 + 1;
            int y0 = raster.getMinY() - raster.getSampleModelTranslateY();
            int y1 = y0 + 1;
            DataBuffer dataBuffer = raster.getDataBuffer();
            SampleModel sampleModel = raster.getSampleModel();
            if (sampleModel.getSample(x0, y0, 0, dataBuffer) == 0) {
                return false;
            }
            if (sampleModel.getSample(x1, y0, 0, dataBuffer) == 0) {
                return false;
            }
            if (sampleModel.getSample(x0, y1, 0, dataBuffer) == 0) {
                return false;
            }
            return sampleModel.getSample(x1, y1, 0, dataBuffer) != 0;
        }

        private double interpolate(double wx, double wy, Raster raster, int latLon) {
            double d11;
            double d01;
            double d10;
            double min = latLon == 0 ? -90.0 : -180.0;
            double max = latLon == 0 ? 90.0 : 180.0;
            int x0 = raster.getMinX() - raster.getSampleModelTranslateX();
            int x1 = x0 + 1;
            int y0 = raster.getMinY() - raster.getSampleModelTranslateY();
            int y1 = y0 + 1;
            DataBuffer dataBuffer = raster.getDataBuffer();
            SampleModel sampleModel = raster.getSampleModel();
            double d00 = sampleModel.getSampleDouble(x0, y0, 0, dataBuffer);
            if (d00 >= min && d00 <= max && (d10 = sampleModel.getSampleDouble(x1, y0, 0, dataBuffer)) >= min && d10 <= max && (d01 = sampleModel.getSampleDouble(x0, y1, 0, dataBuffer)) >= min && d01 <= max && (d11 = sampleModel.getSampleDouble(x1, y1, 0, dataBuffer)) >= min && d11 <= max) {
                if (latLon == 0) {
                    return MathUtils.interpolate2D(wx, wy, d00, d10, d01, d11);
                }
                return GeoCodingFactory.interpolateLon(wx, wy, d00, d10, d01, d11);
            }
            return Double.NaN;
        }

        private double getSampleDouble(int pixelX, int pixelY, RenderedImage dataImage, RenderedImage maskImage) {
            int y;
            int x;
            if (maskImage != null) {
                int maskTileY;
                x = maskImage.getMinX() + pixelX;
                y = maskImage.getMinY() + pixelY;
                int maskTileX = PlanarImage.XToTileX((int)x, (int)maskImage.getTileGridXOffset(), (int)maskImage.getTileWidth());
                int maskValue = maskImage.getTile(maskTileX, maskTileY = PlanarImage.YToTileY((int)y, (int)maskImage.getTileGridYOffset(), (int)maskImage.getTileHeight())).getSample(x, y, 0);
                if (maskValue == 0) {
                    return Double.NaN;
                }
            }
            x = dataImage.getMinX() + pixelX;
            y = dataImage.getMinY() + pixelY;
            int tileX = PlanarImage.XToTileX((int)x, (int)dataImage.getTileGridXOffset(), (int)dataImage.getTileWidth());
            int tileY = PlanarImage.YToTileY((int)y, (int)dataImage.getTileGridYOffset(), (int)dataImage.getTileHeight());
            Raster data = dataImage.getTile(tileX, tileY);
            return data.getSampleDouble(x, y, 0);
        }
    }

    private static interface DataProvider {
        public static final double LAT_MIN = -90.0;
        public static final double LAT_MAX = 90.0;
        public static final double LON_MIN = -180.0;
        public static final double LON_MAX = 180.0;
        public static final int LAT = 0;
        public static final int LON = 1;

        public void getGeoPosInteger(int var1, int var2, GeoPos var3);

        public void getGeoPosDouble(int var1, int var2, double var3, double var5, GeoPos var7);
    }
}

