/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import java.util.EventObject;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.util.Guardian;

public class ProductNodeEvent
extends EventObject {
    public static final int NODE_CHANGED = 0;
    public static final int NODE_ADDED = 1;
    public static final int NODE_REMOVED = 2;
    public static final int NODE_DATA_CHANGED = 3;
    private final ProductNodeGroup nodeGroup;
    private final int type;
    private final String propertyName;
    private final Object oldValue;
    private final Object newValue;

    public ProductNodeEvent(ProductNode sourceNode, int type) {
        this(sourceNode, type, null);
    }

    public ProductNodeEvent(ProductNode sourceNode, int type, ProductNodeGroup nodeGroup) {
        super((Object)sourceNode);
        this.nodeGroup = ProductNodeEvent.getNodeGroup(sourceNode, nodeGroup);
        this.propertyName = type == 3 ? "data" : null;
        this.type = type;
        this.oldValue = null;
        this.newValue = null;
    }

    public ProductNodeEvent(ProductNode sourceNode, String propertyName, Object oldValue, Object newValue) {
        super((Object)sourceNode);
        Guardian.assertNotNull("propertyName", propertyName);
        this.nodeGroup = ProductNodeEvent.getNodeGroup(sourceNode, null);
        this.propertyName = propertyName;
        this.type = 0;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public int getType() {
        return this.type;
    }

    public final ProductNode getSourceNode() {
        return (ProductNode)((Object)this.getSource());
    }

    public ProductNodeGroup getGroup() {
        return this.nodeGroup;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    @Override
    public String toString() {
        return String.format("%s [sourceNode=%s, propertyName=%s, type=%d]", new Object[]{this.getClass().getName(), this.getSourceNode(), this.getPropertyName(), this.getType()});
    }

    private static ProductNodeGroup getNodeGroup(ProductNode sourceNode, ProductNodeGroup nodeGroup) {
        if (nodeGroup != null) {
            return nodeGroup;
        }
        ProductNode owner = sourceNode.getOwner();
        if (owner instanceof ProductNodeGroup) {
            return (ProductNodeGroup)owner;
        }
        return null;
    }
}

