/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import java.util.Collection;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeList;
import org.esa.snap.core.datamodel.ProductVisitor;

public class ProductNodeGroup<T extends ProductNode>
extends ProductNode {
    private final ProductNodeList<T> nodeList = new ProductNodeList();
    private final boolean takingOverNodeOwnership;

    public ProductNodeGroup(String name) {
        this(null, name, false);
    }

    public ProductNodeGroup(ProductNode owner, String name, boolean takingOverNodeOwnership) {
        super(name, "");
        this.takingOverNodeOwnership = takingOverNodeOwnership;
        this.setOwner(owner);
    }

    public boolean isTakingOverNodeOwnership() {
        return this.takingOverNodeOwnership;
    }

    public int getNodeCount() {
        return this.nodeList.size();
    }

    public T get(int index) {
        return this.nodeList.getAt(index);
    }

    public String[] getNodeDisplayNames() {
        return this.nodeList.getDisplayNames();
    }

    public String[] getNodeNames() {
        return this.nodeList.getNames();
    }

    public ProductNode[] toArray() {
        return this.nodeList.toArray();
    }

    public T[] toArray(T[] array) {
        return this.nodeList.toArray((ProductNode[])array);
    }

    public int indexOf(String name) {
        return this.nodeList.indexOf(name);
    }

    public int indexOf(T element) {
        return this.nodeList.indexOf(element);
    }

    public T getByDisplayName(String displayName) {
        return this.nodeList.getByDisplayName(displayName);
    }

    public T get(String name) {
        return this.nodeList.get(name);
    }

    public boolean contains(String name) {
        return this.nodeList.contains(name);
    }

    public boolean contains(T node) {
        return this.nodeList.contains(node);
    }

    public boolean add(T node) {
        Assert.notNull(node, (String)"node");
        boolean added = this.nodeList.add(node);
        if (added) {
            this.notifyAdded(node);
        }
        return added;
    }

    public void add(int index, T node) {
        Assert.notNull(node, (String)"node");
        this.nodeList.add(index, node);
        this.notifyAdded(node);
    }

    public boolean remove(T node) {
        Assert.notNull(node, (String)"node");
        boolean removed = this.nodeList.remove(node);
        if (removed) {
            this.notifyRemoved(node);
        }
        return removed;
    }

    public void removeAll() {
        ProductNode[] nodes;
        for (ProductNode node : nodes = this.toArray()) {
            this.remove(node);
        }
    }

    public void clearRemovedList() {
        this.nodeList.clearRemovedList();
    }

    public Collection<T> getRemovedNodes() {
        return this.nodeList.getRemovedNodes();
    }

    @Override
    public long getRawStorageSize(ProductSubsetDef subsetDef) {
        ProductNode[] nodes;
        long size = 0L;
        for (ProductNode node : nodes = this.toArray()) {
            if (!subsetDef.isNodeAccepted(node.getName())) continue;
            size += node.getRawStorageSize(subsetDef);
        }
        return size;
    }

    @Override
    public void setModified(boolean modified) {
        boolean oldState = this.isModified();
        if (oldState != modified) {
            if (!modified) {
                for (ProductNode node : this.toArray()) {
                    node.setModified(false);
                }
                this.clearRemovedList();
            }
            super.setModified(modified);
        }
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        if (this.takingOverNodeOwnership) {
            for (ProductNode node : this.toArray()) {
                node.acceptVisitor(visitor);
            }
        }
        visitor.visit(this);
    }

    @Override
    public void dispose() {
        this.nodeList.dispose();
        super.dispose();
    }

    @Override
    public void updateExpression(String oldExternalName, String newExternalName) {
        if (this.takingOverNodeOwnership) {
            for (ProductNode node : this.toArray()) {
                node.updateExpression(oldExternalName, newExternalName);
            }
        }
    }

    private void notifyAdded(T node) {
        Product product;
        if (this.takingOverNodeOwnership) {
            ((ProductNode)((Object)node)).setOwner(this);
        }
        if ((product = this.getProduct()) != null) {
            product.fireNodeAdded((ProductNode)((Object)node), this);
        }
        this.setModified(true);
    }

    private void notifyRemoved(T node) {
        Product product = this.getProduct();
        if (product != null) {
            product.fireNodeRemoved((ProductNode)((Object)node), this);
        }
        if (this.takingOverNodeOwnership && ((ProductNode)((Object)node)).getOwner() == this) {
            ((ProductNode)((Object)node)).setOwner(null);
        }
        this.setModified(true);
    }
}

