/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductVisitor;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.TiePointGridOpImage;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.math.IndexValidator;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.core.util.math.Range;

public class TiePointGrid
extends RasterDataNode {
    public static final int DISCONT_AUTO = -1;
    public static final int DISCONT_NONE = 0;
    public static final int DISCONT_AT_180 = 180;
    public static final int DISCONT_AT_360 = 360;
    private final int gridWidth;
    private final int gridHeight;
    private final double offsetX;
    private final double offsetY;
    private final double subSamplingX;
    private final double subSamplingY;
    private int discontinuity;
    private volatile TiePointGrid sinGrid;
    private volatile TiePointGrid cosGrid;
    private volatile ProductData rasterData;

    public TiePointGrid(String name, int gridWidth, int gridHeight, double offsetX, double offsetY, double subSamplingX, double subSamplingY) {
        super(name, 30, gridWidth * gridHeight);
        Assert.argument((gridWidth >= 2 ? 1 : 0) != 0, (String)"gridWidth >= 2");
        Assert.argument((gridHeight >= 2 ? 1 : 0) != 0, (String)"gridHeight >= 2");
        Assert.argument((subSamplingX > 0.0 ? 1 : 0) != 0, (String)"subSamplingX > 0.0");
        Assert.argument((subSamplingY > 0.0 ? 1 : 0) != 0, (String)"subSamplingY > 0.0");
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.subSamplingX = subSamplingX;
        this.subSamplingY = subSamplingY;
        this.discontinuity = 0;
    }

    public TiePointGrid(String name, int gridWidth, int gridHeight, double offsetX, double offsetY, double subSamplingX, double subSamplingY, float[] tiePoints) {
        this(name, gridWidth, gridHeight, offsetX, offsetY, subSamplingX, subSamplingY, tiePoints, 0);
    }

    public TiePointGrid(String name, int gridWidth, int gridHeight, double offsetX, double offsetY, double subSamplingX, double subSamplingY, float[] tiePoints, boolean containsAngles) {
        this(name, gridWidth, gridHeight, offsetX, offsetY, subSamplingX, subSamplingY, tiePoints);
        Assert.argument((tiePoints.length == gridWidth * gridHeight ? 1 : 0) != 0, (String)"tiePoints.length == gridWidth * gridHeight");
        if (containsAngles) {
            this.setDiscontinuity(TiePointGrid.getDiscontinuity(tiePoints));
        }
    }

    public TiePointGrid(String name, int gridWidth, int gridHeight, double offsetX, double offsetY, double subSamplingX, double subSamplingY, float[] tiePoints, int discontinuity) {
        this(name, gridWidth, gridHeight, offsetX, offsetY, subSamplingX, subSamplingY);
        Assert.argument((tiePoints.length == gridWidth * gridHeight ? 1 : 0) != 0, (String)"tiePoints.length == gridWidth * gridHeight");
        Assert.argument((discontinuity == 0 || discontinuity == -1 || discontinuity == 180 || discontinuity == 360 ? 1 : 0) != 0, (String)"discontinuity");
        this.discontinuity = discontinuity;
        this.setData(ProductData.createInstance(tiePoints));
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public double getSubSamplingX() {
        return this.subSamplingX;
    }

    public double getSubSamplingY() {
        return this.subSamplingY;
    }

    public float[] getTiePoints() {
        return (float[])this.getGridData().getElems();
    }

    public ProductData getGridData() {
        if (this.getData() == null) {
            try {
                this.setData(this.readGridData(0, 0, this.getGridWidth(), this.getGridHeight()));
            }
            catch (IOException e) {
                SystemUtils.LOG.severe("Unable to load TPG: " + e.getMessage());
            }
        }
        return this.getData();
    }

    private float[] getTiePoints(int x, int y, int width, int height) {
        ProductData gridData = this.getData();
        float[] tiePoints = new float[width * height];
        if (gridData != null) {
            float[] oldTiePoints = (float[])gridData.getElems();
            for (int y1 = 0; y1 < height; ++y1) {
                int srcPos = this.getGridWidth() * (y + y1) + x;
                System.arraycopy(oldTiePoints, srcPos, tiePoints, y1 * width, width);
            }
        } else {
            try {
                tiePoints = (float[])this.readGridData(x, y, width, height).getElems();
            }
            catch (IOException e) {
                SystemUtils.LOG.severe("Unable to load TPG: " + e.getMessage());
            }
        }
        return tiePoints;
    }

    private ProductData readGridData(int x, int y, int width, int height) throws IOException {
        ProductData productData = this.createCompatibleRasterData(width, height);
        this.getProductReader().readTiePointGridRasterData(this, x, y, width, height, productData, ProgressMonitor.NULL);
        return productData;
    }

    @Override
    public int getRasterWidth() {
        if (this.getProduct() != null) {
            return this.getProduct().getSceneRasterWidth();
        }
        return (int)Math.round((double)(this.getGridWidth() - 1) * this.getSubSamplingX() + 1.0);
    }

    @Override
    public int getRasterHeight() {
        if (this.getProduct() != null) {
            return this.getProduct().getSceneRasterHeight();
        }
        return (int)Math.round((double)(this.getGridHeight() - 1) * this.getSubSamplingY() + 1.0);
    }

    public static int getDiscontinuity(float[] tiePoints) {
        Range range = Range.computeRangeFloat(tiePoints, IndexValidator.TRUE, null, ProgressMonitor.NULL);
        if (range.getMax() > 180.0) {
            return 360;
        }
        return 180;
    }

    public int getDiscontinuity() {
        return this.discontinuity;
    }

    public void setDiscontinuity(int discontinuity) {
        if (discontinuity != 0 && discontinuity != -1 && discontinuity != 180 && discontinuity != 360) {
            throw new IllegalArgumentException("unsupported discontinuity mode");
        }
        this.discontinuity = discontinuity;
    }

    @Override
    public boolean isFloatingPointType() {
        return true;
    }

    @Override
    public int getGeophysicalDataType() {
        return 30;
    }

    @Override
    public void setData(ProductData data) {
        super.setData(data);
        if (this.getDiscontinuity() == -1) {
            this.setDiscontinuity(TiePointGrid.getDiscontinuity((float[])data.getElems()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProductData getRasterData() {
        int width = this.getRasterWidth();
        int height = this.getRasterHeight();
        ProductData gridData = this.getGridData();
        if (gridData.getNumElems() == width * height) {
            return gridData;
        }
        if (this.rasterData == null) {
            TiePointGrid tiePointGrid = this;
            synchronized (tiePointGrid) {
                if (this.rasterData == null) {
                    this.rasterData = this.createCompatibleRasterData(width, height);
                    this.getPixels(0, 0, width, height, (float[])this.rasterData.getElems(), ProgressMonitor.NULL);
                }
            }
        }
        return this.rasterData;
    }

    @Override
    public void setRasterData(ProductData rasterData) throws UnsupportedOperationException {
        TiePointGrid.throwPixelsAreReadOnlyException();
    }

    @Override
    public int getPixelInt(int x, int y) {
        return (int)Math.round(this.getPixelDouble(x, y));
    }

    @Override
    public void dispose() {
        if (this.cosGrid != null) {
            this.cosGrid.dispose();
            this.cosGrid = null;
        }
        if (this.sinGrid != null) {
            this.sinGrid.dispose();
            this.sinGrid = null;
        }
        super.dispose();
    }

    @Override
    public float getPixelFloat(int x, int y) {
        return (float)this.getPixelDouble((float)x + 0.5f, (float)y + 0.5f);
    }

    public final float getPixelFloat(float x, float y) {
        return (float)this.getPixelDouble(x, y);
    }

    @Override
    public double getPixelDouble(int x, int y) {
        return this.getPixelDouble((double)x + 0.5, (double)y + 0.5);
    }

    public double getPixelDouble(double x, double y) {
        if (this.discontinuity != 0) {
            if (this.isDiscontNotInit()) {
                this.initDiscont();
            }
            double sinAngle = this.sinGrid.getPixelDouble(x, y);
            double cosAngle = this.cosGrid.getPixelDouble(x, y);
            double v = 57.29577951308232 * Math.atan2(sinAngle, cosAngle);
            if (this.discontinuity == 360 && v < 0.0) {
                return 360.0 + v;
            }
            return v;
        }
        double fi = (x - this.offsetX) / this.subSamplingX;
        double fj = (y - this.offsetY) / this.subSamplingY;
        int i = MathUtils.floorAndCrop(fi, 0, this.getGridWidth() - 2);
        int j = MathUtils.floorAndCrop(fj, 0, this.getGridHeight() - 2);
        return this.interpolate(fi - (double)i, fj - (double)j, i, j);
    }

    @Override
    public void setPixelInt(int x, int y, int pixelValue) {
        TiePointGrid.throwPixelsAreReadOnlyException();
    }

    @Override
    public void setPixelFloat(int x, int y, float pixelValue) {
        TiePointGrid.throwPixelsAreReadOnlyException();
    }

    @Override
    public void setPixelDouble(int x, int y, double pixelValue) {
        TiePointGrid.throwPixelsAreReadOnlyException();
    }

    @Override
    public int[] getPixels(int x, int y, int w, int h, int[] pixels, ProgressMonitor pm) {
        pixels = TiePointGrid.ensureMinLengthArray(pixels, w * h);
        double[] fpixels = this.getPixels(x, y, w, h, (double[])null, pm);
        for (int i = 0; i < fpixels.length; ++i) {
            pixels[i] = (int)Math.round(fpixels[i]);
        }
        return pixels;
    }

    @Override
    public double[] getPixels(int x, int y, int w, int h, double[] pixels, ProgressMonitor pm) {
        pixels = TiePointGrid.ensureMinLengthArray(pixels, w * h);
        if (this.discontinuity != 0) {
            if (this.isDiscontNotInit()) {
                this.initDiscont();
            }
            int i = 0;
            for (int yCoordinate = y; yCoordinate < y + h; ++yCoordinate) {
                for (int xCoordinate = x; xCoordinate < x + w; ++xCoordinate) {
                    pixels[i] = this.getPixelDouble(xCoordinate, yCoordinate);
                    ++i;
                }
            }
        } else {
            double x0 = 0.5 - this.offsetX;
            double y0 = 0.5 - this.offsetY;
            int x1 = x;
            int y1 = y;
            int x2 = x + w - 1;
            int y2 = y + h - 1;
            int ni = this.getGridWidth();
            int nj = this.getGridHeight();
            int pos = 0;
            for (y = y1; y <= y2; ++y) {
                double fj = ((double)y + y0) / this.subSamplingY;
                int j = MathUtils.floorAndCrop(fj, 0, nj - 2);
                double wj = fj - (double)j;
                for (x = x1; x <= x2; ++x) {
                    double fi = ((double)x + x0) / this.subSamplingX;
                    int i = MathUtils.floorAndCrop(fi, 0, ni - 2);
                    double wi = fi - (double)i;
                    pixels[pos++] = this.interpolate(wi, wj, i, j);
                }
            }
        }
        return pixels;
    }

    @Override
    public float[] getPixels(int x, int y, int w, int h, float[] pixels, ProgressMonitor pm) {
        pixels = TiePointGrid.ensureMinLengthArray(pixels, w * h);
        double[] fpixels = this.getPixels(x, y, w, h, (double[])null, pm);
        for (int i = 0; i < fpixels.length; ++i) {
            pixels[i] = (float)fpixels[i];
        }
        return pixels;
    }

    @Override
    public void setPixels(int x, int y, int w, int h, int[] pixels) {
        TiePointGrid.throwPixelsAreReadOnlyException();
    }

    @Override
    public void setPixels(int x, int y, int w, int h, float[] pixels) {
        TiePointGrid.throwPixelsAreReadOnlyException();
    }

    @Override
    public void setPixels(int x, int y, int w, int h, double[] pixels) {
        TiePointGrid.throwPixelsAreReadOnlyException();
    }

    @Override
    public int[] readPixels(int x, int y, int w, int h, int[] pixels, ProgressMonitor pm) throws IOException {
        return this.getPixels(x, y, w, h, pixels, pm);
    }

    @Override
    public float[] readPixels(int x, int y, int w, int h, float[] pixels, ProgressMonitor pm) throws IOException {
        return this.getPixels(x, y, w, h, pixels, pm);
    }

    @Override
    public double[] readPixels(int x, int y, int w, int h, double[] pixels, ProgressMonitor pm) throws IOException {
        return this.getPixels(x, y, w, h, pixels, pm);
    }

    @Override
    public void writePixels(int x, int y, int w, int h, int[] pixels, ProgressMonitor pm) throws IOException {
        TiePointGrid.throwPixelsAreReadOnlyException();
    }

    @Override
    public void writePixels(int x, int y, int w, int h, float[] pixels, ProgressMonitor pm) throws IOException {
        TiePointGrid.throwPixelsAreReadOnlyException();
    }

    @Override
    public void writePixels(int x, int y, int w, int h, double[] pixels, ProgressMonitor pm) throws IOException {
        TiePointGrid.throwPixelsAreReadOnlyException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readRasterData(int offsetX, int offsetY, int width, int height, ProductData rasterData, ProgressMonitor pm) throws IOException {
        ProductData src = this.getRasterData();
        int iDest = 0;
        pm.beginTask("Reading raster data...", height);
        try {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int iSrc = (offsetY + y) * width + (offsetX + x);
                    rasterData.setElemDoubleAt(iDest, src.getElemDoubleAt(iSrc));
                    ++iDest;
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    @Override
    public void readRasterDataFully(ProgressMonitor pm) throws IOException {
        this.getGridData();
    }

    @Override
    public void writeRasterData(int offsetX, int offsetY, int width, int height, ProductData rasterData, ProgressMonitor pm) throws IOException {
        TiePointGrid.throwPixelsAreReadOnlyException();
    }

    @Override
    public void writeRasterDataFully(ProgressMonitor pm) throws IOException {
        TiePointGrid.throwPixelsAreReadOnlyException();
    }

    @Override
    protected RenderedImage createSourceImage() {
        MultiLevelModel model = this.createMultiLevelModel();
        return new DefaultMultiLevelImage((MultiLevelSource)new AbstractMultiLevelSource(model){

            public RenderedImage createImage(int level) {
                return new TiePointGridOpImage(TiePointGrid.this, ResolutionLevel.create(this.getModel(), level));
            }
        });
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        Guardian.assertNotNull("visitor", visitor);
        visitor.visit(this);
    }

    public TiePointGrid cloneTiePointGrid() {
        float[] srcTiePoints = this.getTiePoints();
        float[] destTiePoints = new float[srcTiePoints.length];
        System.arraycopy(srcTiePoints, 0, destTiePoints, 0, srcTiePoints.length);
        TiePointGrid clone = new TiePointGrid(this.getName(), this.getGridWidth(), this.getGridHeight(), this.getOffsetX(), this.getOffsetY(), this.getSubSamplingX(), this.getSubSamplingY(), destTiePoints, this.getDiscontinuity());
        clone.setUnit(this.getUnit());
        clone.setDescription(this.getDescription());
        return clone;
    }

    public static TiePointGrid createZenithFromElevationAngleTiePointGrid(TiePointGrid elevationAngleGrid) {
        float[] elevationAngles = elevationAngleGrid.getTiePoints();
        float[] zenithAngles = new float[elevationAngles.length];
        for (int i = 0; i < zenithAngles.length; ++i) {
            zenithAngles[i] = 90.0f - elevationAngles[i];
        }
        return new TiePointGrid(elevationAngleGrid.getName(), elevationAngleGrid.getGridWidth(), elevationAngleGrid.getGridHeight(), elevationAngleGrid.getOffsetX(), elevationAngleGrid.getOffsetY(), elevationAngleGrid.getSubSamplingX(), elevationAngleGrid.getSubSamplingY(), zenithAngles);
    }

    private static void throwPixelsAreReadOnlyException() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("pixels are read-only in tie-point grids");
    }

    private double interpolate(double wi, double wj, int i0, int j0) {
        float[] tiePoints = this.getTiePoints();
        int w = this.getGridWidth();
        int i1 = i0 + 1;
        int j1 = j0 + 1;
        return MathUtils.interpolate2D(wi, wj, (double)tiePoints[i0 + j0 * w], (double)tiePoints[i1 + j0 * w], (double)tiePoints[i0 + j1 * w], (double)tiePoints[i1 + j1 * w]);
    }

    private boolean isDiscontNotInit() {
        return this.sinGrid == null || this.cosGrid == null;
    }

    private void initDiscont() {
        TiePointGrid base = this;
        float[] tiePoints = base.getTiePoints();
        float[] sinTiePoints = new float[tiePoints.length];
        float[] cosTiePoints = new float[tiePoints.length];
        for (int i = 0; i < tiePoints.length; ++i) {
            double tiePoint = tiePoints[i];
            sinTiePoints[i] = (float)Math.sin(Math.PI / 180 * tiePoint);
            cosTiePoints[i] = (float)Math.cos(Math.PI / 180 * tiePoint);
        }
        this.sinGrid = new TiePointGrid(base.getName(), base.getGridWidth(), base.getGridHeight(), base.getOffsetX(), base.getOffsetY(), base.getSubSamplingX(), base.getSubSamplingY(), sinTiePoints);
        this.cosGrid = new TiePointGrid(base.getName(), base.getGridWidth(), base.getGridHeight(), base.getOffsetX(), base.getOffsetY(), base.getSubSamplingX(), base.getSubSamplingY(), cosTiePoints);
    }

    protected static int[] ensureMinLengthArray(int[] array, int length) {
        if (array == null) {
            return new int[length];
        }
        if (array.length < length) {
            throw new IllegalArgumentException("The length of the given array is less than " + length);
        }
        return array;
    }

    protected static float[] ensureMinLengthArray(float[] array, int length) {
        if (array == null) {
            return new float[length];
        }
        if (array.length < length) {
            throw new IllegalArgumentException("The length of the given array is less than " + length);
        }
        return array;
    }

    protected static double[] ensureMinLengthArray(double[] array, int length) {
        if (array == null) {
            return new double[length];
        }
        if (array.length < length) {
            throw new IllegalArgumentException("The length of the given array is less than " + length);
        }
        return array;
    }

    public static TiePointGrid createSubset(TiePointGrid sourceTiePointGrid, ProductSubsetDef subsetDef) {
        int newTPGHeight;
        int srcTPGWidth = sourceTiePointGrid.getGridWidth();
        int srcTPGHeight = sourceTiePointGrid.getGridHeight();
        double srcTPGSubSamplingX = sourceTiePointGrid.getSubSamplingX();
        double srcTPGSubSamplingY = sourceTiePointGrid.getSubSamplingY();
        int subsetOffsetX = 0;
        int subsetOffsetY = 0;
        int subsetStepX = 1;
        int subsetStepY = 1;
        int srcRasterWidth = sourceTiePointGrid.getRasterWidth();
        int srcRasterHeight = sourceTiePointGrid.getRasterHeight();
        int subsetWidth = srcRasterWidth;
        int subsetHeight = srcRasterHeight;
        if (subsetDef != null) {
            subsetStepX = subsetDef.getSubSamplingX();
            subsetStepY = subsetDef.getSubSamplingY();
            if (subsetDef.getRegionMap() != null && subsetDef.getRegionMap().containsKey(sourceTiePointGrid.getName())) {
                subsetOffsetX = subsetDef.getRegionMap().get((Object)sourceTiePointGrid.getName()).x;
                subsetOffsetY = subsetDef.getRegionMap().get((Object)sourceTiePointGrid.getName()).y;
                subsetWidth = subsetDef.getRegionMap().get((Object)sourceTiePointGrid.getName()).width;
                subsetHeight = subsetDef.getRegionMap().get((Object)sourceTiePointGrid.getName()).height;
            } else if (subsetDef.getRegion() != null) {
                subsetOffsetX = subsetDef.getRegion().x;
                subsetOffsetY = subsetDef.getRegion().y;
                subsetWidth = subsetDef.getRegion().width;
                subsetHeight = subsetDef.getRegion().height;
            }
        }
        double newTPGSubSamplingX = srcTPGSubSamplingX / (double)subsetStepX;
        double newTPGSubSamplingY = srcTPGSubSamplingY / (double)subsetStepY;
        float pixelCenter = 0.5f;
        double newTPGOffsetX = (sourceTiePointGrid.getOffsetX() - 0.5 - (double)subsetOffsetX) / (double)subsetStepX + 0.5;
        double newTPGOffsetY = (sourceTiePointGrid.getOffsetY() - 0.5 - (double)subsetOffsetY) / (double)subsetStepY + 0.5;
        double newOffsetX = newTPGOffsetX % newTPGSubSamplingX;
        double newOffsetY = newTPGOffsetY % newTPGSubSamplingY;
        double diffX = newOffsetX - newTPGOffsetX;
        double diffY = newOffsetY - newTPGOffsetY;
        int dataOffsetX = diffX < 0.0 ? 0 : (int)Math.round(diffX / newTPGSubSamplingX);
        int dataOffsetY = diffY < 0.0 ? 0 : (int)Math.round(diffY / newTPGSubSamplingY);
        int newTPGWidth = (int)Math.ceil((double)subsetWidth / srcTPGSubSamplingX) + 2;
        if (dataOffsetX + newTPGWidth > srcTPGWidth) {
            newTPGWidth = srcTPGWidth - dataOffsetX;
        }
        if (dataOffsetY + (newTPGHeight = (int)Math.ceil((double)subsetHeight / srcTPGSubSamplingY) + 2) > srcTPGHeight) {
            newTPGHeight = srcTPGHeight - dataOffsetY;
        }
        float[] tiePoints = sourceTiePointGrid.getTiePoints(dataOffsetX, dataOffsetY, newTPGWidth, newTPGHeight);
        TiePointGrid tiePointGrid = new TiePointGrid(sourceTiePointGrid.getName(), newTPGWidth, newTPGHeight, newOffsetX, newOffsetY, newTPGSubSamplingX, newTPGSubSamplingY, tiePoints);
        tiePointGrid.setUnit(sourceTiePointGrid.getUnit());
        tiePointGrid.setDescription(sourceTiePointGrid.getDescription());
        tiePointGrid.setDiscontinuity(sourceTiePointGrid.getDiscontinuity());
        return tiePointGrid;
    }
}

