/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import org.esa.snap.core.datamodel.AngularDirection;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Pointing;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.Guardian;

public final class TiePointGridPointing
implements Pointing {
    private final GeoCoding _geoCoding;
    private final TiePointGrid _szGrid;
    private final TiePointGrid _saGrid;
    private final TiePointGrid _vzGrid;
    private final TiePointGrid _vaGrid;
    private final TiePointGrid _elGrid;

    public TiePointGridPointing(GeoCoding geoCoding, TiePointGrid szGrid, TiePointGrid saGrid, TiePointGrid vzGrid, TiePointGrid vaGrid, TiePointGrid elGrid) {
        Guardian.assertNotNull("geoCoding", geoCoding);
        this._geoCoding = geoCoding;
        this._szGrid = szGrid;
        this._saGrid = saGrid;
        this._vzGrid = vzGrid;
        this._vaGrid = vaGrid;
        this._elGrid = elGrid;
    }

    @Override
    public final GeoCoding getGeoCoding() {
        return this._geoCoding;
    }

    @Override
    public final AngularDirection getSunDir(PixelPos pixelPos, AngularDirection sd) {
        if (this.canGetSunDir()) {
            if (sd == null) {
                sd = new AngularDirection();
            }
            sd.azimuth = this._saGrid.getPixelDouble(pixelPos.x, pixelPos.y);
            sd.zenith = this._szGrid.getPixelDouble(pixelPos.x, pixelPos.y);
        }
        return sd;
    }

    @Override
    public final AngularDirection getViewDir(PixelPos pixelPos, AngularDirection vd) {
        if (this.canGetViewDir()) {
            if (vd == null) {
                vd = new AngularDirection();
            }
            vd.azimuth = this._vaGrid.getPixelDouble(pixelPos.x, pixelPos.y);
            vd.zenith = this._vzGrid.getPixelDouble(pixelPos.x, pixelPos.y);
        }
        return vd;
    }

    @Override
    public double getElevation(PixelPos pixelPos) {
        return this.canGetElevation() ? this._elGrid.getPixelDouble(pixelPos.x, pixelPos.y) : 0.0;
    }

    @Override
    public final boolean canGetElevation() {
        return this._elGrid != null;
    }

    @Override
    public final boolean canGetSunDir() {
        return this._szGrid != null && this._saGrid != null;
    }

    @Override
    public final boolean canGetViewDir() {
        return this._vzGrid != null && this._vaGrid != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Pointing) {
            Pointing other = (Pointing)obj;
            return this.getGeoCoding().equals(other.getGeoCoding());
        }
        return false;
    }

    public int hashCode() {
        return this.getGeoCoding().hashCode();
    }
}

