/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.lang.ref.WeakReference;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.VectorDataMaskOpImage;
import org.geotools.geometry.jts.ReferencedEnvelope;

class VectorDataMultiLevelImage
extends DefaultMultiLevelImage
implements ProductNodeListener {
    private final WeakReference<VectorDataNode> vectorDataReference;

    static VectorDataMultiLevelImage createMaskImage(final VectorDataNode vectorDataNode, final RasterDataNode associatedNode) {
        MultiLevelModel multiLevelModel = associatedNode.getMultiLevelModel();
        AbstractMultiLevelSource multiLevelSource = new AbstractMultiLevelSource(multiLevelModel){

            public RenderedImage createImage(int level) {
                return new VectorDataMaskOpImage(vectorDataNode, associatedNode, ResolutionLevel.create(this.getModel(), level));
            }
        };
        return new VectorDataMultiLevelImage((MultiLevelSource)multiLevelSource, vectorDataNode){

            public void reset() {
                super.reset();
                associatedNode.fireProductNodeDataChanged();
            }
        };
    }

    VectorDataMultiLevelImage(MultiLevelSource multiLevelSource, VectorDataNode vectorDataNode) {
        super(multiLevelSource);
        this.vectorDataReference = new WeakReference<VectorDataNode>(vectorDataNode);
        vectorDataNode.getProduct().addProductNodeListener(this);
    }

    public Shape getImageShape(int level) {
        ReferencedEnvelope envelope;
        VectorDataNode vectorDataNode = (VectorDataNode)((Object)this.vectorDataReference.get());
        if (vectorDataNode != null && !(envelope = vectorDataNode.getEnvelope()).isEmpty()) {
            Rectangle2D.Double modelBounds = new Rectangle2D.Double(envelope.getMinX(), envelope.getMinY(), envelope.getWidth(), envelope.getHeight());
            AffineTransform m2i = this.getModel().getModelToImageTransform(level);
            return m2i.createTransformedShape(modelBounds);
        }
        return null;
    }

    public void dispose() {
        Product product;
        VectorDataNode vectorDataNode = (VectorDataNode)((Object)this.vectorDataReference.get());
        if (vectorDataNode != null && (product = vectorDataNode.getProduct()) != null) {
            product.removeProductNodeListener(this);
        }
        this.vectorDataReference.clear();
        super.dispose();
    }

    @Override
    public void nodeChanged(ProductNodeEvent event) {
        if (event.getSourceNode() == this.vectorDataReference.get() && event.getPropertyName().equals("featureCollection")) {
            this.reset();
        }
    }

    @Override
    public void nodeDataChanged(ProductNodeEvent event) {
    }

    @Override
    public void nodeAdded(ProductNodeEvent event) {
    }

    @Override
    public void nodeRemoved(ProductNodeEvent event) {
    }

    VectorDataNode getVectorDataNode() {
        return (VectorDataNode)((Object)this.vectorDataReference.get());
    }
}

