/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.jexp.Term;

class VirtualBandMultiLevelImage
extends DefaultMultiLevelImage
implements ProductNodeListener {
    private Term term;
    private final WeakHashSet<Product> referencedProducts;
    private final WeakHashSet<RasterDataNode> referencedRasters;

    VirtualBandMultiLevelImage(MultiLevelSource multiLevelSource, Term term) {
        super(multiLevelSource);
        Assert.notNull((Object)multiLevelSource, (String)"multiLevelSource");
        this.referencedProducts = new WeakHashSet();
        this.referencedRasters = new WeakHashSet();
        this.term = term;
        this.addTermNodes();
    }

    public Term getTerm() {
        return this.term;
    }

    public void setTerm(Term term) {
        Assert.notNull((Object)term, (String)"term");
        if (this.term != term) {
            this.removeTermNodes();
            this.term = term;
            this.addTermNodes();
        }
    }

    public void dispose() {
        this.removeTermNodes();
        this.term = null;
        super.dispose();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.term != null) {
            this.dispose();
        }
    }

    @Override
    public void nodeDataChanged(ProductNodeEvent event) {
        RasterDataNode rasterDataNode;
        ProductNode sourceNode = event.getSourceNode();
        if (sourceNode instanceof RasterDataNode && this.referencedRasters.contains(rasterDataNode = (RasterDataNode)sourceNode)) {
            this.reset();
        }
    }

    @Override
    public void nodeChanged(ProductNodeEvent event) {
    }

    @Override
    public void nodeAdded(ProductNodeEvent event) {
    }

    @Override
    public void nodeRemoved(ProductNodeEvent event) {
    }

    Set<Product> getReferencedProducts() {
        return this.referencedProducts;
    }

    Set<RasterDataNode> getReferencedRasters() {
        return this.referencedRasters;
    }

    private void addTermNodes() {
        RasterDataNode[] refRasters = BandArithmetic.getRefRasters(this.term);
        for (RasterDataNode refRaster : refRasters) {
            this.referencedProducts.add(refRaster.getProduct());
            this.referencedRasters.add(refRaster);
        }
        for (Product referencedProduct : this.referencedProducts) {
            referencedProduct.addProductNodeListener(this);
        }
    }

    private void removeTermNodes() {
        for (Product referencedProduct : this.referencedProducts) {
            referencedProduct.removeProductNodeListener(this);
        }
        this.referencedProducts.clear();
        this.referencedRasters.clear();
    }

    private static class WeakHashSet<E>
    extends AbstractSet<E> {
        private static final Object PRESENT = new Object();
        private final WeakHashMap<E, Object> map = new WeakHashMap();

        private WeakHashSet() {
        }

        @Override
        public Iterator<E> iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean add(E e) {
            return this.map.put(e, PRESENT) == null;
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) == PRESENT;
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

