/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel.quicklooks;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import net.coobird.thumbnailator.makers.FixedSizeThumbnailMaker;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Config;

public class QuicklookGenerator {
    public static final String PREFERENCE_KEY_QUICKLOOKS_SAVE_WITH_PRODUCT = "quicklooks.save.with.product";
    public static final String PREFERENCE_KEY_QUICKLOOKS_MAX_WIDTH = "quicklooks.max.width";
    public static final boolean DEFAULT_VALUE_QUICKLOOKS_SAVE_WITH_PRODUCT = true;
    public static final int DEFAULT_VALUE_QUICKLOOKS_MAX_WIDTH = 300;
    private static final int MULTILOOK_FACTOR = 2;
    private static final double DTOR = Math.PI / 180;
    private static final RGBImageProfile[] registeredProfiles = RGBImageProfileManager.getInstance().getAllProfiles();
    private static final String[] defaultQuickLookBands = new String[]{"intensity", "band", "sigma0", "t11", "t22", "t33", "c11", "c22", "c33"};
    private final int maxWidth;

    public QuicklookGenerator() {
        Preferences preferences = Config.instance().preferences();
        this.maxWidth = preferences.getInt(PREFERENCE_KEY_QUICKLOOKS_MAX_WIDTH, 300);
    }

    public BufferedImage createQuickLookFromBrowseProduct(Product browseProduct) throws IOException {
        BufferedImage image;
        if (browseProduct.getNumBands() < 3) {
            image = ProductUtils.createColorIndexedImage(browseProduct.getBandAt(0), ProgressMonitor.NULL);
        } else {
            ArrayList<Band> bandList = new ArrayList<Band>(3);
            for (int i = 0; i < Math.min(3, browseProduct.getNumBands()); ++i) {
                Band band = browseProduct.getBandAt(i);
                if (band.getStx().getMean() == 0.0) continue;
                bandList.add(band);
            }
            RasterDataNode[] bands = bandList.toArray(new Band[bandList.size()]);
            if (bands.length < 3) {
                image = ProductUtils.createColorIndexedImage(bands[0], ProgressMonitor.NULL);
            } else {
                ImageInfo imageInfo = ProductUtils.createImageInfo(bands, true, ProgressMonitor.NULL);
                image = ProductUtils.createRgbImage(bands, imageInfo, ProgressMonitor.NULL);
            }
        }
        return new FixedSizeThumbnailMaker().size(this.maxWidth, this.maxWidth).keepAspectRatio(true).fitWithinDimensions(true).make(image);
    }

    public BufferedImage createQuickLookImage(Product product, Band[] quicklookBands, ProgressMonitor pm) throws IOException {
        BufferedImage image;
        Product productSubset = product;
        boolean subsample = true;
        int width = this.maxWidth * 2;
        ProductSubsetDef productSubsetDef = new ProductSubsetDef("subset");
        int scaleFactor = Math.round((float)Math.max(product.getSceneRasterWidth(), product.getSceneRasterHeight()) / (float)width);
        if (scaleFactor < 1) {
            scaleFactor = 1;
        }
        productSubsetDef.setSubSampling(scaleFactor, scaleFactor);
        productSubset = product.createSubset(productSubsetDef, null, null);
        ArrayList<Band> bandList = new ArrayList<Band>();
        for (Band band : quicklookBands) {
            if (productSubset.getBand(band.getName()) != null) {
                bandList.add(productSubset.getBand(band.getName()));
                continue;
            }
            if (!(band instanceof VirtualBand)) continue;
            ProductUtils.copyVirtualBand(productSubset, (VirtualBand)band, band.getName());
            bandList.add(productSubset.getBand(band.getName()));
        }
        quicklookBands = bandList.toArray(new Band[bandList.size()]);
        if (quicklookBands.length < 3 && quicklookBands[0].getIndexCoding() != null) {
            image = ProductUtils.createColorIndexedImage(quicklookBands[0], ProgressMonitor.NULL);
        } else {
            ImageInfo imageInfo = ProductUtils.createImageInfo(quicklookBands, true, SubProgressMonitor.create((ProgressMonitor)pm, (int)20));
            image = ProductUtils.createRgbImage(quicklookBands, imageInfo, SubProgressMonitor.create((ProgressMonitor)pm, (int)80));
        }
        productSubset.dispose();
        return new FixedSizeThumbnailMaker().size(this.maxWidth, this.maxWidth).keepAspectRatio(true).fitWithinDimensions(true).make(image);
    }

    public static Band[] findQuicklookBands(Product product) {
        Band[] rgbBands = QuicklookGenerator.findSuitableRGBProfileBands(product);
        if (rgbBands != null && rgbBands.length > 0) {
            return rgbBands;
        }
        String bandName = product.getQuicklookBandName();
        if (bandName != null && product.containsBand(bandName)) {
            return new Band[]{product.getBand(bandName)};
        }
        String[] bandNames = product.getBandNames();
        ArrayList<Band> bandList = new ArrayList<Band>(3);
        for (String name : bandNames) {
            name = name.toLowerCase();
            for (String qlBand : defaultQuickLookBands) {
                if (!name.startsWith(qlBand)) continue;
                bandList.add(product.getBand(name));
                break;
            }
            if (bandList.size() <= 2) continue;
            return bandList.toArray(new Band[bandList.size()]);
        }
        String quicklookBandName = ProductUtils.findSuitableQuicklookBandName(product);
        if (bandList.size() > 1 && !((Band)bandList.get(0)).getName().equals(quicklookBandName)) {
            return bandList.toArray(new Band[bandList.size()]);
        }
        if (quicklookBandName == null) {
            return null;
        }
        return new Band[]{product.getBand(quicklookBandName)};
    }

    private static Band[] findSuitableRGBProfileBands(Product product) {
        if (product.isMultiSize()) {
            return null;
        }
        for (RGBImageProfile profile : registeredProfiles) {
            if (!profile.isApplicableTo(product)) continue;
            Band r = QuicklookGenerator.createBand(product, "r", profile.getRedExpression());
            Band g = QuicklookGenerator.createBand(product, "g", profile.getGreenExpression());
            Band b = QuicklookGenerator.createBand(product, "b", profile.getBlueExpression());
            return new Band[]{r, g, b};
        }
        return null;
    }

    private static Dimension determineDimensions(Product product, String expression) {
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        try {
            RasterDataNode[] refRasters;
            if (product.isMultiSize() && (refRasters = BandArithmetic.getRefRasters(expression, product)).length > 0) {
                width = refRasters[0].getRasterWidth();
                height = refRasters[0].getRasterHeight();
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid expression: " + expression);
        }
        return new Dimension(width, height);
    }

    private static Band createBand(Product product, String name, String expression) {
        Band band = product.getBand(expression);
        if (band == null) {
            Dimension dim = QuicklookGenerator.determineDimensions(product, expression);
            band = new VirtualBand(name, 30, dim.width, dim.height, expression);
            band.setOwner(product);
            band.setModified(false);
        }
        return band;
    }

    private static Band average(Product product, Band srcBand, ProgressMonitor pm) {
        int rangeFactor = 2;
        int azimuthFactor = 2;
        int rangeAzimuth = rangeFactor * azimuthFactor;
        int srcW = srcBand.getRasterWidth();
        int srcH = srcBand.getRasterHeight();
        int w = srcW / rangeFactor;
        int h = srcH / azimuthFactor;
        int index = 0;
        float[] data = new float[w * h];
        try {
            boolean bandAddedToProduct = false;
            if (product.getBand(srcBand.getName()) == null) {
                product.addBand(srcBand);
                bandAddedToProduct = true;
            }
            float[] floatValues = new float[srcW * srcH];
            srcBand.readPixels(0, 0, srcW, srcH, floatValues, pm);
            for (int ty = 0; ty < h; ++ty) {
                int yStart = ty * azimuthFactor;
                int yEnd = yStart + azimuthFactor;
                for (int tx = 0; tx < w; ++tx) {
                    int xStart = tx * rangeFactor;
                    int xEnd = xStart + rangeFactor;
                    double meanValue = 0.0;
                    for (int y = yStart; y < yEnd; ++y) {
                        for (int x = xStart; x < xEnd; ++x) {
                            meanValue += (double)floatValues[y * srcW + x];
                        }
                    }
                    data[index++] = (float)(meanValue /= (double)rangeAzimuth);
                }
            }
            if (bandAddedToProduct) {
                product.removeBand(srcBand);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Band b = new Band("averaged", 30, w, h);
        b.setData(ProductData.createInstance(data));
        return b;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static BufferedImage loadImage(File quickLookFile) {
        if (!quickLookFile.exists()) return null;
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(quickLookFile));){
            BufferedImage bufferedImage = ImageIO.read(fis);
            return bufferedImage;
        }
        catch (Exception e) {
            SystemUtils.LOG.severe("Unable to load quicklook: " + quickLookFile);
        }
        return null;
    }

    public static boolean writeImage(BufferedImage bufferedImage, File quickLookFile) {
        try {
            QuicklookGenerator.touch(quickLookFile);
            ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
            ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
            ImageOutputStream outputStream = ImageIO.createImageOutputStream(quickLookFile);
            jpgWriter.setOutput(outputStream);
            IIOImage outputImage = new IIOImage(QuicklookGenerator.ensureOpaque(bufferedImage), null, null);
            jpgWriter.write(null, outputImage, jpgWriteParam);
            jpgWriter.dispose();
            return true;
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Unable to save quicklook: " + quickLookFile + " " + e.getMessage());
            return false;
        }
    }

    static BufferedImage ensureOpaque(BufferedImage bi) {
        if (bi.getTransparency() == 1) {
            return bi;
        }
        int w = bi.getWidth();
        int h = bi.getHeight();
        int[] pixels = new int[w * h];
        bi.getRGB(0, 0, w, h, pixels, 0, w);
        BufferedImage bi2 = new BufferedImage(w, h, 1);
        bi2.setRGB(0, 0, w, h, pixels, 0, w);
        return bi2;
    }

    private static void touch(File file) throws IOException {
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            new FileOutputStream(file).close();
        } else {
            file.setLastModified(System.currentTimeMillis());
        }
    }
}

