/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel.quicklooks;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.Product;

public interface Thumbnail {
    public static final List<ThumbnailListener> listenerList = new ArrayList<ThumbnailListener>();

    public boolean hasImage();

    public boolean hasCachedImage();

    public BufferedImage getImage(ProgressMonitor var1);

    public Product getProduct();

    default public void addListener(ThumbnailListener listener) {
        if (!listenerList.contains(listener)) {
            listenerList.add(listener);
        }
    }

    default public void removeListener(ThumbnailListener listener) {
        listenerList.remove(listener);
    }

    default public void notifyImageUpdated() {
        for (ThumbnailListener listener : listenerList) {
            listener.notifyImageUpdated(this);
        }
    }

    public static interface ThumbnailListener {
        public void notifyImageUpdated(Thumbnail var1);
    }
}

