/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.barithm;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ServiceLoader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.barithm.ProductNamespaceExtender;
import org.esa.snap.core.dataop.barithm.RasterDataEvalEnv;
import org.esa.snap.core.dataop.barithm.RasterDataSymbol;
import org.esa.snap.core.dataop.barithm.SingleFlagSymbol;
import org.esa.snap.core.jexp.EvalEnv;
import org.esa.snap.core.jexp.EvalException;
import org.esa.snap.core.jexp.WritableNamespace;
import org.esa.snap.core.jexp.impl.AbstractSymbol;
import org.esa.snap.core.jexp.impl.SymbolFactory;
import org.esa.snap.core.util.ProductUtils;

class ProductNamespaceExtenderImpl
implements ProductNamespaceExtender {
    public static final String PIXEL_X_SYMBOL = "X";
    public static final String PIXEL_Y_SYMBOL = "Y";
    public static final String PIXEL_LAT_SYMBOL = "LAT";
    public static final String PIXEL_LON_SYMBOL = "LON";
    public static final String PIXEL_TIME_SYMBOL = "TIME";
    public static final String[] COMMON_PRODUCT_SYMBOLS = new String[]{"X", "Y", "LAT", "LON", "TIME"};
    public static final GeoPos INVALID_GEO_POS = new GeoPos(Double.NaN, Double.NaN);

    ProductNamespaceExtenderImpl() {
    }

    @Override
    public void extendNamespace(Product product, String namePrefix, WritableNamespace namespace) {
        ProductNamespaceExtenderImpl.registerPixelSymbols(product, namePrefix, namespace);
        ProductNamespaceExtenderImpl.registerTiePointGridSymbols(product, namePrefix, namespace);
        ProductNamespaceExtenderImpl.registerBandSymbols(product, namePrefix, namespace);
        ProductNamespaceExtenderImpl.registerMaskSymbols(product, namePrefix, namespace);
        ProductNamespaceExtenderImpl.registerSingleFlagSymbols(product, namePrefix, namespace);
        ProductNamespaceExtenderImpl.registerBandProperties(product, namePrefix, namespace);
        ProductNamespaceExtenderImpl.callServiceProviders(product, namePrefix, namespace);
    }

    private static void registerTiePointGridSymbols(Product product, String namePrefix, WritableNamespace namespace) {
        for (int i = 0; i < product.getNumTiePointGrids(); ++i) {
            TiePointGrid grid = product.getTiePointGridAt(i);
            String symbolName = namePrefix + grid.getName();
            namespace.registerSymbol(new RasterDataSymbol(symbolName, grid, RasterDataSymbol.GEOPHYSICAL));
        }
    }

    private static void registerBandSymbols(Product product, String namePrefix, WritableNamespace namespace) {
        for (int i = 0; i < product.getNumBands(); ++i) {
            Band band = product.getBandAt(i);
            String symbolName = namePrefix + band.getName();
            namespace.registerSymbol(new RasterDataSymbol(symbolName, band, RasterDataSymbol.GEOPHYSICAL));
            namespace.registerSymbol(new RasterDataSymbol(symbolName + ".raw", band, RasterDataSymbol.RAW));
        }
    }

    private static void registerMaskSymbols(Product product, String namePrefix, WritableNamespace namespace) {
        for (int i = 0; i < product.getMaskGroup().getNodeCount(); ++i) {
            Mask mask = product.getMaskGroup().get(i);
            String symbolName = namePrefix + mask.getName();
            namespace.registerSymbol(new RasterDataSymbol(symbolName, mask));
        }
    }

    private static void registerSingleFlagSymbols(Product product, String namePrefix, WritableNamespace namespace) {
        for (int i = 0; i < product.getNumBands(); ++i) {
            Band band = product.getBandAt(i);
            if (band.getFlagCoding() == null) continue;
            for (int j = 0; j < band.getFlagCoding().getNumAttributes(); ++j) {
                int flagValue;
                int flagMask;
                MetadataAttribute attribute = band.getFlagCoding().getAttributeAt(j);
                ProductData flagData = attribute.getData();
                if (flagData.getNumElems() == 2) {
                    flagMask = flagData.getElemIntAt(0);
                    flagValue = flagData.getElemIntAt(1);
                } else {
                    flagMask = flagValue = flagData.getElemInt();
                }
                String symbolName = namePrefix + band.getName() + "." + attribute.getName();
                SingleFlagSymbol symbol = new SingleFlagSymbol(symbolName, band, flagMask, flagValue);
                namespace.registerSymbol(symbol);
            }
        }
    }

    private static void registerBandProperties(Product product, String namePrefix, WritableNamespace namespace) {
        int numBands = product.getNumBands();
        for (int i = 0; i < numBands; ++i) {
            Band band = product.getBandAt(i);
            ProductNamespaceExtenderImpl.registerBandProperties(namespace, band, namePrefix);
        }
    }

    private static void registerPixelSymbols(Product product, String namePrefix, WritableNamespace namespace) {
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        namespace.registerSymbol(new PixelXSymbol(namePrefix + PIXEL_X_SYMBOL));
        namespace.registerSymbol(new PixelYSymbol(namePrefix + PIXEL_Y_SYMBOL));
        namespace.registerSymbol(new PixelLatSymbol(namePrefix + PIXEL_LAT_SYMBOL, product.getSceneGeoCoding(), width, height));
        namespace.registerSymbol(new PixelLonSymbol(namePrefix + PIXEL_LON_SYMBOL, product.getSceneGeoCoding(), width, height));
        namespace.registerSymbol(new PixelTimeSymbol(namePrefix + PIXEL_TIME_SYMBOL, product));
        namespace.registerSymbol(new PixelTimeSymbol(namePrefix + "MJD", product));
    }

    private static void registerBandProperties(WritableNamespace namespace, Band band, String namePrefix) {
        Method[] declaredMethods;
        Class<?> bandClass = band.getClass();
        for (Method method : declaredMethods = bandClass.getDeclaredMethods()) {
            String methodName = method.getName();
            Class<?> methodType = method.getReturnType();
            if (!methodType.isPrimitive() || !ProductNamespaceExtenderImpl.hasGetterPrefix(methodName) || method.getParameterTypes().length != 0) continue;
            Object propertyValue = null;
            try {
                propertyValue = method.invoke((Object)band, (Object[])null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (propertyValue == null) continue;
            String propertyName = ProductNamespaceExtenderImpl.convertMethodNameToPropertyName(methodName);
            String symbolName = band.getName() + "." + propertyName;
            ProductNamespaceExtenderImpl.registerPropertyConstant(namespace, namePrefix + symbolName, propertyValue);
        }
    }

    private static void registerPropertyConstant(WritableNamespace namespace, String symbolName, Object propertyValue) {
        Class<?> getterType = propertyValue.getClass();
        if (getterType.equals(Double.class) || getterType.equals(Float.class)) {
            namespace.registerSymbol(SymbolFactory.createConstant(symbolName, ((Number)propertyValue).doubleValue()));
        } else if (getterType.equals(Byte.class) || getterType.equals(Short.class) || getterType.equals(Integer.class) || getterType.equals(Long.class)) {
            namespace.registerSymbol(SymbolFactory.createConstant(symbolName, ((Number)propertyValue).intValue()));
        } else if (getterType.equals(Boolean.class)) {
            namespace.registerSymbol(SymbolFactory.createConstant(symbolName, (Boolean)propertyValue));
        }
    }

    private static void callServiceProviders(Product product, String namePrefix, WritableNamespace namespace) {
        ServiceLoader<ProductNamespaceExtender> namespaceExtenders = ServiceLoader.load(ProductNamespaceExtender.class);
        for (ProductNamespaceExtender namespaceExtender : namespaceExtenders) {
            namespaceExtender.extendNamespace(product, namePrefix, namespace);
        }
    }

    private static String convertMethodNameToPropertyName(String s) {
        int skipCount = 0;
        if (s.startsWith("is")) {
            skipCount = 2;
        } else if (s.startsWith("get")) {
            skipCount = 3;
        }
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (i < skipCount) continue;
            if (i < n - 1) {
                char c1 = s.charAt(i);
                char c2 = s.charAt(i + 1);
                sb.append(Character.toLowerCase(c1));
                if (!Character.isLowerCase(c1) || !Character.isUpperCase(c2)) continue;
                sb.append('_');
                continue;
            }
            sb.append(Character.toLowerCase(s.charAt(i)));
        }
        return sb.toString();
    }

    private static boolean hasGetterPrefix(String methodName) {
        return ProductNamespaceExtenderImpl.hasPrefix(methodName, "is") || ProductNamespaceExtenderImpl.hasPrefix(methodName, "get");
    }

    private static boolean hasPrefix(String methodName, String prefix) {
        return methodName.startsWith(prefix) && methodName.length() > prefix.length();
    }

    static final class PixelLatSymbol
    extends PixelGeoPosSymbol {
        PixelLatSymbol(String name, GeoCoding geocoding, int width, int height) {
            super(name, geocoding, width, height);
        }

        @Override
        protected double getCoord(GeoPos geoPos) {
            return geoPos.lat;
        }
    }

    static final class PixelLonSymbol
    extends PixelGeoPosSymbol {
        PixelLonSymbol(String name, GeoCoding geocoding, int width, int height) {
            super(name, geocoding, width, height);
        }

        @Override
        protected double getCoord(GeoPos geoPos) {
            return geoPos.lon;
        }
    }

    static abstract class PixelGeoPosSymbol
    extends AbstractSymbol.D {
        private final WeakReference<GeoCoding> geocodingRef;
        private final int width;
        private final int height;

        protected PixelGeoPosSymbol(String name, GeoCoding geocoding, int width, int height) {
            super(name);
            this.geocodingRef = new WeakReference<GeoCoding>(geocoding);
            this.width = width;
            this.height = height;
        }

        @Override
        public double evalD(EvalEnv env) throws EvalException {
            GeoPos geoPos;
            double coord = Double.NaN;
            GeoCoding geoCoding = (GeoCoding)this.geocodingRef.get();
            if (geoCoding != null && geoCoding.canGetGeoPos() && (geoPos = PixelGeoPosSymbol.getGeoPos(geoCoding, env, this.width, this.height)).isValid()) {
                coord = this.getCoord(geoPos);
            }
            return coord;
        }

        private static GeoPos getGeoPos(GeoCoding geoCoding, EvalEnv env, int width, int height) {
            RasterDataEvalEnv rasterEnv = (RasterDataEvalEnv)env;
            int pixelX = rasterEnv.getPixelX();
            int pixelY = rasterEnv.getPixelY();
            if (pixelX >= 0 && pixelX < width && pixelY >= 0 && pixelY < height) {
                return geoCoding.getGeoPos(new PixelPos((float)pixelX + 0.5f, (float)pixelY + 0.5f), null);
            }
            return INVALID_GEO_POS;
        }

        protected abstract double getCoord(GeoPos var1);
    }

    static final class PixelTimeSymbol
    extends AbstractSymbol.D {
        private final WeakReference<Product> productRef;

        PixelTimeSymbol(String name, Product product) {
            super(name);
            this.productRef = new WeakReference<Product>(product);
        }

        @Override
        public double evalD(EvalEnv env) throws EvalException {
            int pixelY;
            ProductData.UTC scanLineTime;
            Product product = (Product)((Object)this.productRef.get());
            if (product != null && (scanLineTime = ProductUtils.getScanLineTime(product, pixelY = ((RasterDataEvalEnv)env).getPixelY())) != null) {
                return scanLineTime.getMJD();
            }
            return Double.NaN;
        }
    }

    static final class PixelYSymbol
    extends AbstractSymbol.D {
        public PixelYSymbol(String name) {
            super(name);
        }

        @Override
        public double evalD(EvalEnv env) throws EvalException {
            return (double)((RasterDataEvalEnv)env).getPixelY() + 0.5;
        }
    }

    static final class PixelXSymbol
    extends AbstractSymbol.D {
        public PixelXSymbol(String name) {
            super(name);
        }

        @Override
        public double evalD(EvalEnv env) throws EvalException {
            return (double)((RasterDataEvalEnv)env).getPixelX() + 0.5;
        }
    }
}

