/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.dem;

import com.bc.ceres.core.ProgressMonitor;
import java.util.Arrays;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.dem.ElevationTile;
import org.esa.snap.runtime.Config;

public class BaseElevationTile
implements ElevationTile {
    protected final ElevationModel demModel;
    protected Product product;
    private final Band band;
    private int bandWidth;
    private int bandHeight;
    protected final float noDataValue;
    private final float[][] objectArray;
    private final boolean useDEMGravitationalModel;

    public BaseElevationTile(ElevationModel demModel, Product product) {
        this.demModel = demModel;
        this.product = product;
        this.band = product.getBandAt(0);
        this.bandWidth = this.band.getRasterWidth();
        this.bandHeight = this.band.getRasterHeight();
        this.noDataValue = demModel.getDescriptor().getNoDataValue();
        this.objectArray = new float[this.band.getRasterHeight() + 1][];
        this.useDEMGravitationalModel = Config.instance().preferences().getBoolean("snap.useDEMGravitationalModel", true);
    }

    public void setWidth(int newWidth) {
        this.bandWidth = newWidth;
    }

    public void setHeight(int newHeight) {
        this.bandHeight = newHeight;
    }

    @Override
    public final void clearCache() {
        if (this.objectArray != null) {
            Arrays.fill((Object[])this.objectArray, 0, this.objectArray.length, null);
        }
    }

    @Override
    public final float getSample(int pixelX, int pixelY) throws Exception {
        float[] line = this.objectArray[pixelY];
        if (line == null) {
            line = this.band.readPixels(0, pixelY, this.bandWidth, 1, new float[this.bandWidth], ProgressMonitor.NULL);
            if (this.useDEMGravitationalModel) {
                this.addGravitationalModel(pixelY, line);
            }
            this.objectArray[pixelY] = line;
        }
        return line[pixelX];
    }

    @Override
    public void dispose() {
        this.clearCache();
        if (this.product != null) {
            this.product.dispose();
            this.product = null;
        }
    }

    protected void addGravitationalModel(int index, float[] line) throws Exception {
    }
}

