/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.dem;

import java.text.ParseException;

public class EastingNorthingParser {
    private static final int ILLEGAL_DIRECTION_VALUE = -999;
    private static final int directionWest = 0;
    private static final int directionEast = 1;
    private static final int directionNorth = 2;
    private static final int directionSouth = 3;
    private static final int indexEasting = 0;
    private static final int indexNorthing = 1;
    private String text;
    private int pos;
    private final String allowedSuffix;
    private static final char EOF = '\uffff';

    public EastingNorthingParser(String text, String allowedSuffix) {
        this.text = text;
        this.pos = -1;
        this.allowedSuffix = allowedSuffix;
    }

    public int[] parse() throws ParseException {
        return this.parseImpl();
    }

    private int[] parseImpl() throws ParseException {
        int[] eastingNorthing = new int[]{-999, -999};
        this.parseDirectionValueAndAssign(eastingNorthing);
        this.parseDirectionValueAndAssign(eastingNorthing);
        this.validateThatValuesAreAssigned(eastingNorthing);
        this.validateCorrectSuffix();
        return eastingNorthing;
    }

    private void validateThatValuesAreAssigned(int[] eastingNorthing) throws ParseException {
        if (eastingNorthing[0] == -999) {
            throw new ParseException("Easting value not available.", -1);
        }
        if (eastingNorthing[1] == -999) {
            throw new ParseException("Northing value not available.", -1);
        }
    }

    private void validateCorrectSuffix() throws ParseException {
        String suffix;
        if (!(suffix = this.text.substring(++this.pos)).matches(this.allowedSuffix)) {
            throw new ParseException("Illegal string format.", this.pos);
        }
    }

    protected void parseDirectionValueAndAssign(int[] eastingNorthing) throws ParseException {
        int value = this.readNumber();
        int direction = this.getDirection();
        value = this.correctValueByDirection(value, direction);
        this.assignValueByDirection(eastingNorthing, value, direction);
    }

    protected void assignValueByDirection(int[] eastingNorthing, int value, int direction) {
        if (this.isWest(direction) || this.isEast(direction)) {
            eastingNorthing[0] = value;
        } else {
            eastingNorthing[1] = value;
        }
    }

    protected int correctValueByDirection(int value, int direction) throws ParseException {
        if (this.isWest(direction) && ((value *= this.isWest(direction) || this.isSouth(direction) ? -1 : 1) > 0 || value < -180)) {
            throw new ParseException("The value '" + value + "' for west direction is out of the range -180 ... 0.", this.pos);
        }
        if (this.isEast(direction) && (value < 0 || value > 180)) {
            throw new ParseException("The value '" + value + "' for east direction is out of the range 0 ... 180.", this.pos);
        }
        if (this.isSouth(direction) && (value > 0 || value < -90)) {
            throw new ParseException("The value '" + value + "' for south direction is out of the range -90 ... 0.", this.pos);
        }
        if (this.isNorth(direction) && (value < 0 || value > 90)) {
            throw new ParseException("The value '" + value + "' for north direction is out of the range 0 ... 90.", this.pos);
        }
        return value;
    }

    private boolean isNorth(int direction) {
        return this.compareDirection(2, direction);
    }

    private boolean isEast(int direction) {
        return this.compareDirection(1, direction);
    }

    private boolean isSouth(int direction) {
        return this.compareDirection(3, direction);
    }

    private boolean isWest(int direction) {
        return this.compareDirection(0, direction);
    }

    private boolean compareDirection(int expected, int direction) {
        return expected == direction;
    }

    protected int getDirection() throws ParseException {
        char c = this.nextChar();
        if (c == 'w' || c == 'W') {
            return 0;
        }
        if (c == 'e' || c == 'E') {
            return 1;
        }
        if (c == 'n' || c == 'N') {
            return 2;
        }
        if (c == 's' || c == 'S') {
            return 3;
        }
        throw new ParseException("Illegal direction character.", this.pos);
    }

    protected int readNumber() throws ParseException {
        char c = this.nextChar();
        if (!Character.isDigit(c)) {
            throw new ParseException("Digit character expected.", this.pos);
        }
        int value = 0;
        while (Character.isDigit(c)) {
            value *= 10;
            value += c - 48;
            c = this.nextChar();
        }
        --this.pos;
        return value;
    }

    private char nextChar() {
        ++this.pos;
        return this.pos < this.text.length() ? this.text.charAt(this.pos) : (char)'\uffff';
    }
}

