/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.dem;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.ElevationTile;
import org.esa.snap.core.dataop.downloadable.FtpDownloader;
import org.esa.snap.core.dataop.downloadable.SSLUtil;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;

public abstract class ElevationFile {
    protected File localFile;
    protected File localZipFile;
    protected final ProductReader productReader;
    private boolean localFileExists = false;
    protected boolean remoteFileExists = true;
    private boolean errorInLocalFile = false;
    protected ElevationTile tile = null;
    private FtpDownloader ftp = null;
    private Map<String, Long> fileSizeMap = null;
    private boolean unrecoverableError = false;

    public ElevationFile(File localFile, ProductReader reader) {
        this.localFile = localFile;
        this.localZipFile = new File(localFile.getParentFile(), FileUtils.getFilenameWithoutExtension(localFile) + ".zip");
        this.productReader = reader;
    }

    public void dispose() {
        try {
            if (this.ftp != null) {
                this.ftp.disconnect();
            }
            this.ftp = null;
            this.tile.dispose();
            this.tile = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getFileName() {
        return this.localFile.getName();
    }

    public final ElevationTile getTile() throws IOException {
        if (this.tile == null) {
            if (!this.remoteFileExists && !this.localFileExists) {
                return null;
            }
            this.getFile();
        }
        return this.tile;
    }

    protected ElevationTile createTile(Product product) throws IOException {
        return null;
    }

    protected boolean findLocalFile() {
        return this.localFile.exists() && this.localFile.isFile() || this.localZipFile.exists() && this.localZipFile.isFile();
    }

    private synchronized void getFile() throws IOException {
        block11: {
            try {
                if (this.tile != null) {
                    return;
                }
                if (!this.localFileExists && !this.errorInLocalFile) {
                    this.localFileExists = this.findLocalFile();
                }
                if (this.localFileExists) {
                    this.getLocalFile();
                } else if (this.remoteFileExists && this.getRemoteFile().booleanValue()) {
                    this.getLocalFile();
                }
                if (this.tile != null) {
                    this.errorInLocalFile = false;
                } else {
                    if (!this.remoteFileExists && this.localFileExists) {
                        SystemUtils.LOG.severe("Unable to reader product " + this.localFile.getAbsolutePath());
                    }
                    this.localFileExists = false;
                    this.errorInLocalFile = true;
                }
            }
            catch (IOException e) {
                SystemUtils.LOG.severe(e.getMessage());
                this.tile = null;
                this.localFileExists = false;
                this.errorInLocalFile = true;
                if (e.getCause() instanceof UnsupportedOperationException) {
                    this.unrecoverableError = true;
                }
                if (!this.unrecoverableError) break block11;
                throw e;
            }
        }
    }

    protected void getLocalFile() throws IOException {
        Product product = null;
        if (this.localFile.exists()) {
            product = this.productReader.readProductNodes(this.localFile, null);
        } else if (this.localZipFile.exists()) {
            product = this.productReader.readProductNodes(this.localZipFile, null);
        }
        if (product != null) {
            this.tile = this.createTile(product);
        }
    }

    protected abstract Boolean getRemoteFile() throws IOException;

    protected Boolean getRemoteHttpFile(String baseUrl) throws IOException {
        String remotePath = baseUrl + this.localZipFile.getName();
        SystemUtils.LOG.info("http retrieving " + remotePath);
        try {
            ElevationFile.downloadFile(new URL(remotePath), this.localZipFile);
            return true;
        }
        catch (FileNotFoundException e) {
            SystemUtils.LOG.warning("http error:" + e.getMessage() + " on " + remotePath);
            this.remoteFileExists = false;
        }
        catch (Exception e) {
            throw e;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File downloadFile(URL fileUrl, File localZipFile) throws IOException {
        SSLUtil sslUtil = new SSLUtil();
        sslUtil.disableSSLCertificateCheck();
        File outputFile = new File(localZipFile.getParentFile(), new File(fileUrl.getFile()).getName());
        URLConnection urlConnection = fileUrl.openConnection();
        int contentLength = urlConnection.getContentLength();
        try (BufferedInputStream is = new BufferedInputStream(urlConnection.getInputStream(), contentLength);
             FileOutputStream fileOS = new FileOutputStream(outputFile);
             BufferedOutputStream os = new BufferedOutputStream(fileOS);){
            try {
                int b;
                int n;
                StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.DATA_TRANSFER);
                status.beginTask("Downloading " + localZipFile.getName() + "... ", contentLength);
                int size = 32768;
                byte[] buf = new byte[32768];
                while ((n = ((InputStream)is).read(buf, 0, 32768)) > -1) {
                    ((OutputStream)os).write(buf, 0, n);
                    status.worked(n);
                }
                status.done();
                while ((b = ((InputStream)is).read()) != -1) {
                    ((OutputStream)os).write(b);
                }
            }
            catch (IOException e) {
                outputFile.delete();
                throw e;
            }
        }
        finally {
            sslUtil.enableSSLCertificateCheck();
        }
        return outputFile;
    }

    protected Boolean getRemoteFTPFile(String remoteFTP, String remotePath) throws IOException {
        try {
            if (this.ftp == null) {
                this.ftp = new FtpDownloader(remoteFTP);
                this.fileSizeMap = FtpDownloader.readRemoteFileList(this.ftp, remoteFTP, remotePath);
            }
            String remoteFileName = this.localZipFile.getName();
            Long fileSize = this.fileSizeMap.get(remoteFileName);
            FtpDownloader.FTPError result = this.ftp.retrieveFile(remotePath + remoteFileName, this.localZipFile, fileSize);
            if (result == FtpDownloader.FTPError.OK) {
                return true;
            }
            if (result == FtpDownloader.FTPError.FILE_NOT_FOUND) {
                this.remoteFileExists = false;
            } else {
                this.dispose();
            }
            this.localZipFile.delete();
            return false;
        }
        catch (SocketException e) {
            this.unrecoverableError = true;
            throw e;
        }
        catch (Exception e) {
            SystemUtils.LOG.info(e.getMessage());
            if (this.ftp == null) {
                this.unrecoverableError = false;
                this.remoteFileExists = false;
                throw new IOException("Failed to connect to FTP " + remoteFTP + '\n' + e.getMessage());
            }
            this.dispose();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getZipInputStream(File dataFile) throws IOException {
        String ext = FileUtils.getExtension(dataFile.getName());
        if (ext != null && ext.equalsIgnoreCase(".zip")) {
            String baseName = this.localFile.getName();
            try (ZipFile zipFile = null;){
                String folderName;
                zipFile = new ZipFile(dataFile);
                ZipEntry zipEntry = zipFile.getEntry(baseName);
                if (zipEntry == null && (zipEntry = zipFile.getEntry(baseName.toLowerCase())) == null && (zipEntry = zipFile.getEntry((folderName = FileUtils.getFilenameWithoutExtension(dataFile.getName())) + '/' + this.localFile.getName())) == null) {
                    this.localFileExists = false;
                    throw new IOException("Entry '" + baseName + "' not found in zip file.");
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                return inputStream;
            }
        }
        return null;
    }
}

