/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.downloadable;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.dataop.downloadable.ProgressMonitorList;

public final class StatusProgressMonitor
implements ProgressMonitor {
    private int lastPct = 0;
    private String name;
    private double currentWork;
    private double totalWork;
    private boolean cancelRequested;
    private String text;
    private final TYPE taskType;
    private final List<Listener> listenerList = new ArrayList<Listener>();

    public StatusProgressMonitor() {
        this(TYPE.SUBTASK);
    }

    public StatusProgressMonitor(TYPE taskType) {
        this.taskType = taskType;
    }

    protected void finalize() throws Throwable {
        ProgressMonitorList.instance().remove(this);
        super.finalize();
    }

    public void beginTask(String name, int totalWork) {
        Assert.notNull((Object)name, (String)"name");
        this.name = name;
        this.currentWork = 0.0;
        this.totalWork = totalWork;
        this.cancelRequested = false;
        this.text = "";
        ProgressMonitorList.instance().add(this);
    }

    public void internalWorked(double work) {
        this.currentWork += work;
        int pct = (int)(this.currentWork / this.totalWork * 100.0);
        if (pct >= this.lastPct + 1) {
            this.setText(this.name + pct + '%');
            this.lastPct = pct;
        }
    }

    public boolean isCanceled() {
        return this.cancelRequested;
    }

    public void setCanceled(boolean canceled) {
        this.cancelRequested = canceled;
    }

    public void setTaskName(String taskName) {
    }

    public void setSubTaskName(String subTaskName) {
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    public void done() {
        this.setText("");
        this.fireNotification(Notification.DONE);
        ProgressMonitorList.instance().remove(this);
    }

    private void setText(String text) {
        this.text = text;
        this.fireNotification(Notification.UPDATE);
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public TYPE getTaskType() {
        return this.taskType;
    }

    public int getMax() {
        return (int)this.totalWork;
    }

    public int getPercentComplete() {
        return this.lastPct;
    }

    public void addListener(Listener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    private void fireNotification(Notification msg) {
        for (Listener listener : this.listenerList) {
            listener.notifyMsg(msg);
        }
    }

    public static interface Listener {
        public void notifyMsg(Notification var1);
    }

    public static enum Notification {
        UPDATE,
        DONE;

    }

    public static enum TYPE {
        DATA_TRANSFER,
        SUBTASK;

    }
}

