/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.maptransf;

import java.awt.geom.Point2D;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.dataop.maptransf.MapTransform;

@Deprecated
public abstract class CartographicMapTransform
implements MapTransform {
    protected final double _centralMeridian;
    protected final double _a;
    protected final double _invA;
    protected final double _x0;
    protected final double _y0;

    protected CartographicMapTransform(double centralMeridian, double falseEasting, double falseNorthing, double semiMajor) {
        this._centralMeridian = centralMeridian;
        this._x0 = falseEasting;
        this._y0 = falseNorthing;
        this._a = semiMajor;
        this._invA = 1.0 / semiMajor;
    }

    public double getCentralMeridian() {
        return this._centralMeridian;
    }

    public double getSemiMajor() {
        return this._a;
    }

    public double getInverseSemiMajor() {
        return this._invA;
    }

    public double getFalseEasting() {
        return this._x0;
    }

    public double getFalseNorthing() {
        return this._y0;
    }

    @Override
    public Point2D forward(GeoPos geoPoint, Point2D mapPoint) {
        double lon0;
        if (mapPoint == null) {
            mapPoint = new Point2D.Double();
        }
        if ((lon0 = geoPoint.getLon() - this._centralMeridian) < -180.0) {
            lon0 = (float)(360.0 + lon0);
        }
        if (lon0 > 180.0) {
            lon0 = (float)(lon0 - 360.0);
        }
        mapPoint = this.forward_impl(geoPoint.getLat(), lon0, mapPoint);
        mapPoint.setLocation(this._a * mapPoint.getX() + this._x0, this._a * mapPoint.getY() + this._y0);
        return mapPoint;
    }

    @Override
    public GeoPos inverse(Point2D mapPoint, GeoPos geoPoint) {
        if (geoPoint == null) {
            geoPoint = new GeoPos();
        }
        geoPoint = this.inverse_impl((mapPoint.getX() - this._x0) * this._invA, (mapPoint.getY() - this._y0) * this._invA, geoPoint);
        geoPoint.setLocation(geoPoint.getLat(), geoPoint.getLon() + this._centralMeridian);
        return geoPoint;
    }

    protected abstract Point2D forward_impl(double var1, double var3, Point2D var5);

    protected abstract GeoPos inverse_impl(double var1, double var3, GeoPos var5);
}

