/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.maptransf;

import java.awt.geom.Point2D;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.dataop.maptransf.CartographicMapTransform;
import org.esa.snap.core.dataop.maptransf.DefaultMapTransformUI;
import org.esa.snap.core.dataop.maptransf.Ellipsoid;
import org.esa.snap.core.dataop.maptransf.MapProjection;
import org.esa.snap.core.dataop.maptransf.MapProjectionRegistry;
import org.esa.snap.core.dataop.maptransf.MapTransform;
import org.esa.snap.core.dataop.maptransf.MapTransformDescriptor;
import org.esa.snap.core.dataop.maptransf.MapTransformUI;
import org.esa.snap.core.dataop.maptransf.MapTransformUtils;
import org.esa.snap.core.param.Parameter;

@Deprecated
public class StereographicDescriptor
implements MapTransformDescriptor {
    public static final String TYPE_ID = "Stereographic";
    public static final String NAME = "Stereographic";
    public static final String MAP_UNIT = "meter";
    private static final int SEMI_MAJOR_INDEX = 0;
    private static final int SEMI_MINOR_INDEX = 1;
    private static final int LATITUDE_OF_ORIGIN_INDEX = 2;
    private static final int CENTRAL_MERIDIAN_INDEX = 3;
    private static final int SCALE_FACTOR_INDEX = 4;
    private static final int FALSE_EASTING_INDEX = 5;
    private static final int FALSE_NORTHING_INDEX = 6;
    private static final String[] PARAMETER_NAMES = new String[]{"semi_major", "semi_minor", "latitude_of_origin", "central_meridian", "scale_factor", "false_easting", "false_northing"};
    private static final String[] PARAMETER_LABELS = new String[]{"Semi major", "Semi minor", "Latitude of origin", "Central meridian", "Scale factor", "False easting", "False northing"};
    private static final String[] PARAMETER_UNITS = new String[]{"meter", "meter", "degree", "degree", "", "meter", "meter"};
    public static final double[] PARAMETER_DEFAULT_VALUES = new double[]{Ellipsoid.WGS_84.getSemiMajor(), Ellipsoid.WGS_84.getSemiMinor(), 90.0, 0.0, 1.0, 0.0, 0.0};
    private static final double[] UPS_NORTH_PARAMETER_VALUES = new double[]{Ellipsoid.WGS_84.getSemiMajor(), Ellipsoid.WGS_84.getSemiMinor(), 90.0, 0.0, 0.994, 2000000.0, 2000000.0};
    private static final double[] UPS_SOUTH_PARAMETER_VALUES = new double[]{Ellipsoid.WGS_84.getSemiMajor(), Ellipsoid.WGS_84.getSemiMinor(), -90.0, 0.0, 0.994, 2000000.0, 2000000.0};
    public static final String UPS_NORTH_NAME = "Universal Polar Stereographic North";
    public static final String UPS_SOUTH_NAME = "Universal Polar Stereographic South";

    @Override
    public void registerProjections() {
        MapProjectionRegistry.registerProjection(new MapProjection(this.getName(), this.createTransform(PARAMETER_DEFAULT_VALUES), false));
        MapProjectionRegistry.registerProjection(new MapProjection(UPS_NORTH_NAME, this.createTransform(UPS_NORTH_PARAMETER_VALUES), true));
        MapProjectionRegistry.registerProjection(new MapProjection(UPS_SOUTH_NAME, this.createTransform(UPS_SOUTH_PARAMETER_VALUES), true));
    }

    @Override
    public String getTypeID() {
        return "Stereographic";
    }

    @Override
    public String getName() {
        return "Stereographic";
    }

    @Override
    public String getMapUnit() {
        return MAP_UNIT;
    }

    @Override
    public double[] getParameterDefaultValues() {
        double[] values = new double[PARAMETER_DEFAULT_VALUES.length];
        System.arraycopy(PARAMETER_DEFAULT_VALUES, 0, values, 0, values.length);
        return values;
    }

    @Override
    public Parameter[] getParameters() {
        Parameter[] parameters = new Parameter[PARAMETER_NAMES.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = new Parameter(PARAMETER_NAMES[i], PARAMETER_DEFAULT_VALUES[i]);
            parameters[i].getProperties().setLabel(PARAMETER_LABELS[i]);
            parameters[i].getProperties().setPhysicalUnit(PARAMETER_UNITS[i]);
        }
        return parameters;
    }

    @Override
    public boolean hasTransformUI() {
        return true;
    }

    @Override
    public MapTransformUI getTransformUI(MapTransform transform) {
        return new DefaultMapTransformUI(transform);
    }

    @Override
    public MapTransform createTransform(double[] parameterValues) {
        if (parameterValues == null) {
            parameterValues = PARAMETER_DEFAULT_VALUES;
        }
        return new ST(parameterValues);
    }

    @Deprecated
    public class ST
    extends CartographicMapTransform {
        private static final double CONV = 1.0E-10;
        private static final double EPS10 = 1.0E-10;
        private static final double HALFPI = 1.5707963267948966;
        private static final int NITER = 8;
        private static final int S_POLE = 0;
        private static final int N_POLE = 1;
        private static final int OBLIQ = 2;
        private static final int EQUIT = 3;
        private final double[] _parameterValues;
        private final int _mode;
        private final double _e;
        private double _akm1;
        private double _sinX1;
        private double _cosX1;

        public ST(double[] parameterValues) {
            super(parameterValues[3], parameterValues[5], parameterValues[6], parameterValues[0]);
            double b = parameterValues[1];
            this._e = Math.sqrt(1.0 - b * b / (this._a * this._a));
            double phi0 = Math.toRadians(parameterValues[2]);
            double k0 = parameterValues[4];
            double absphi0 = Math.abs(phi0);
            this._mode = Math.abs(absphi0 - 1.5707963267948966) < 1.0E-10 ? (phi0 < 0.0 ? 0 : 1) : (absphi0 > 1.0E-10 ? 2 : 3);
            switch (this._mode) {
                case 0: 
                case 1: {
                    this._akm1 = 2.0 * k0 / Math.sqrt(Math.pow(1.0 + this._e, 1.0 + this._e) * Math.pow(1.0 - this._e, 1.0 - this._e));
                    break;
                }
                case 3: {
                    this._akm1 = 2.0 * k0;
                    break;
                }
                case 2: {
                    double t = Math.sin(phi0);
                    double X = 2.0 * Math.atan(MapTransformUtils.ssfn(phi0, t, this._e)) - 1.5707963267948966;
                    this._akm1 = 2.0 * k0 * Math.cos(phi0) / Math.sqrt(1.0 - (t *= this._e) * t);
                    this._sinX1 = Math.sin(X);
                    this._cosX1 = Math.cos(X);
                }
            }
            this._parameterValues = new double[parameterValues.length];
            System.arraycopy(parameterValues, 0, this._parameterValues, 0, this._parameterValues.length);
        }

        @Override
        public MapTransformDescriptor getDescriptor() {
            return StereographicDescriptor.this;
        }

        @Override
        public double[] getParameterValues() {
            double[] values = new double[this._parameterValues.length];
            System.arraycopy(this._parameterValues, 0, values, 0, values.length);
            return values;
        }

        @Override
        public Point2D forward_impl(double lat, double lon, Point2D mapPoint) {
            double phi = Math.toRadians(lat);
            double lam = Math.toRadians(lon);
            double coslam = Math.cos(lam);
            double sinlam = Math.sin(lam);
            double sinphi = Math.sin(phi);
            double sinX = 0.0;
            double cosX = 0.0;
            double A = 0.0;
            if (this._mode == 2 || this._mode == 3) {
                double X = 2.0 * Math.atan(MapTransformUtils.ssfn(phi, sinphi, this._e)) - 1.5707963267948966;
                sinX = Math.sin(X);
                cosX = Math.cos(X);
            }
            if (mapPoint == null) {
                mapPoint = new Point2D.Double();
            }
            switch (this._mode) {
                case 2: {
                    A = this._akm1 / (this._cosX1 * (1.0 + this._sinX1 * sinX + this._cosX1 * cosX * coslam));
                    mapPoint.setLocation(A * cosX, A * (this._cosX1 * sinX - this._sinX1 * cosX * coslam));
                    break;
                }
                case 3: {
                    A = 2.0 * this._akm1 / (1.0 + cosX * coslam);
                    mapPoint.setLocation(A * cosX, A * sinX);
                    break;
                }
                case 0: {
                    A = this._akm1 * MapTransformUtils.tsfn(-phi, -sinphi, this._e);
                    mapPoint.setLocation(A, A * coslam);
                    break;
                }
                case 1: {
                    A = this._akm1 * MapTransformUtils.tsfn(phi, sinphi, this._e);
                    mapPoint.setLocation(A, -A * coslam);
                }
            }
            mapPoint.setLocation(mapPoint.getX() * sinlam, mapPoint.getY());
            return mapPoint;
        }

        @Override
        public GeoPos inverse_impl(double x, double y, GeoPos geoPoint) {
            double sinphi;
            double rho = Math.sqrt(x * x + y * y);
            double tp = 0.0;
            double phi_l = 0.0;
            double halfe = 0.0;
            double halfpi = 0.0;
            switch (this._mode) {
                case 2: 
                case 3: {
                    tp = 2.0 * Math.atan2(rho * this._cosX1, this._akm1);
                    double cosphi = Math.cos(tp);
                    sinphi = Math.sin(tp);
                    phi_l = rho == 0.0 ? Math.asin(cosphi * this._sinX1) : Math.asin(cosphi * this._sinX1 + y * sinphi * this._cosX1 / rho);
                    tp = Math.tan(0.5 * (1.5707963267948966 + phi_l));
                    x *= sinphi;
                    y = rho * this._cosX1 * cosphi - y * this._sinX1 * sinphi;
                    halfpi = 1.5707963267948966;
                    halfe = 0.5 * this._e;
                    break;
                }
                case 1: {
                    y = -y;
                }
                case 0: {
                    tp = -rho / this._akm1;
                    phi_l = 1.5707963267948966 - 2.0 * Math.atan(tp);
                    halfpi = -1.5707963267948966;
                    halfe = -0.5 * this._e;
                }
            }
            double phi = 0.0;
            double lam = 0.0;
            for (int i = 8; i > 0; --i) {
                sinphi = this._e * Math.sin(phi_l);
                phi = 2.0 * Math.atan(tp * Math.pow((1.0 + sinphi) / (1.0 - sinphi), halfe)) - halfpi;
                if (Math.abs(phi_l - phi) < 1.0E-10) {
                    if (this._mode == 0) {
                        phi = -phi;
                    }
                    lam = x == 0.0 && y == 0.0 ? 0.0 : Math.atan2(x, y);
                    break;
                }
                phi_l = phi;
            }
            if (geoPoint == null) {
                geoPoint = new GeoPos();
            }
            geoPoint.setLocation(Math.toDegrees(phi), Math.toDegrees(lam));
            return geoPoint;
        }

        @Override
        public MapTransform createDeepClone() {
            return new ST(this._parameterValues);
        }

        public double getSemiMinor() {
            return this._parameterValues[1];
        }

        public double getLatitudeOfOrigin() {
            return this._parameterValues[2];
        }

        public double getScaleFactor() {
            return this._parameterValues[4];
        }

        public boolean isPolar() {
            return this._mode == 1 || this._mode == 0;
        }

        public boolean isOblique() {
            return this._mode == 2;
        }
    }
}

